/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#define SEPARATOR1 "/"
#define SEPARATOR2 Chr(254)

////////////////
////////////////
//
// Purpose:
//    not used
//
// Syntax:
//    fCreateRpt(<cFile>, <aReport>) -> NIL
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cFile       Report file name
//    aReport     Contents of report definition
//
// Returns:
//    NIL
//
// Files:
//    (<cFile>.rpt)
//
// Description:
//    not used - for future expansion
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fCreateRPT(cFilename, aReport)
   LOCAL nFile, nCtr, nMax, cByte := ""
   nFile := fCreate(fExtNew(Trim(cFilename), "RPT"))
   IF aReport[1]!=NIL
      fWrite(nFile, "R"+aReport[1]+SEPARATOR1)
   ENDIF
   IF aReport[2]!=NIL
      fWrite(nFile, "P"+aReport[2]+SEPARATOR1)
   ENDIF
   IF aReport[3]!=NIL
      nMax := Len(aReport[3])
      FOR nCtr := 1 to nMax
         fWrite(nFile, "G"+Chr(aReport[3, nCtr]))
         fWrite(nFile, "H"+aReport[4, nCtr]+SEPARATOR2)
         fWrite(nFile, "E"+aReport[5, nCtr]+SEPARATOR2)
         fWrite(nFile, "F"+aReport[6, nCtr]+SEPARATOR2)
         fWrite(nFile, "L"+bBitIf("", 1, aReport[7, nCtr])+SEPARATOR2)
      NEXT
   ENDIF
   IF aReport[10]!=NIL
      nMax := Len(aReport[10])
      FOR nCtr := 1 to nMax
         fWrite(nFile, "CH"+aReport[10, nCtr]+SEPARATOR2)
         fWrite(nFile, "E"+aReport[11, nCtr]+SEPARATOR2)
         fWrite(nFile, "W"+Chr(aReport[12, nCtr])+SEPARATOR2)
         fWrite(nFile, "P"+aReport[13, nCtr]+SEPARATOR2)
         fWrite(nFile, "T"+aReport[14, nCtr]+SEPARATOR2)
         fWrite(nFile, "D"+Chr(aReport[15, nCtr])+SEPARATOR2)
         fWrite(nFile, "X"+aReport[16, nCtr]+SEPARATOR2)
         fWrite(nFile, "C"+aReport[17, nCtr]+SEPARATOR2)
         fWrite(nFile, "D"+aReport[18, nCtr]+SEPARATOR2)
      NEXT
   ENDIF
   IF aReport[25]!=NIL
      nMax := Len(aReport[25])
      FOR nCtr := 1 to nMax
         fWrite(nFile, "IS"+aReport[25, nCtr]+SEPARATOR2)
         cByte := bBitIf("", 1, aReport[26, nCtr])
         cByte := bBitIf(cByte, 1, aReport[27, nCtr])
         fWrite(nFile, "L"+cByte+SEPARATOR2)
         fWrite(nFile, "N"+Chr(aReport[33, nCtr])+SEPARATOR2)
         fWrite(nFile, "M"+Chr(aReport[34, nCtr])+SEPARATOR2)
         fWrite(nFile, "O"+aReport[35, nCtr]+SEPARATOR2)
         fWrite(nFile, "C"+aReport[36, nCtr]+SEPARATOR2)
         fWrite(nFile, "D"+aReport[37, nCtr]+SEPARATOR2)
      NEXT
   ENDIF
   fClose(nFile)
ENDFUNCTION

