/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Copies common field information from current work area to specified area
//
// Syntax:
//    fCopyCommon(<cTarget>) -> NIL
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cTarget     Alias name of target (destination) work area
//
// Returns:
//    NIL
//
// Examples:
//    #include "beckner.inc"
//    #include "alias.ch"
//    FUNCTION TestIt()
//       CreateTest()
//       CreateTarget()
//       ADDRECORD ALIAS Target
//       Test->(fCopyCommon("Target"))  /* Copies record #1 in Test to  */
//                                      /* Target                       */
//       CLOSE Test
//       CLOSE Target
//    ENDFUNCTION
//
//    STATIC FUNCTION CreateTest()
//       fCreateDbf("Test/Name/C/32/Balance/N/12/2/Date/D/Over21/L/Notes/M")
//       USE Test NEW EXCLUSIVE
//       ADDRECORD ALIAS Test
//       Test->Name    := "Abbott, Jake"
//       Test->Balance := 0.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, John Wm"
//       Test->Balance := 15000.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := "These are notes!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Elizabeth Anne"
//       Test->Balance := 0.58
//       Test->Date    := CtoD("12/18/96")
//       Test->Over21  := .n.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Joseph Alan"
//       Test->Balance := 1.68
//       Test->Date    := CtoD("6/10/98")
//       Test->Over21  := .n.
//       Test->Notes   := "These are too!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Zumundi, Beavis"
//       Test->Balance := 123.45
//       Test->Date    := CtoD("")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       GO TOP
//    ENDFUNCTION
//
//    STATIC FUNCTION CreateTarget()
//       fCreateDbf("Target/Name/C/32/Balance/N/12/2/Date/D/Over21/L/Notes/M")
//       USE Target NEW EXCLUSIVE
//    ENDFUNCTION
//
//
// Files:
//    none
//
// Description:
//    Full
//
// See Also:
//    x
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fCopyCommon(c2Alias)
   fEval({|cField| iif(Type(cField)==Type(c2Alias+"->"+cField),;
         Eval(FieldWBlock(cField, Select(c2Alias)),;
         FieldGet(FieldPos(cField))),)})
ENDFUNCTION
