/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Blanks the current record
//
// Syntax:
//    fBlankRec() -> NIL
//
// Formal Arguments: (0)
//
// Returns:
//    NIL
//
// Examples:
//
// Files:
//    none
//
// Description:
//    This function blanks all fields in the current record.
//
// See Also:
//
// Category:
//    Field Function
//
// Revisions:
//    06/18/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fBlankRec()
   LOCAL nCtr, cFieldType
   FOR nCtr := 1 TO fCount()
      cFieldType := ValType(FieldGet(nCtr))
      DO CASE
      CASE cFieldType$"CM"
         FieldPut(nCtr, "")
      CASE cFieldType="N"
         FieldPut(nCtr, 0)
      CASE cFieldType="L"
         FieldPut(nCtr, .n.)
      CASE cFieldType="D"
         FieldPut(nCtr, dEmpty())
      ENDCASE
   NEXT
ENDFUNCTION
