/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the week of the year
//
// Syntax:
//    dWeekNum([<dAny>]) -> nWeek
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dAny        Any date
//
// Returns:
//    nWeek       Week number in year
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("9.26.94")
//       ? dWeekNum(dTest)       /* 39 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the week number wherein the date resides in the year.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dWeekNum(dDate)
   LOCAL nDOY
   DEFAULT dDate TO Date()
   nDOY := dDayOfYear(dDate)-1
   RETURN Int(nDOY/7+iif(nDOY%7<=DOW(dDate), 1, 2))
ENDFUNCTION
