/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns .true. if the string contains a valid date expression
//
// Syntax:
//    dStrFormat(<cDate>) -> lValid
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cDate       Any string
//
// Returns:
//    lValid      .y. if cDate can be converted to non-empty date value
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cTest1 := "Apples", cTest2 := "12.18.96"
//       ? dStrFormat(cTest1)    /* .f. */
//       ? dStrFormat(cTest2)    /* .t. */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns .true. if the string expression contains a valid date expression,
//    which is a non-empty date expression.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dStrFormat(cDate)
   RETURN !Empty(CtoD(cDate))
ENDFUNCTION

