/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns a compressed format date string
//
// Syntax:
//    dSave(<dUncompress>) -> cCompress
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dUncompress Any date
//
// Returns:
//    cCompress   Compressed format date string
//
// Examples:
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("9/26/96"), cCompressed
//       cCompressed := dSave(dTest)
//       ? Len(cCompressed)         /* 3        */
//       ? dRestore(cCompressed)    /* 09/26/96 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns a compressed format date string.
//
// See Also:
//    dRestore()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dSave(d2Save)
   RETURN Chr(Month(d2Save))+Chr(Day(d2Save))+Chr(Year(d2Save)-1900)
ENDFUNCTION
