/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns a date string of the form "MM/YY"
//
// Syntax:
//    dMMYY([<dAny>]) -> cMMYY
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dAny        Any date [Date()]
//
// Returns:
//    cMMYY       String date in form "MM/YY"
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("1/1/96")
//       ? dMMYY(dTest)       /* "01/96" */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns a string date in the form "MM/YY", essentially removing the
//    day from the date.
//
// See Also:
//    dWord()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dMMYY(dAny)
   LOCAL cDate
   DEFAULT dAny TO Date()
   cDate := DtoC(dAny)
   RETURN Left(cDate, 2)+"/"+Right(cDate, 2)
ENDFUNCTION
