/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns .true. if test date within a range of dates
//
// Syntax:
//    dInRange(<dTest>, <dFirst>, <dLast>, [<lInclusive>]) -> lInclusive
//
// Formal Arguments: (4)
//    Name        Description
//    ___________ ____________
//    dTest       Date to test
//    dFirst      First date in range
//    dLast       Last date in range
//    lInclusive  .true. to include dFirst and dLast in date check
//
// Returns:
//    lInRange    .true. if dTest within specified range
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest  := CtoD("1/26/94")
//       LOCAL dFirst := CtoD("1/10/94"), dLast := dTest
//       ? dInRange(dTest, dFirst, dLast, .n.)     /* False */
//       ? dInRange(dTest, dFirst, dLast, .y.)     /* True  */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns .true. if <dTest> is between <dFirst> and <dLast>.  If
//    <lInclusive>, then this function will return .true. if <dTest> is
//    between <dFirst> and <dLast>, or is equal to either <dFirst> or <dLast>.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dInRange(dTest, dFirst, dLast, lInclusive)
   DEFAULT lInclusive TO .y.
   IF lInclusive
      RETURN dTest>=dFirst .and. dTest<=dLast
   ENDIF
   RETURN dTest>dFirst .and. dTest<dLast
ENDFUNCTION
