/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the number of days left in the specified month
//
// Syntax:
//    dDaysLeftM([<dTest>]) -> nDaysLeft
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dTest       Any date [Date()]
//
// Returns:
//    nDaysLeft   Number of days remaining
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("9/26/94")
//       ? dDaysLeftM(dTest)              /* 4 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the number of days remaining in the month specified in <dTest>,
//    which defaults to the current system date.
//
// See Also:
//    dDaysGoneM()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dDaysLeftM(dDate)
   DEFAULT dDate TO Date()
   RETURN dDaysInMonth(dDate)-Day(dDate)
ENDFUNCTION
