/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "alias.ch"
#include "inkey.ch"
#include "box.ch"

STATIC nSystem := 1, glDate, nPeriod
FIELD System, Acct_No, Name, PTD, YTD, Type, notes, ptd1, ptd2, ptd3, ptd4, ptd5
FIELD ptd6, ptd7, ptd8, ptd9, ptd10, ptd11, ptd12, ptd13, descrip, date
FIELD hptd1, hptd2, hptd3, hptd4, hptd5, amount, reference, code, address1
FIELD hptd6, hptd7, hptd8, hptd9, hptd10, hptd11, hptd12, hptd13, address2
FIELD city, state, zip_code, phone, syschkno, sysprt132e, sysprt132d
FIELD sysbell, color_set, blink_set
MEMVAR GetList, aRC, cHistory, glOpt, cPeriod, a, oldrec, glrec, an, nd_val1, nd_val2, x
MEMVAR mtype, wscreen, old_acct, new_acct, ctr, start_date, end_date, opt
MEMVAR acct, lasta, lastacct, lastd, prtchk, desc, ref, dt, tempa, rpt_date
MEMVAR cons_str, pnet, ynet, line, gtotal, xtotal, g1, pl, Y_PCT, P_PCT
MEMVAR EY_PCT, EP_PCT, RY_PCT, RP_PCT, CY_PCT, CP_PCT, SY_PCT, SP_PCT
MEMVAR Y_TOTAL, P_TOTAL, p_amount, y_amount, p_cost, y_cost, lastamt
MEMVAR p_sales, y_sales, hdr, hdrn, p_gross, y_gross, p_other, y_other, nd_val
MEMVAR p_revenue, y_revenue, trp_pct, try_pct, tp_expense, ty_expense, rptdate
MEMVAR p_taxes, y_taxes, p_net_pct, p_net_amt, y_net_pct, y_net_amt, b, quit_it
MEMVAR npd, cpd, sdate, edate, rec, gls, ac, xxrow, xxcol, old, rr, py, px, qy, qx
MEMVAR trow, tcol, yscreen, old_rec, srec, noffice

FUNCTION BecknerGL(dPosting, lIndexOnly)
/* NOTE THAT THIS FILE HAS NOT BEEN UPDATED TO BECKNERVISION'S CLIPPER 5 STANDARD */
   LOCAL SysVersion := "v7.2"
   LOCAL cTemp, nCtr, nOption := 4, aRC, cOldColor
   eSave()
   PUBLIC cPeriod, cHistory
   PRIVATE GetList := {}
   DEFAULT lIndexOnly to .n.
   DEFAULT dPosting to Date()
   SET KEY K_F9 to pCtrlW
   SET KEY K_ALT_P to ProgramInfo
   glDate := dPosting
   CLS
   SET DELETED on
   IF !File('glsys.dbf')
      @ 24,  0 say 'Creating database files...'
      @ 24, 60 say 'Account'
      cTemp := 'GLACCT/SYSTEM/N/2//ACCT_NO/N/10//NAME/C/40/PTD/N/12/2/'
      cTemp += 'YTD/N/12/2/TYPE/C/1/NOTES/M/Ptd1/N/12/2/Ptd2/N/12/2/Ptd3/N/12/2/'
      cTemp += "Ptd4/N/12/2/Ptd5/N/12/2/Ptd6/N/12/2/Ptd7/N/12/2/Ptd8/N/12/2/"
      cTemp += "Ptd9/N/12/2/Ptd10/N/12/2/Ptd11/N/12/2/Ptd12/N/12/2/Ptd13/N/12/2"
      cTemp += "/HPtd1/N/12/2/HPtd2/N/12/2/HPtd3/N/12/2/"
      cTemp += "HPtd4/N/12/2/HPtd5/N/12/2/HPtd6/N/12/2/HPtd7/N/12/2/HPtd8/N/12/2/"
      cTemp += "HPtd9/N/12/2/HPtd10/N/12/2/HPtd11/N/12/2/HPtd12/N/12/2/HPtd13/N/12/2"
      fCreateDBF(cTemp)
      @ 24, 60 say 'Check Register'
      cTemp := 'GLCHK/ACCT_NO/N/10//NAME/C/40/PTD/N/12/2/YTD/N/12/2/DESCRIP/C/30'
      cTemp += '/DATE/D/AMOUNT/N/10/2/REFERENCE/C/6/CODE/C/1'
      fCreateDBF(cTemp)
      @ 24, 60 say 'System        '
      cTemp := 'GLSYS/NAME/C/30/ADDRESS1/C/20/ADDRESS2/C/20/CITY/C/20/STATE/C/2/'
      cTemp += 'ZIP_CODE/C/10/PHONE/N/10//glCons/L/BALELISIGN/L/RE_ACCT/N/10//'
      cTemp += 'SYSFMCHK1/C/5/SYSCHKNO/N/8//SYSPRT132E/C/5/SYSPRT132D/C/5/'
      cTemp += 'SysConfirm/L/SYSELIPCHK/L/SysNoDec/L/SYSBELL/L/NTX_DRIVE/C/2/'
      cTemp += 'SysColor/L/COLOR_SET/C/15/BLINK_SET/C/15/SysAltCW/L/Version6/L'
      fCreateDBF(cTemp)
      @ 24, 60 say 'Work File'
      cTemp := 'GLTEMP/ACCT_NO/N/10//NAME/C/40/PTD/N/12/2/YTD/N/12/2/DESCRIP/C/30'
      cTemp += '/DATE/D/AMOUNT/N/10/2/REFERENCE/C/6/CODE/C/1'
      fCreateDBF(cTemp)
      @ 24, 60 say 'Transactions'
      cTemp := 'GLTRAN/ACCT_NO/N/10//DESCRIP/C/30/Period/N/2//'
      cTemp += 'DATE/D/AMOUNT/N/10/2/REFERENCE/C/6/CODE/C/1/System/N/2'
      fCreateDBF(cTemp)
      @ 24,  0
   ENDIF
   @ 2,0 clea to 23,79
   @ 2,0 to 23,79 doub
   CLOSE DATABASES
   SELECT 0
   fShare('glSys', "System")
   IF !System->Version6
      vMessageOn("Setting General Ledger to Version 6 standard")
      SELECT 0
      fShare("glTran")
      fLockFile()
      REPLACE ALL glTran->Period with Month(glTran->Date)
      UNLOCK
      CLOSE
      fShare("glAcct")
      fLockFile()
      dbEval({||FieldPut(FieldPos("Ptd"+sMake(Month(Date()))), glAcct->Ptd)})
      UNLOCK
      CLOSE
      SELECT System
      LOCK ALIAS System
      System->Version6 := .y.
      UNLOCK ALIAS System
      vMessageOff()
   ENDIF
   IF lIndexOnly
      fKill("gl*.ntx")
   ELSE
      COUNT to nCtr
      GO TOP
      IF nCtr>1
         nSystem := vPopWhen("Choose Set of Books", "System", , "RecNo()",;
         [Str(RecNo(), 2)+".  "+Name], {4, 20, 20, 55})
         IF nSystem=0
            eRestore()
            RELEASE cHistory, cPeriod
         RETURN NIL
      ENDIF
      GOTO nSystem
   ENDIF
   IF !fDriveReady(Trim(System->Ntx_Drive))
      fLockRec()
      System->Ntx_Drive := ""
      UNLOCK
   ENDIF
   cOldColor := SetColor(iif(System->SysColor, System->Color_Set, ""))
   DispBegin()
   vCenter(80, 3, 0, 'Beckner General Ledger Subsystem '+SysVersion)
   @  4,  1 to 22, 21
   @  6,  2 to  6, 20
   @ 11,  2 to 11, 20
   @ 14,  2 to 14, 20
   @ 17,  2 to 17, 20
   @ 19,  2 to 19, 20
   @  4, 22 to 12, 50
   @  6, 23 to  6, 49
   @  4, 51 to 12, 78
   @  6, 52 to  6, 77
   @ 13, 22 to 22, 78
   @ 15, 23 to 15, 77
   vCenter(19,  5, 2, 'OPTIONS')
   vCenter(27,  5, 23, 'ACCOUNT INFORMATION')
   vCenter(26,  5, 52, 'NOTES')
   vCenter(55, 14, 23, 'ACCOUNT TYPES')
   @ 16, 25 say 'A. Current Asset    '
   @ 17, 25 say 'B. Fixed Asset      '
   @ 18, 25 say 'C. Other Asset      '
   @ 19, 25 say 'D. Current Liability'
   @ 20, 25 say 'E. Long-Term Notes  '
   @ 21, 25 say 'F. Equity           '
   @ 16, 50 say 'G. Other Liability  '
   @ 17, 50 say 'H. Sales            '
   @ 18, 50 say 'I. Cost of Sales    '
   @ 19, 50 say 'J. Other Income     '
   @ 20, 50 say 'K. Operating Expense'
   @ 21, 50 say 'L. Tax Provision    '
   @  7, 25 say 'Account # ..'
   @  8, 25 say 'Name .......'
   @  9, 25 say 'PTD Amount .'
   @ 10, 25 say 'YTD Amount .'
   @ 11, 25 say 'Type .......'
   DispEnd()
ENDIF
SELECT 0
fShare("glTran")
SET FILTER TO nSystem=glTran->System
SELECT 0
fShare('glAcct')
IF !File("glAcNo.ntx")
   glIndex()
   IF lIndexOnly
      CLS
      SetColor(cOldColor)
      SELECT System
      CLOSE
      SELECT glAcct
      CLOSE
      SELECT glTran
      CLOSE
      SELECT 1
      RELEASE cHistory, cPeriod
      RETURN NIL
ENDIF
ELSE
   glSetIndex()
ENDIF
SET FILTER to nSystem=glAcct->System
GO TOP
vSave(2, 30)
aRC      := vWindow(2, 30, .y., "")
nPeriod  := Month(glDate)
cHistory := " "
@ aRC[1],  aRC[2] SAY "Period to work in ..." GET nPeriod PICTURE "99";
VALID nPeriod>0 .and. nPeriod<14
@ Row()+1, aRC[2] SAY "H/istory ............" GET cHistory PICTURE "@!A";
VALID cHistory$" H"
READ
vRestore()
cPeriod := sMake(nPeriod)
cHistory := Trim(cHistory)
DispGL()
WHILE LOOPING
   SELECT glAcct
   SET FILTER to nSystem=glAcct->system
   IF System->SysColor
      SET COLOR to (System->Blink_Set)
   ELSE
      SET COLOR to ,i*
   ENDIF
   @  7,2 PROMPT 'Add Account        '
   @  8,2 PROMPT 'Delete Account     '
   @  9,2 PROMPT 'Edit Account       '
   @ 10,2 PROMPT 'Get Account        '
   @ 12,2 PROMPT 'Transaction Display'
   @ 13,2 PROMPT 'Post Transactions  '
   @ 15,2 PROMPT 'Reports            '
   @ 16,2 PROMPT 'Maintenance        '
   @ 18,2 PROMPT 'Quit               '
   @ 20,2 PROMPT '+/scan forward     '
   @ 21,2 PROMPT '-/scan backward    '
   MENU to glOpt
   IF System->SysConfirm
      WHILE Inkey()!=13
      ENDWHILE
   ENDIF
   IF System->SysColor
      SetColor(iif(System->SysColor, System->Color_Set, ""))
   ELSE
      SET COLOR to
   ENDIF
   IF glOpt=0
      LOOP
   ENDIF
   IF glOpt=10
      SKIP
      IF eof()
         pBeep()
         GO BOTTOM
      ENDIF
      DispGL()
      LOOP
   ENDIF
   IF glOpt=11
      SKIP -1
      IF bof()
         pBeep()
         GO TOP
      ENDIF
      DispGL()
      LOOP
   ENDIF
   IF glOpt=9
      EXIT
   ENDIF
   a=Chr(64+glOpt)
   DO gl&a
ENDWHILE
CLS
SetColor(cOldColor)
SELECT System
CLOSE
SELECT glAcct
CLOSE
SELECT glTran
CLOSE
SELECT 1
RELEASE cHistory, cPeriod
RETURN NIL

STATIC FUNCTION DispGL()
   IF eof() .or. bof() .or. LastRec()=0
   RETURN NIL
ENDIF
@  7,38 SAY Acct_No
@  8,38 SAY left(name,12)
@  9,38 SAY &(cHistory+"PTD"+cPeriod)
@ 10,38 SAY ytd
@ 11,38 SAY type
IF System->SysColor
   SET COLOR to (System->Color_Set)
ELSE
   SET COLOR to i
ENDIF
memoedit(notes,7,53,11,76,.n.,.y.)
IF System->SysColor
   SET COLOR to (System->Color_Set)
ELSE
   SET COLOR to
ENDIF
RETURN NIL

PROCEDURE gla
oldrec=RecNo()
fAddRecord()
unlock
an=0
glrec=RecNo()
vSave()
@ 7,38 clea to 11,49
WHILE LOOPING
   @ 7,38 get an pict '9999999999' vali an>=0.and.an<9999999999
   read
   IF an=0
      @ 24,0
      fLockRec()
      dele
      unlock
      go oldrec
      DispGL()
      vRestore()
      RETURN
   ENDIF
   seek Str(nSystem, 2)+Str(an, 10)
   IF found()
      @ 24,0 SAY 'DUPLICATE!'
      go glrec
      LOOP
   ENDIF
   EXIT
ENDWHILE
go glrec
fLockRec()
@ 24,0
repl Acct_No with an, System WITH nSystem
@ 8,38 get name pict '@S12'
IF System->SysNoDec
   nd_val1=int(&(cHistory+"PTD"+cPeriod)*100)
   nd_val2=int(ytd*100)
   @ 9,38 get nd_val1 pict '9999999999'
   @ 10,38 get nd_val2 pict '99999999999'
ELSE
   x := &(cHistory+"PTD"+cPeriod)
   @ 9,38 get x
   @ 10,38 get ytd
ENDIF
read
IF System->SysNoDec
   repl &(cHistory+"PTD"+cPeriod) with nd_val1/100,ytd with nd_val2/100
   @ 9,38 SAY &(cHistory+"PTD"+cPeriod)
   @ 10,38 SAY ytd
   rele nd_val1,nd_val2
ELSE
   repl &(cHistory+"PTD"+cPeriod) with x
ENDIF
mtype=1
WHILE LOOPING
   IF System->SysColor
      SET COLOR to (System->Blink_Set)
   ELSE
      SET COLOR to ,i*
   ENDIF
   @ 16,25 PROMPT 'A. Current Asset    '
   @ 17,25 PROMPT 'B. Fixed Asset      '
   @ 18,25 PROMPT 'C. Other Asset      '
   @ 19,25 PROMPT 'D. Current Liability'
   @ 20,25 PROMPT 'E. Long-Term Notes  '
   @ 21,25 PROMPT 'F. Equity           '
   @ 16,50 PROMPT 'G. Other Liability  '
   @ 17,50 PROMPT 'H. Sales            '
   @ 18,50 PROMPT 'I. Cost of Sales    '
   @ 19,50 PROMPT 'J. Other Income     '
   @ 20,50 PROMPT 'K. Operating Expense'
   @ 21,50 PROMPT 'L. Tax Provision    '
   MENU to mtype
   IF System->SysConfirm
      WHILE Inkey()!=13
      ENDWHILE
   ENDIF
   IF System->SysColor
      SET COLOR to (System->Color_Set)
   ELSE
      SET COLOR to
   ENDIF
   IF mtype>0
      EXIT
   ENDIF
ENDWHILE
IF System->SysColor
   SET COLOR to (System->Color_Set)
ELSE
   SET COLOR to i
ENDIF
repl type with Chr(64+mtype),notes with memoedit(notes,7,53,11,76,.y.),system with nSystem
IF System->SysColor
   SET COLOR to (System->Color_Set)
ELSE
   SET COLOR to
ENDIF
unlock
vRestore()
DispGL()
RETURN

PROCEDURE glb
IF &(cHistory+"PTD"+cPeriod)==0.and.ytd==0
   IF !vIsSure()
      RETURN
   ENDIF
   fLockRec()
   dele
   unlock
   SKIP -1
   IF bof()
      GO TOP
   ENDIF
   DispGL()
ELSE
   save scre to wscreen
   aRC := vWindow(1,36,.y.,'CANNOT DELETE ACCOUNT WITH A BALANCE')
   vAnyKey()
   rest scre from wscreen
ENDIF
RETURN

PROCEDURE glc
old_acct=Acct_No
fLockRec()
vSave()
@ 7,38 get Acct_No vali Acct_No>=1.and.Acct_No<9999999999
@ 8,38 get name pict '@S12'
IF System->SysNoDec
   nd_val1=int(&(cHistory+"PTD"+cPeriod)*100)
   nd_val2=int(ytd*100)
   @ 9,38 get nd_val1 pict '9999999999'
   @ 10,38 get nd_val2 pict '99999999999'
ELSE
   x := &(cHistory+"PTD"+cPeriod)
   @ 9,38 get x
   @ 10,38 get ytd
ENDIF
read
IF System->SysNoDec
   repl &(cHistory+"PTD"+cPeriod) with nd_val1/100,ytd with nd_val2/100
   @ 9,38 SAY &(cHistory+"PTD"+cPeriod)
   @ 10,38 SAY ytd
   rele nd_val1,nd_val2
ELSE
   repl &(cHistory+"PTD"+cPeriod) with x
ENDIF
mtype=asc(type)-64
WHILE LOOPING
   IF System->SysColor
      SET COLOR to (System->Blink_Set)
   ELSE
      SET COLOR to ,i*
   ENDIF
   @ 16,25 PROMPT 'A. Current Asset    '
   @ 17,25 PROMPT 'B. Fixed Asset      '
   @ 18,25 PROMPT 'C. Other Asset      '
   @ 19,25 PROMPT 'D. Current Liability'
   @ 20,25 PROMPT 'E. Long-Term Notes  '
   @ 21,25 PROMPT 'F. Equity           '
   @ 16,50 PROMPT 'G. Other Liability  '
   @ 17,50 PROMPT 'H. Sales            '
   @ 18,50 PROMPT 'I. Cost of Sales    '
   @ 19,50 PROMPT 'J. Other Income     '
   @ 20,50 PROMPT 'K. Operating Expense'
   @ 21,50 PROMPT 'L. Tax Provision    '
   MENU to mtype
   IF System->SysConfirm
      WHILE Inkey()!=13
      ENDWHILE
   ENDIF
   IF System->SysColor
      SET COLOR to (System->Color_Set)
   ELSE
      SET COLOR to
   ENDIF
   IF mtype>0
      EXIT
   ENDIF
ENDWHILE
IF System->SysColor
   SET COLOR to (System->Color_Set)
ELSE
   SET COLOR to i
ENDIF
repl type with Chr(64+mtype),notes with memoedit(notes,7,53,11,76,.y.)
IF System->SysColor
   SET COLOR to (System->Color_Set)
ELSE
   SET COLOR to
ENDIF
unlock
IF old_acct!=Acct_No
   aRC := vWindow(1,42,.y.,'')
   @ aRC[1], aRC[2] SAY 'Account # has been changed.  One moment...'
   new_acct=Acct_No
   glrec=RecNo()
   seek Str(nSystem, 2)+Str(Acct_No, 10)
   SKIP
   IF !eof().and.Acct_No=new_acct
      aRC := vWindow(1,66,.y.,'')
      @ aRC[1], aRC[2] SAY "Duplicate account #'s not allowed.  Original account # restored..."
      fLockRec()
      repl Acct_No with old_acct
      unlock
      vAnyKey()
      rest scre from wscreen
      RETURN
   ENDIF
   go glrec
   SELECT b
   seek glAcct->Acct_No
   WHILE found()
      fLockRec()
      repl Acct_No with new_acct
      unlock
      seek glAcct->Acct_No
   ENDWHILE
   SELECT glAcct
ENDIF
vRestore()
DispGL()
RETURN

PROCEDURE gld
save scre to wscreen
acct=0
aRC := vWindow(1,20,.y.,'')
@ aRC[1], aRC[2] SAY 'Account #' get acct pict '9999999999'
read
IF acct=0
   rest scre from wscreen
   RETURN
ENDIF
glrec=RecNo()
seek Str(nSystem, 2)+Str(acct, 10)
IF !found()
   aRC := vWindow(1,34,.y.,'')
   @ aRC[1], aRC[2] SAY 'Account '+alltrim(str(acct,10))+' does not exist.'
   vAnyKey()
   go glrec
ENDIF
rest scre from wscreen
DispGL()
RETURN

PROCEDURE gle
LOCAL aRC, nOption
vSave()
aRC := vWindow(2, 6, .y., "")
@ aRC[1],  aRC[2] PROMPT "Normal"
@ Row()+1, aRC[2] PROMPT "Browse"
MENU to nOption
vRestore()
IF nOption=0
   RETURN
ELSEIF nOption=2
   glBrowse()
   RETURN
ENDIF
start_date=glDate
end_date=glDate
save scre to wscreen
aRC := vWindow(2,40,.y.,'')
@ aRC[1], aRC[2] SAY 'Start date .....' get start_date
@ aRC[1]+1, aRC[2] SAY 'End date .......' get end_date
read
rest scre from wscreen
IF end_date<start_date .or. empty(end_date)
   RETURN
ENDIF
SELECT glTran
SET ORDER to 1
seek Str(glAcct->System, 2)+Str(glAcct->Acct_No, 10)
IF !found()
   aRC := vWindow(1,33,.y.,'')
   @ aRC[1], aRC[2] SAY 'No transactions for this account.'
   vAnyKey()
   rest scre from wscreen
   SELECT glAcct
   RETURN
ENDIF
SET ORDER to 3
SET SOFTSEEK on
SEEK Str(nSystem, 2)+Str(Acct_No, 10)+dtos(Start_Date)
SET SOFTSEEK off
IF Acct_No!=glAcct->Acct_No
   SET ORDER to 1
   aRC := vWindow(1,33,.y.,'')
   @ aRC[1], aRC[2] SAY 'No transactions for this period.'
   vAnyKey()
   rest scre from wscreen
   SELECT glAcct
   RETURN
ENDIF
WHILE !eof().and.glAcct->Acct_No=Acct_No
   aRC := vWindow(15,76,.y.,'TRANSACTIONS FOR ACCOUNT #'+alltrim(str(glAcct->Acct_No)))
   ctr=1
   WHILE ctr<=15.and.!eof().and.glAcct->Acct_No=Acct_No
      IF date<start_date .or. date>end_date
         SKIP
         LOOP
      ENDIF
      @ aRC[1]+ctr-1, aRC[2] SAY ctr pict '99'
      @ row(),col() SAY '.'
      @ row(),col()+2 SAY date
      @ row(),col()+2 SAY amount
      @ row(),col()+2 SAY code
      @ row(),col()+2 SAY reference
      @ row(),col()+2 SAY descrip
      SKIP
      ctr=ctr+1
   ENDWHILE
   IF eof()
      EXIT
   ENDIF
   IF System->SysColor
      SET COLOR to gr+/n,i*
   ELSE
      SET COLOR to ,i*
   ENDIF
   @ 24,0 SAY 'Options:'
   opt=1
   @ 24,col()+3 PROMPT 'Continue'
   @ 24,col()+3 PROMPT 'Quit'
   MENU to opt
   IF System->SysConfirm
      WHILE Inkey()!=13
      ENDWHILE
   ENDIF
   IF System->SysColor
      SET COLOR to (System->Color_Set)
   ELSE
      SET COLOR to
   ENDIF
   IF opt=0 .or. opt=2
      EXIT
   ENDIF
   @ 24,0
ENDWHILE
vAnyKey()
rest scre from wscreen
SET ORDER to 1
SELECT glAcct
RETURN

PROCEDURE glf
save scre to wscreen
acct=Acct_No
lasta=0
lastamt=0.00
lastd=space(15)
opt=2
aRC := vWindow(3,12,.y.,'METHOD')
@ aRC[1], aRC[2] PROMPT 'Double Entry'
@ row()+1, aRC[2] PROMPT 'Journal     '
@ row()+1, aRC[2] PROMPT 'Check Writer'
MENU to opt
rest scre from wscreen
IF opt=0
   RETURN
ELSEif opt=2
   do glf2
   rest scre from wscreen
   DispGL()
   RETURN
ELSEif opt=3
   iif(System->SysAltCW, CW(), chks())
   rest scre from wscreen
   DispGL()
   RETURN
ENDIF
WHILE LOOPING
   aRC := vWindow(11,60,.y.,'POSTING TRANSACTIONS')
   @ aRC[1]+9, aRC[2] SAY lasta
   @ row(),col()+2 SAY lastamt
   @ row(),col()+2 SAY lastd
   @ aRC[1], aRC[2] SAY 'Enter account # (0=quit) ...' get acct pict '9999999999' vali acct>=0.and.acct<9999999999
   read
   SELECT glAcct
   IF acct=0
      rest scre from wscreen
      DispGL()
      RETURN
   ENDIF
   seek Str(nSystem, 2)+Str(acct, 10)
   IF !found()
      LOOP
   ENDIF
   SELECT glTran
   fAddRecord()
   repl Acct_No with acct,date with glDate, System WITH nSystem
   @ aRC[1]+1, aRC[2] SAY trim(glAcct->name)
   @ row(),col()+2 SAY glAcct->(&(cHistory+"ptd"+cPeriod))
   @ row(),col()+2 SAY glAcct->ytd
   @ row()+1, aRC[2] SAY 'Code (C/heck, V/oid, blank)' get code pict '@! A' vali code$'CV '
   IF System->SysNoDec
      nd_val=int(amount*100)
      @ row()+1, aRC[2] SAY 'Amount (+/- and value) ....' get nd_val
   ELSE
      @ row()+1, aRC[2] SAY 'Amount (+/- and value) ....' get amount
   ENDIF
   @ row()+1, aRC[2] SAY 'Reference .................' get reference
   @ row()+1, aRC[2] SAY 'Description ...............' get descrip
   @ row()+1, aRC[2] SAY 'Date of transaction .......' get date
   prtchk=.n.
   @ row()+1, aRC[2] SAY 'Print check (Y/N)? ........' get prtchk pict 'Y'
   read
   IF System->SysNoDec
      repl amount with nd_val/100
      rele nd_val
   ENDIF
   IF amount==0
      fLockRec()
      dele
      unlock
   ELSE
      SELECT glAcct
      fLockRec()
      repl &(cHistory+"PTD"+cPeriod) with &(cHistory+"PTD"+cPeriod)+b->amount,ytd with ytd+b->amount
      unlock
      lasta=Acct_No
      lastamt=b->amount
      lastd=left(b->descrip,15)
      IF prtchk
         BecknerFG(System->SysFmChk1,1)
      ENDIF
   ENDIF
   unlock
ENDWHILE

STATIC FUNCTION Chks()
LOCAL nOption, cTemp, aRC, nCheckNum := 0, nAcctNum := 0
eSave()
vBackground(Chr(177))
IF System->SysColor
   SET COLOR to gr+/b, w+/b, , , w/b
ENDIF
CLS
@ 24, 0 SAY "General Ledger Check Writer"
IF !File("GLChecks.dbf")
   cTemp := "GLChecks/ChkAcctNum/N/10//ExpAcctNum/N/10//Amount/N/12/2/CheckNum/N/10//"
   cTemp += "Date/D/ToLine1/C/50/ToLine2/C/50/ToLine3/C/50/Suspense/L"
   fCreateDBF(cTemp)
ENDIF
SELECT 0
fShare("GLChecks", "Check")
WHILE LOOPING
   @ 0, 0
   nOption := vMenu("T/Post new check/Review check register/Quit")
   IF nOption=0  .or.  nOption=3
      EXIT
   ENDIF
   IF nOption=2
      vSave()
      Browse()
      vRestore()
      LOOP
   ENDIF
   aRC := vWindow(9, 78, .y., "Check Information")
   fAddRecord()
   Check->ChkAcctNum := nAcctNum
   Check->CheckNum := nCheckNum+1
   @ aRC[1], aRC[2] SAY "Checking account number ..." get Check->ChkAcctNum
   @ Row()+1, aRC[2] SAY "Expense account number ...." get Check->ExpAcctNum
   @ Row()+1, aRC[2] SAY "Check number .............." get Check->CheckNum
   @ Row()+1, aRC[2] SAY "Date ......................" get Check->Date
   @ Row()+1, aRC[2] SAY "Amount ...................." get Check->Amount
   @ Row()+1, aRC[2] SAY "To (line 1) ..............." get Check->ToLine1
   @ Row()+1, aRC[2] SAY "To (line 2) ..............." get Check->ToLine2
   @ Row()+1, aRC[2] SAY "To (line 3) ..............." get Check->ToLine3
   @ Row()+1, aRC[2] SAY "Suspense (Y/N)? ..........." get Check->Suspense
   READ
   IF Check->ChkAcctNum=0  .or.  Check->Amount=0.00
      DELETE
      UNLOCK
      Alert("This check has been removed")
      LOOP
   ENDIF
   nAcctNum := Check->ChkAcctNum
   nCheckNum := Check->CheckNum
ENDWHILE
CLOSE
SELECT glAcct
eRestore()
RETURN NIL

PROCEDURE glf2
LOCAL cDC := "CR", tempfl, nCurRec := glAcct->(RecNo())
PRIVATE ctr
tempfl=fUnique()
SELECT glTran
copy stru to (tempfl)
SELECT 0
fNoShare(tempfl,'journal')
aRC := vWindow(20,78,.y.,'JOURNAL ENTRY METHOD')
appe blan
@ aRC[1], aRC[2] SAY 'Account #  Description'+space(22)+'Date         Amount    Refrnc C'
ctr=1
@ aRC[1]+1, aRC[2] get Acct_No vali glgetit(Acct_No)
@ row(),col()+1 get descrip
repl date with glDate,Acct_No with glAcct->Acct_No, System WITH nSystem
@ row(),col()+1 get date
@ row(),col()+1 get amount pict '9,999,999.99'
@ row(),col()+1 get cDC picture "@! AR" valid Left(cDC, 1)$"DC"
@ row(),col()+1 get reference
@ row(),col()+1 get code pict '@!A' vali code$' CV'
read
IF Acct_No=0
   use
   eras (tempfl)
   SELECT glAcct
   RETURN
ENDIF
iif(cDC="CR", Field->Amount := -Amount,)
cDC := iif(cDC="CR", "DR", "CR")
desc=descrip
ref=reference
dt=date
ctr=3
WHILE LOOPING
   sum amount to tempa
   @ 24,0 SAY tempa pict '9,999,999,999.99'
   appe blan
   repl descrip with desc,reference with ref,date with dt, Amount with Abs(TempA), System WITH nSystem
   cDC := iif(TempA<0, "DR", "CR")
   @ aRC[1]+ctr, aRC[2] get Acct_No vali glgetit(Acct_No)
   @ row(),col()+1 get descrip pict '@K'
   @ row(),col()+1 get date
   @ row(),col()+1 get amount pict '9,999,999.99'
   @ row(),col()+1 get cDC picture "@!A" valid Left(cDC, 1)$"CD"
   @ row(),col()+1 get reference
   @ row(),col()+1 get code pict '@!A' vali code$' CV'
   read
   @ aRC[1]+ctr+1, aRC[2] clea to aRC[1]+ctr+1, aRC[2]+76
   opt=4
   IF Acct_No=0
      @ 24,30 PROMPT 'Continue'
      @ 24,col()+1 PROMPT 'Browse'
      @ 24,col()+1 PROMPT 'Abort'
      @ 24,col()+1 PROMPT 'Save'
      MENU to opt
      @ 24,30
      IF opt>3
         IF TempA!=0.00
            pSoundError()
            IF Alert("* * *  W A R N I N G  * * *;The current total for"+;
                  " this session is;"+sDollar(TempA)+";;Do you really "+;
                  "want to save it now?", {"No", "Yes"})=2
               EXIT
            ENDIF
         ELSE
            EXIT
         ENDIF
      ELSEIF Opt=3
         EXIT
      ELSEIF opt=2
         save scre
         fBrowse()
         rest scre
         GO BOTTOM
      ELSE
         SetPos(Row()-1, 0)
         LOOP
      ENDIF
   ENDIF
   Desc     := Descrip
   Ref      := Reference
   Dt       := Date
   iif(cDC="CR", Field->Amount := -Amount,)
   IF ctr<18
      iif(Opt=4, Ctr++,)
   ELSE
      Scroll(aRC[1]+3, aRC[2], 16, 78, 1)
   ENDIF
ENDWHILE
SELECT glAcct
set orde to 1
SELECT journal
IF opt=4
   DELETE FOR Empty(Acct_No)
   GO TOP
   WHILE !eof()
      SELECT glAcct
      seek Str(nSystem, 2)+Str(journal->Acct_No, 10)
      fLockRec()
      repl &(cHistory+"PTD"+cPeriod) with &(cHistory+"PTD"+cPeriod)+journal->amount,ytd with ytd+journal->amount
      unlock
      SELECT journal
      SKIP
   ENDWHILE
   CLOSE
   fNoShare(tempfl)
   PACK
   CLOSE
   SELECT glTran
   appe from (tempfl)
ELSE
   use
ENDIF
eras (tempfl)
SELECT glAcct
GOTO nCurRec
RETURN

PROCEDURE glg
LOCAL nGroup
rptdate=glDate
save scre to wscreen
IF !System->SysEliPChk
   pPrinter()
ENDIF
aRC := vWindow(14,32,.y.,'G/L REPORTS')
IF System->SysColor
   SET COLOR to (System->Blink_Set)
ELSE
   SET COLOR to ,i*
ENDIF
@ aRC[1], aRC[2] PROMPT 'A. Daily Transaction Report     '
@ row()+1, aRC[2] PROMPT 'B. Chart of Accounts            '
@ row()+1, aRC[2] PROMPT 'C. Trial Balance                '
@ row()+1, aRC[2] PROMPT 'D. Balance Sheet                '
@ row()+1, aRC[2] PROMPT 'E. Profit & Loss Statement      '
@ row()+1, aRC[2] PROMPT 'F. Supporting P & L Schedules   '
@ row()+1, aRC[2] PROMPT 'G. <reserved>                   '
@ row()+1, aRC[2] PROMPT 'H. Year-to-Date General Ledger  '
@ row()+1, aRC[2] PROMPT 'I. Check Register               '
@ row()+1, aRC[2] PROMPT 'J. Print Current Account        '
@ row()+1, aRC[2] PROMPT 'K. Print System File            '
@ row()+1, aRC[2] PROMPT 'L. Periodic Transactions        '
@ row()+1, aRC[2] PROMPT 'M. Forms Generator              '
@ row()+1, aRC[2] PROMPT 'N. Report Generator             '
glrec=RecNo()
SELECT glAcct
opt=1
MENU to opt
IF System->SysConfirm
   WHILE Inkey()!=13
   ENDWHILE
ENDIF
IF System->SysColor
   SetColor(iif(System->SysColor, System->Color_Set, ""))
ELSE
   SET COLOR to
ENDIF
rest scre from wscreen
IF opt=0
   RETURN
ENDIF
IF !vIsSure()
   RETURN
ENDIF
IF System->glCons
   aRC := vWindow(1,52,.y.,'')
   cons_str=space(50)
   @ aRC[1], aRC[2] SAY 'Consolidation string:' get cons_str pict '@S30'
   read
   rest scre from wscreen
   IF !empty(cons_str)
      SET FILTER to str(nSystem,2)$cons_str
   ENDIF
ENDIF
do case
   case opt=1
      do prt132e
      aRC := vWindow(1,34,.y.,'')
      @ aRC[1], aRC[2] SAY 'Enter date to print for:' get rptdate
      read
      rest scre from wscreen
      IF empty(rptdate)
         RETURN
      ENDIF
      SELECT glTran
      set orde to 2
      set rela to Str(System, 2)+Str(Acct_No, 10) into glacct
      seek rptdate
      IF !found()
         set orde to 1
         set rela to
         SELECT glAcct
         aRC := vWindow(1,28,.y.,'')
         @ aRC[1], aRC[2] SAY 'No transactions for '+dtoc(rptdate)
         vAnyKey()
         rest scre from wscreen
         RETURN
      ENDIF
      set cons off
      set prin on
      ? trim(System->Name)+' Posting date '+dtoc(rptdate)+" #"+sMake(nPeriod)
      set prin off
      @ 24,0 SAY 'REPORT IS PRINTING...'
      repo form glrday to prin whil date=rptdate for glAcct->system=nSystem
      @ 24,0
      set cons on
      set orde to 1
      set rela to
      do prt132d
      SELECT glAcct
      go glrec
      RETURN
   case opt=2
      set cons off
      set prin on
      ? trim(System->Name)+' Posting date '+dtoc(rptdate)+" #"+sMake(nPeriod)
      set prin off
      @ 24,0 SAY 'REPORT IS PRINTING...'
      repo form glrcoa to prin
      @ 24,0
      set cons on
      go glrec
      RETURN
   case opt=3
      set cons off
      set prin on
      ? trim(System->Name)+' Posting date '+dtoc(rptdate)+" #"+sMake(nPeriod)
      set prin off
      @ 24,0 SAY 'REPORT IS PRINTING...'
      repo form glrtrb to prin
      @ 24,0
      set cons on
      go glrec
      RETURN
   case opt=4
      pnet=0
      ynet=0
      do profit
      pnet=-pnet
      ynet=-ynet
      @ 24,0 SAY 'REPORT IS PRINTING...'
      set devi to prin
      @ 0,0 SAY 'BALANCE SHEET '+DTOC(DATE())+'  '+Trim(System->Name)+'  Posting date '+dtoc(glDate)+" #"+sMake(nPeriod)
      @ 2,30 SAY 'ASSETS'
      @ 3,30 SAY '------'
      @ 4,0 SAY 'CURRENT ASSETS'
      @ 5,0 SAY '--------------'
      line=6
      loca for type='A'
      stor 0 to xtotal,gtotal
      WHILE type='A'.and.!eof()
         @ line,0 SAY name
         @ line,60 SAY ytd pict '9,999,999,999.99'
         xtotal=xtotal+ytd
         line=line+1
         cont
      ENDWHILE
      @ line,60 SAY '------------'
      line=line+1
      @ line,10 SAY 'TOTAL CURRENT ASSETS'
      @ line,58 SAY xtotal pict '99,999,999.99'
      line=line+2
      @ line,0 SAY 'FIXED ASSETS'
      @ line+1,0 SAY '------------'
      line=line+2
      gtotal=gtotal+xtotal
      xtotal=0
      loca for type='B'
      WHILE type='B'.and.!eof()
         @ line,0 SAY name
         @ line,60 SAY ytd pict '9,999,999.99'
         xtotal=xtotal+ytd
         line=line+1
         cont
      ENDWHILE
      @ line,60 SAY '------------'
      line=line+1
      @ line,10 SAY 'TOTAL FIXED ASSETS'
      @ line,58 SAY xtotal pict '99,999,999.99'
      line=line+2
      @ line,0 SAY 'OTHER ASSETS'
      @ line+1,0 SAY '------------'
      line=line+2
      gtotal=gtotal+xtotal
      xtotal=0
      loca for type='C'
      WHILE type='C'.and.!eof()
         @ line,0 SAY name
         @ line,60 SAY ytd pict '9,999,999.99'
         xtotal=xtotal+ytd
         line=line+1
         cont
      ENDWHILE
      @ line,60 SAY '------------'
      line=line+1
      @ line,10 SAY 'TOTAL OTHER ASSETS'
      @ line,58 SAY xtotal pict '99,999,999.99'
      gtotal=gtotal+xtotal
      g1=gtotal
      line=line+2
      @ line+3,58 SAY gtotal pict '99,999,999.99'
      @ line+4,58 SAY '============='
      @ line+6,25 SAY 'LIABILITIES AND EQUITY'
      @ line+7,25 SAY '----------------------'
      @ line+9,0 SAY 'CURRENT LIABILITIES'
      @ line+10,0 SAY '-------------------'
      line=line+11
      stor 0 to gtotal,xtotal
      loca for type='D'
      WHILE type='D'.and.!eof()
         @ line,0 SAY name
         @ line,60 SAY IF(System->BalEliSign,-ytd,ytd) pict '9,999,999.99'
         xtotal=xtotal+ytd
         line=line+1
         cont
      ENDWHILE
      @ line,60 SAY '------------'
      line=line+1
      @ line,10 SAY 'TOTAL CURRENT LIABILITY'
      @ line,58 SAY IF(System->BalEliSign,-xtotal,xtotal) pict '99,999,999.99'
      @ line+2,0 SAY 'LONG TERM NOTES AND EQUITY'
      @ line+3,0 SAY '--------------------------'
      line=line+4
      gtotal=gtotal+xtotal
      xtotal=0
      loca for type$'EF'
      WHILE type$'EF'.and.!eof()
         @ line,0 SAY name
         @ line,60 SAY IF(System->BalEliSign,-ytd,ytd) pict '9,999,999.99'
         xtotal=xtotal+ytd
         line=line+1
         cont
      ENDWHILE
      IF ynet>0
         pl='LOSS'
      ELSE
         pl='PROFIT'
      ENDIF
      xtotal=xtotal+ynet
      @ line,0 SAY 'NET '+pl+' TO DATE'
      @ line,60 SAY abs(ynet) pict '9,999,999.99'
      line=line+1
      @ line,60 SAY '------------'
      line=line+1
      @ line,10 SAY 'TOTAL EQUITY'
      @ line,58 SAY IF(System->BalEliSign,-xtotal,xtotal) pict '99,999,999.99'
      @ line+2,0 SAY 'OTHER LIABILITIES'
      @ line+3,0 SAY '-----------------'
      line=line+4
      gtotal=gtotal+xtotal
      xtotal=0
      loca for type='G'
      WHILE type='G'.and.!eof()
         @ line,0 SAY name
         @ line,60 SAY IF(System->BalEliSign,-ytd,ytd) pict '9,999,999.99'
         xtotal=xtotal+ytd
         line=line+1
         cont
      ENDWHILE
      gtotal=gtotal+xtotal
      @ line,60 SAY '------------'
      line=line+2
      @ line,10 SAY 'TOTAL OTHER LIABILITIES'
      @ line,58 SAY IF(System->BalEliSign,-xtotal,xtotal) pict '99,999,999.99'
      @ line+2,58 SAY IF(System->BalEliSign,-gtotal,gtotal) pict '99,999,999.99'
      @ line+3,58 SAY '=============='
      set devi to scre
      @ 24,0
      ejec
      go glrec
      rest scre from wscreen
      RETURN
   case opt=5
      @ 24,0 SAY 'REPORT IS PRINTING...'
      set devi to prin
      stor 0 to sp_pct,sy_pct,cp_pct,cy_pct,rp_pct,ry_pct,ep_pct,ey_pct,line,p_pct,y_pct
      @ 0,0 SAY 'PROFIT & LOSS STATEMENT '+dtoc(date())+'  '+Trim(System->Name)+'  Posting date '+dtoc(glDate)+" #"+sMake(nPeriod)
      @ 2,39 SAY 'PERIOD'
      @ 2,49 SAY '% SALES'
      @ 2,62 SAY 'YTD'
      @ 2,69 SAY '% SALES'
      @ 3,39 SAY '------'
      @ 3,49 SAY '-------'
      @ 3,62 SAY '---'
      @ 3,69 SAY '-------'
      line=5
      sum &(cHistory+"PTD"+cPeriod),ytd to p_total,y_total for type='H'
      p_total=-p_total+0.00
      y_total=-y_total+0.00
      p_amount=p_total
      y_amount=y_total
      p_sales=p_total
      y_sales=y_total
      hdr='SALES'
      hdrn=41
      do glplprt
      sum &(cHistory+"PTD"+cPeriod),ytd to p_cost,y_cost for type='I'
      p_cost=p_cost+0.00
      y_cost=y_cost+0.00
      p_amount=p_cost
      y_amount=y_cost
      hdr='COST OF SALES'
      hdrn=51
      do glplprt
      line=line+2
      p_gross=p_sales-p_cost
      y_gross=y_sales-y_cost
      @ line,10 SAY 'GROSS PROFIT'
      @ line,36 SAY p_gross pict '999,999.99'
      @ line,49 SAY sp_pct-cp_pct pict '9999.9'
      @ line,58 SAY y_gross pict '999,999.99'
      @ line,71 SAY sy_pct-cy_pct pict '9999.9'
      line=line+2
      sum &(cHistory+"PTD"+cPeriod),ytd to p_other,y_other for type='J'
      p_other=-p_other+0.00
      y_other=-y_other+0.00
      p_amount=p_other
      y_amount=y_other
      hdr='OTHER INCOME'
      hdrn=61
      do glplprt
      p_revenue=p_gross+p_other
      y_revenue=y_gross+y_other
      trp_pct=sp_pct-cp_pct+rp_pct
      try_pct=sy_pct-cy_pct+ry_pct
      line=line+2
      @ line,10 SAY 'GROSS REVENUE'
      @ line,36 SAY p_revenue pict '999,999.99'
      @ line,49 SAY trp_pct pict '9999.9'
      @ line,58 SAY y_revenue pict '999,999.99'
      @ line,71 SAY try_pct pict '9999.9'
      line=line+2
      @ line,0 SAY 'OPERATING EXPENSES'
      @ line+1,0 SAY '------------------'
      line=line+3
      loca for type='K'
      stor 0 to tp_expense,ty_expense
      hdrn=7
      WHILE !eof().and.type='K'
         tp_expense=tp_expense+&(cHistory+"PTD"+cPeriod)
         ty_expense=ty_expense+ytd
         hdr=name
         p_amount=&(cHistory+"PTD"+cPeriod)
         y_amount=ytd
         do glplprt
         cont
      ENDWHILE
      hdrn=0
      hdr='          TOTAL OPERATING EXPENSE'
      p_amount=tp_expense
      y_amount=ty_expense
      do glplprt
      line=line+1
      p_net_amt=p_revenue-tp_expense
      y_net_amt=y_revenue-ty_expense
      p_net_pct=trp_pct-ep_pct
      y_net_pct=try_pct-ey_pct
      @ line,10 SAY 'NET PROFIT BEFORE TAXES'
      @ line,36 SAY p_net_amt pict '999,999.99'
      @ line,49 SAY p_net_pct pict '9999.9'
      @ line,56 SAY y_net_amt pict '9,999,999.99'
      @ line,71 SAY y_net_pct pict '9999.9'
      line=line+1
      hdrn=91
      hdr='PROVISION FOR TAXES'
      sum &(cHistory+"PTD"+cPeriod),ytd to p_taxes,y_taxes for type='L'
      p_taxes=p_taxes+0.00
      y_taxes=y_taxes+0.00
      p_amount=p_taxes
      y_amount=y_taxes
      do glplprt
      line=line+1
      @ line,10 SAY 'NET PROFIT'
      @ line,36 SAY p_net_amt-p_taxes pict '999,999.99'
      @ line,49 SAY p_net_pct-p_pct pict '9999.9'
      @ line,56 SAY y_net_amt-y_taxes pict '9,999,999.99'
      @ line,71 SAY y_net_pct-y_pct pict '9999.9'
      ejec
      set devi to scre
      @ 24,0
      go glrec
      rest scre from wscreen
   case opt=6
      b=''
      rest scre from wscreen
      aRC := vWindow(15,25,.y.,'ACCOUNTS TO PRINT')
       aRC[2]= aRC[2]+2
      opt=14
      @ aRC[1]+13, aRC[2]-1 SAY '*'
      WHILE LOOPING
         IF System->SysColor
            SET COLOR to (System->Blink_Set)
         ELSE
            SET COLOR to ,i*
         ENDIF
         @ aRC[1], aRC[2] PROMPT 'A. Current Assets     '
         @ row()+1, aRC[2] PROMPT 'B. Fixed Assets       '
         @ row()+1, aRC[2] PROMPT 'C. Other Assets       '
         @ row()+1, aRC[2] PROMPT 'D. Current Liabilities'
         @ row()+1, aRC[2] PROMPT 'E. Long-Term Notes    '
         @ row()+1, aRC[2] PROMPT 'F. Equity             '
         @ row()+1, aRC[2] PROMPT 'G. Other Liabilities  '
         @ row()+1, aRC[2] PROMPT 'H. Sales              '
         @ row()+1, aRC[2] PROMPT 'I. Cost of Sales      '
         @ row()+1, aRC[2] PROMPT 'J. Other Income       '
         @ row()+1, aRC[2] PROMPT 'K. Operating Expenses '
         @ row()+1, aRC[2] PROMPT 'L. Tax Provisions     '
         @ row()+2, aRC[2] PROMPT 'M. ALL                '
         @ row()+1, aRC[2] PROMPT 'N. Print report       '
         MENU to opt
         IF System->SysConfirm
            WHILE Inkey()!=13
            ENDWHILE
         ENDIF
         IF System->SysColor
            SET COLOR to (System->Color_Set)
         ELSE
            SET COLOR to
         ENDIF
         IF opt=0
            rest scre from wscreen
            RETURN
         ENDIF
         IF opt=14
            EXIT
         ENDIF
         IF opt=13
            b=''
            for x = 0 to 11
               @ aRC[1]+x, aRC[2]-1 SAY " "
            next
            @ aRC[1]+13, aRC[2]-1 SAY '*'
            LOOP
         ENDIF
         @ aRC[1]+opt-1, aRC[2]-1 SAY '*'
         @ aRC[1]+13, aRC[2]-1 SAY ' '
         b=b+Chr(64+opt)
      ENDWHILE
      set cons off
      sum &(cHistory+"PTD"+cPeriod),ytd to p_sales,y_sales for type$'HJ'
      p_sales=p_sales+0.00
      y_sales=y_sales+0.00
      IF p_sales=0
         p_sales=.01
      ENDIF
      IF y_sales=0
         y_sales=.01
      ENDIF
      set prin on
      ? trim(System->Name)+' Posting date '+dtoc(rptdate)+" #"+sMake(nPeriod)
      set prin off
      @ 24,0 SAY 'REPORT IS PRINTING...'
      repo form glsup to prin for iif(''=b,.y.,type$b)
      @ 24,0
      set cons on
      rest scre from wscreen
      go glrec
/*
   case opt=7
      @ 24,0 SAY 'REPORT IS PRINTING...'
      aRC := vWindow(2,30,.y.,'ENTER DATES')
      stor glDate to sdate,edate
      @ aRC[1], aRC[2] SAY 'Start date .....' get sdate
      @ aRC[1]+1, aRC[2] SAY 'End date .......' get edate
      read
      IF sdate>edate .or. empty(edate)
         rest scre from wscreen
         RETURN
      ENDIF
      set orde to 1
      SELECT glTran
      SET FILTER to sdate<=date.and.edate>=date
      GO TOP
      SELECT j
      fNoShare('gltemp')
      zap
      SELECT glTran
      WHILE !eof()
         SELECT glAcct
         seek b->Acct_No
         SELECT j
         fAddRecord()
         repl Acct_No with b->Acct_No,descrip with b->descrip,reference with b->reference,date with b->date,amount with b->amount,code with b->code,name with glAcct->name,PTD with glAcct->(&(cHistory+"PTD"+cPeriod)),ytd with glAcct->ytd
         unlock
         SELECT glTran
         SKIP
      ENDWHILE
      SELECT j
      dele all for empty(name)
      inde on name to (Trim(System->Ntx_Drive)+"gltemp")
      set cons off
      repo form glrptd to prin head trim(System->Name)+' Posting date '+dtoc(rptdate)+" #"+sMake(nPeriod)
      set cons on
      use
      SELECT glTran
      SET FILTER to
      SELECT glAcct
      fLockFile()
      set orde to 0
      repl all &(cHistory+"PTD"+cPeriod) with 0
      set orde to 1
      unlock
      go glrec
      rest scre from wscreen
      DispGL()
      RETURN
*/
case opt=8
   @ 24,0
   quit_it=.y.
   @ 24,0 SAY 'WARNING!  This report will destroy all P&L amounts!  Abort (Y/N)?' get quit_it pict 'Y'
   read
   @ 24,0
   IF quit_it
      rest scre from wscreen
         RETURN
ENDIF
set cons off
set prin on
? trim(System->Name)+' Posting date '+dtoc(rptdate)+" #"+sMake(nPeriod)
set prin off
@ 24,0 SAY 'REPORT IS PRINTING...'
repo form glrcoa to prin
set cons on
GO TOP
WHILE !eof()
   SELECT glTran
   seek Str(nSystem, 2)+Str(glAcct->Acct_No, 10)
   IF found()
      WHILE !eof().and.glAcct->Acct_No=Acct_No
         fLockRec()
         dele
         unlock
         SKIP
      ENDWHILE
   ENDIF
   SELECT glAcct
   SKIP
ENDWHILE
SELECT glTran
fNoShare('gltran')
SET FILTER to nSystem=glTran->system
set inde to (Trim(System->Ntx_Drive)+"gltrno"), (Trim(System->Ntx_Drive)+"gltrdt"), (Trim(System->Ntx_Drive)+"gltrad")
pack
CLOSE
fShare('gltran')
set inde to (Trim(System->Ntx_Drive)+"gltrno"), (Trim(System->Ntx_Drive)+"gltrdt"), (Trim(System->Ntx_Drive)+"gltrad")
SET FILTER to nSystem=glTran->system
SELECT glAcct
fNoShare('glacct')
set inde to (Trim(System->Ntx_Drive)+"glacno"), (Trim(System->Ntx_Drive)+"glacnm")
SET FILTER to nSystem=glAcct->system
repl all ytd with 0 for type>'G'
FOR nPd := 1 TO 13
   cPd := sMake(nPd)
   dbEval({||glAcct->&("HPTD"+cPd) := glAcct->&("PTD"+cPd),;
         glAcct->&("PTD"+cPd) := 0})
NEXT
pack
fShare('glacct')
set inde to (Trim(System->Ntx_Drive)+"glacno"), (Trim(System->Ntx_Drive)+"glacnm")
SET FILTER to nSystem=glAcct->system
GO TOP
WHILE !eof()
   IF ytd=0
      SKIP
      LOOP
   ENDIF
   SELECT glTran
   fAddRecord()
   repl Acct_No with glAcct->Acct_No,date with glDate,amount with glAcct->ytd,reference with 'BEGBAL',descrip with 'Beginning balance', System WITH nSystem
   SELECT glAcct
   SKIP
ENDWHILE
SELECT glAcct
GO TOP
glrec=RecNo()
rest scre from wscreen
DispGL()
      RETURN
case opt=9
   rest scre from wscreen
   aRC := vWindow(2,28,.y.,'DATES')
   sdate=glDate-30
   edate=glDate
   @ aRC[1], aRC[2] SAY 'Start date .......' get sdate
   @ aRC[1]+1, aRC[2] SAY 'Ending date ......' get edate
   read
   IF sdate>edate
      rest scre from wscreen
         RETURN
ENDIF
@ 24,0 SAY 'REPORT IS PRINTING...'
SELECT j
fNoShare('glchk')
zap
fShare('glchk')
SELECT glTran
set orde to 2
loca for date>=sdate
IF !found() .or. edate<date
   use
   SELECT glAcct
   rest scre from wscreen
         RETURN
ENDIF
WHILE !eof().and.date<=edate
   IF !code$'CV'
      SKIP
      LOOP
   ENDIF
   SELECT glAcct
   seek Str(nSystem, 2)+Str(glTran->Acct_No, 10)
   SELECT j
   fAddRecord()
   repl Acct_No with glTran->Acct_No,;
   descrip with glTran->descrip,;
   reference with glTran->reference,;
   date with glTran->date,;
   amount with glTran->amount,;
   code with glTran->code,;
   name with glAcct->name,;
   PTD with glAcct->(&(cHistory+"PTD"+cPeriod)),;
   ytd with glAcct->ytd
   SELECT glTran
   SKIP
ENDWHILE
SELECT j
inde on val(reference) to (Trim(System->Ntx_Drive)+"temp")
set cons off
set prin on
? trim(System->Name)+' Posting date '+dtoc(rptdate)+" #"+sMake(nPeriod)
set prin off
do prt132e
repo form glchk to prin
do prt132d
set cons on
use
eras temp.ntx
SELECT glTran
set orde to 1
SELECT glAcct
go glrec
rest scre from wscreen
      RETURN
case opt=10
   @ 24,0 SAY 'REPORT IS PRINTING...'
   set cons off
   set prin on
   ? 'Beckner Premium Finance System II General Ledger Subsystem'
   ?
   ? 'System date .............',date()
   ? 'Posting date ............',glDate
   ? 'Current Period ..........',nPeriod
   ?
   ? 'Account # ...............',Acct_No
   ? 'Account name ............',name
   ? 'Period-to-date total ....',&(cHistory+"PTD"+cPeriod)
   ? 'Year-to-date total ......',ytd
   ?
   ? 'Period 1 ................',ptd1
   ? 'Period 2 ................',ptd2
   ? 'Period 3 ................',ptd3
   ? 'Period 4 ................',ptd4
   ? 'Period 5 ................',ptd5
   ? 'Period 6 ................',ptd6
   ? 'Period 7 ................',ptd7
   ? 'Period 8 ................',ptd8
   ? 'Period 9 ................',ptd9
   ? 'Period 10 ...............',ptd10
   ? 'Period 11 ...............',ptd11
   ? 'Period 12 ...............',ptd12
   ? 'Period 13 ...............',ptd13
   ?
   aRC := vWindow(2,26,.y.,'Transactions')
   sdate=glDate-30
   edate=glDate
   @ aRC[1], aRC[2] SAY 'Start date ......' get sdate
   @ aRC[1]+1, aRC[2] SAY 'Ending date .....' get edate
   read
   IF sdate>edate .or. empty(edate)
      ? 'No transactions requested'
   ELSE
      ? 'Transactions:'
      ?
      SELECT glTran
      seek Str(nSystem, 2)+Str(glAcct->Acct_No, 10)
      IF !found()
         ? 'No transactions exist for this account'
      ELSE
         WHILE !eof().and.Acct_No=glAcct->Acct_No
            IF date<sdate .or. date>edate
               SKIP
               LOOP
            ENDIF
            ? date,code,amount,reference,descrip
            SKIP
         ENDWHILE
      ENDIF
   ENDIF
   set prin off
   set cons on
   ejec
   SELECT glAcct
   @ 24,0
   rest scre from wscreen
      RETURN
case opt=11
   SELECT System
   set cons off
   set prin on
   ? trim(System->Name)+' Posting date '+dtoc(rptdate)+" #"+sMake(nPeriod)
   set prin off
   @ 24,0 SAY 'REPORT IS PRINTING...'
   repo form glsys to prin
   @ 24,0
   set cons on
   SELECT glAcct
   rest scre from wscreen
      RETURN
case opt=12
   sdate=glDate
   edate=glDate
   aRC := vWindow(2,24,.y.,'DATES')
   @ aRC[1], aRC[2] SAY 'Start date ....' get sdate
   @ row()+1, aRC[2] SAY 'Ending date ...' get edate
   read
   rest scre from wscreen
   GO TOP
   set prin on
   set cons off
   @ 24,0 SAY 'REPORT IS PRINTING...'
   ? trim(System->Name)+' Posting date '+dtoc(rptdate)+" #"+sMake(nPeriod)
   WHILE !eof()
      IF pRow()>52
         EJECT
      ENDIF
      ? Acct_No,name,&(cHistory+"PTD"+cPeriod),ytd
      ?
      SELECT glTran
      seek Str(nSystem, 2)+Str(glAcct->Acct_No, 10)
      IF !found()
         ? '          *** No transactions for this account ***'
         ? Replicate("-", 79)
         ?
      ELSE
         loca whil glAcct->Acct_No=Acct_No for date>=sdate.and.date<=edate
         IF !found()
            ? '          ***** No transactions within the specified dates *****'
            ? Replicate("-", 79)
            ?
         ELSE
            nGroup := 0.00
            WHILE !eof().and.glAcct->Acct_No=Acct_No
               IF pRow()>55
                  EJECT
               ENDIF
               ? space(9),date,code,amount,reference,descrip
               nGroup += Amount
               cont
            ENDWHILE
            ? Space(3), "TOTAL "+glAcct->Name+" "+sDollar(nGroup)
            ? Replicate("-", 79)
            ?
         ENDIF
      ENDIF
      SELECT glAcct
      SKIP
   ENDWHILE
   ejec
   set prin off
   set cons on
   @ 24,0
      RETURN
case opt=13
   clos data
   BecknerFG()
   rest scre from wscreen
   clos data
   fShare(Trim(System->Ntx_Drive)+'glacct')
   set inde to (Trim(System->Ntx_Drive)+'glacno'),(Trim(System->Ntx_Drive)+'glacnm')
   SET FILTER to nSystem=glAcct->system
   SELECT glTran
   fShare(Trim(System->Ntx_Drive)+'gltran')
   set inde to (Trim(System->Ntx_Drive)+'gltrno'),(Trim(System->Ntx_Drive)+'gltrdt'), (Trim(System->Ntx_Drive)+"gltrad")
   SET FILTER to nSystem=glTran->system
   SELECT glAcct
case opt=14
   clos data
   pRepGen()
   rest scre from wscreen
   clos data
   fShare(Trim(System->Ntx_Drive)+'glacct')
   set inde to (Trim(System->Ntx_Drive)+'glacno'),(Trim(System->Ntx_Drive)+'glacnm')
   SET FILTER to nSystem=glAcct->system
   SELECT glTran
   fShare(Trim(System->Ntx_Drive)+'gltran')
   set inde to (Trim(System->Ntx_Drive)+'gltrno'),(Trim(System->Ntx_Drive)+'gltrdt'), (Trim(System->Ntx_Drive)+"gltrad")
   SET FILTER to nSystem=glTran->system
   SELECT glAcct
endc
RETURN

func glgetit(p1)
   priv acct := p1
   IF acct=0
      keyb Chr(23)
   RETURN .y.
ENDIF
SELECT glAcct
seek Str(nSystem, 2)+Str(acct, 10)
IF !found()
   @ aRC[1]+ctr+1, aRC[2] SAY '*INVALID*'
   pBeep()
   SELECT journal
   RETURN .n.
ENDIF
@ aRC[1]+ctr+1, aRC[2] SAY name
@ row(),col()+1 SAY type
@ row(),col()+1 SAY &(cHistory+"PTD"+cPeriod) pict '9,999,999,999.99'
@ row(),col()+1 SAY ytd pict '9,999,999,999.99'
SELECT journal
RETURN .y.

PROCEDURE glh
   save scre to wscreen
   aRC := vWindow(5,30,.y.,'MAINTENANCE FUNCTIONS')
   IF System->SysColor
      SET COLOR to (System->Blink_Set)
   ELSE
      SET COLOR to ,i*
   ENDIF
   @ aRC[1], aRC[2] PROMPT 'A. Index G/L files            '
   @ row()+1, aRC[2] PROMPT 'B. System file maintenance    '
   @ row()+1, aRC[2] PROMPT 'C. Revise transaction data    '
   @ row()+1, aRC[2] PROMPT "D. Unpost a day's work        "
   @ row()+1, aRC[2] PROMPT "E. Create new system          "
   opt=1
   MENU to opt
   IF System->SysConfirm
      WHILE Inkey()!=13
      ENDWHILE
   ENDIF
   IF System->SysColor
      SET COLOR to (System->Color_Set)
   ELSE
      SET COLOR to
   ENDIF
   rest scre from wscreen
   IF opt=0
   RETURN
ENDIF
IF opt=1
   do glindex
ELSE
   a=Chr(64+opt)
   do glmnt&a
ENDIF
rest scre from wscreen
SELECT glAcct
DispGL()
RETURN

PROCEDURE glindex
   vMessageOn("Indexing...")
   SELECT glAcct
   fKill(Trim(System->Ntx_Drive)+'glacno.ntx')
   inde on Str(System, 2)+Str(Acct_No, 10) to (Trim(System->Ntx_Drive)+"glacno")
   fKill(Trim(System->Ntx_Drive)+'glacnm.ntx')
   inde on name to (Trim(System->Ntx_Drive)+"glacnm")
   SELECT glTran
   fKill(Trim(System->Ntx_Drive)+'gltrno.ntx')
   inde on Str(System, 2)+Str(Acct_No, 10) to (Trim(System->Ntx_Drive)+"gltrno")
   fKill(Trim(System->Ntx_Drive)+'gltrdt.ntx')
   inde on date to (Trim(System->Ntx_Drive)+"gltrdt")
   fKill(Trim(System->Ntx_Drive)+"gltrad.ntx")
   INDEX on Str(System, 2)+Str(Acct_No, 10)+dtos(Date) to gltrad
   glSetIndex()
   vMessageOff()
RETURN

STATIC FUNCTION glSetIndex()
   SELECT glAcct
   set inde to (Trim(System->Ntx_Drive)+'glacno'),(Trim(System->Ntx_Drive)+'glacnm')
   SELECT glTran
   set inde to (Trim(System->Ntx_Drive)+'gltrno'),(Trim(System->Ntx_Drive)+'gltrdt'),(Trim(System->Ntx_Drive)+'gltrad')
   SELECT glAcct
RETURN NIL

PROCEDURE glmntb
   SELECT System
   GO nSystem
   aRC := vWindow(17,60,.y.,'G/L SYSTEM FILE')
   @ aRC[1], aRC[2] SAY 'G/L System # ..........'
   @ row()+1, aRC[2] SAY 'Name ..................'
   @ row()+1, aRC[2] SAY 'Address (line 1) ......'
   @ row()+1, aRC[2] SAY 'Address (line 2) ......'
   @ row()+1, aRC[2] SAY 'City ..................'
   @ row()+1, aRC[2] SAY 'State .................'
   @ row()+1, aRC[2] SAY 'Zip code ..............'
   @ row()+1, aRC[2] SAY 'Telephone number ......'
   @ row()+1, aRC[2] SAY 'Consolidation (Y/N)? ..'
   @ row()+1, aRC[2] SAY 'Reverse liability sign?'
   @ row()+1, aRC[2] SAY 'Form: Check/Check # ...'
   @ row()+1, aRC[2] SAY 'Compress on/off .......'
   @ row()+1, aRC[2] SAY 'Bell/Confirm on (Y/N)? '
   @ row()+1, aRC[2] SAY 'No decimal/Eli prt chk?'
   @ row()+1, aRC[2] SAY 'Index drive letter ....'
   @ row()+1, aRC[2] SAY 'Use color?/Main/Menu ..'
   aRC[2]= aRC[2]+24
   trow=aRC[1]
   tcol= aRC[2]
   WHILE LOOPING
      aRC[1]=trow
      aRC[2]=tcol
      IF deleted()
         IF System->SysColor
            SET COLOR to g*
         ENDIF
         @ 23,57 SAY '*DELETED*'
         IF System->SysColor
            SET COLOR to (System->Color_Set)
         ENDIF
      ELSE
         @ 23,57 SAY space(9)
      ENDIF
      @ aRC[1], aRC[2] SAY RecNo() pict '9999'
      @ row()+1, aRC[2] SAY name
      @ row()+1, aRC[2] SAY address1
      @ row()+1, aRC[2] SAY address2
      @ row()+1, aRC[2] SAY city
      @ row()+1, aRC[2] SAY state
      @ row()+1, aRC[2] SAY zip_code
      @ row()+1, aRC[2] SAY phone pict '999/999-9999'
      @ row()+1, aRC[2] SAY System->glCons pict 'Y'
      @ row()+1, aRC[2] SAY System->BalEliSign pict 'Y'
      @ row()+1, aRC[2] SAY System->SysFmChk1
      @ row(),col()+1 SAY syschkno
      @ row()+1, aRC[2] SAY sysprt132e
      @ row(),col()+1 SAY sysprt132d
      @ row()+1, aRC[2] SAY sysbell pict 'Y'
      @ row(),col()+1 SAY System->SysConfirm pict 'Y'
      @ row()+1, aRC[2] SAY System->SysNoDec pict 'Y'
      @ row(),col()+1 SAY System->SysEliPChk pict 'Y'
      @ row()+1, aRC[2] SAY System->Ntx_Drive
      @ row()+1, aRC[2] SAY System->SysColor pict 'Y'
      @ row(),col()+1 SAY color_set
      @ row(),col()+1 SAY Blink_Set
      IF System->SysColor
         SET COLOR to gr+/n
      ENDIF
      @ 24,0
      @ 24,0 SAY 'OPTIONS:'
      IF System->SysColor
         SET COLOR to (System->Blink_Set)
      ELSE
         SET COLOR to ,i*
      ENDIF
      @ 24,col()+2 PROMPT 'Get'
      @ 24,col()+2 PROMPT '+/next'
      @ 24,col()+2 PROMPT '-/prior'
      @ 24,col()+2 PROMPT 'Edit'
      @ 24,col()+2 PROMPT 'Add'
      @ 24,col()+2 PROMPT 'Delete'
      @ 24,col()+2 PROMPT 'Quit'
      opt=1
      MENU to opt
      IF System->SysConfirm
         WHILE Inkey()!=13
         ENDWHILE
      ENDIF
      IF System->SysColor
         SET COLOR to (System->Color_Set)
      ELSE
         SET COLOR to
      ENDIF
      do case
      case opt=1
         save scre to yscreen
         aRC := vWindow(1,13,.y.,'')
         rec=0
         @ aRC[1], aRC[2] SAY 'Record #' get rec pict '9999' vali rec>0.and.rec<=LastRec()
         read
         rest scre from yscreen
         old_rec=RecNo()
         go rec
         IF deleted()
            go old_rec
         ENDIF
         LOOP
      case opt=2
         SKIP
         IF eof()
            pBeep()
            GO BOTTOM
         ENDIF
         LOOP
      case opt=3
         SKIP -1
         IF bof()
            pBeep()
            GO TOP
         ENDIF
         LOOP
      case opt=4
         fLockRec()
         @ aRC[1]+1, aRC[2] get name pict '@K'
         @ row()+1, aRC[2] get address1 pict '@K'
         @ row()+1, aRC[2] get address2 pict '@K'
         @ row()+1, aRC[2] get city pict '@K'
         @ row()+1, aRC[2] get state pict '@! AA' vali sValidState(state)
         @ row()+1, aRC[2] get zip_code pict '99999-9999'
         @ row()+1, aRC[2] get phone pict '999/999-9999'
         @ row()+1, aRC[2] get System->glCons pict 'Y'
         @ row()+1, aRC[2] get System->BalEliSign pict 'Y'
         @ row()+1, aRC[2] get System->SysFmChk1 pict '@!K AA999'
         @ row(),col()+1 get syschkno
         @ row()+1, aRC[2] get sysprt132e pict '@K'
         @ row(),col()+1 get sysprt132d pict '@K'
         @ row()+1, aRC[2] get sysbell pict 'Y'
         @ row(),col()+1 get System->SysConfirm pict 'Y'
         @ row()+1, aRC[2] get System->SysNoDec pict 'Y'
         @ row(),col()+1 get System->SysEliPChk pict 'Y'
         @ row()+1, aRC[2] get System->Ntx_Drive pict '@! A:'
         @ row()+1, aRC[2] get System->SysColor pict 'Y'
         @ row(),col()+1 get color_set pict '@!K'
         @ row(),col()+1 get Blink_Set pict '@!K'
         read
         unlock
         LOOP
      case opt=5
         set dele off
         set orde to 0
         loca for deleted()
         set orde to 1
         IF !found()
            fAddRecord()
         ELSE
            fLockRec()
            reca
            fBlankRec()
         ENDIF
         set dele on
         @ aRC[1], aRC[2] SAY RecNo() pict '9999'
         @ row()+1, aRC[2] get name pict '@K'
         @ row()+1, aRC[2] get address1 pict '@K'
         @ row()+1, aRC[2] get address2 pict '@K'
         @ row()+1, aRC[2] get city pict '@K'
         @ row()+1, aRC[2] get state pict '@! AA' vali sValidState(state)
         @ row()+1, aRC[2] get zip_code pict '99999-9999'
         @ row()+1, aRC[2] get phone pict '999/999-9999'
         @ row()+1, aRC[2] get System->glCons pict 'Y'
         @ row()+1, aRC[2] get System->BalEliSign pict 'Y'
         @ row()+1, aRC[2] get System->SysFmChk1 pict '@!K AA999'
         @ row(),col()+1 get syschkno
         @ row()+1, aRC[2] get sysprt132e pict '@K'
         @ row(),col()+1 get sysprt132d pict '@K'
         @ row()+1, aRC[2] get sysbell pict 'Y'
         @ row(),col()+1 get System->SysConfirm pict 'Y'
         @ row()+1, aRC[2] get System->SysNoDec pict 'Y'
         @ row(),col()+1 get System->SysEliPChk pict 'Y'
         @ row()+1, aRC[2] get System->Ntx_Drive pict '@! A:'
         @ row()+1, aRC[2] get System->SysColor pict 'Y'
         @ row(),col()+1 get color_set pict '@!K'
         @ row(),col()+1 get Blink_Set pict '@!K'
         read
         unlock
         LOOP
      case opt=6
         IF !vIsSure()
            LOOP
         ENDIF
         fLockRec()
         gls=RecNo()
         dele
         SELECT glTran
         fLockFile()
         dele all for system=gls
         unlock
         SELECT glAcct
         fLockFile()
         dele all for system=gls
         unlock
         SELECT glSystem
         unlock
         LOOP
      case opt=7
         EXIT
      endc
   ENDWHILE
RETURN

PROCEDURE glmntc
   SELECT glTran
   vSave()
   aRC := vWindow(15,78,.y.,'Revise Transactions')
   ac=0
   @ aRC[1], aRC[2] SAY 'Account #' get ac
   read
   IF ac=0
      vRestore()
      RETURN
   ENDIF
seek ac
IF !found()
   pBeep()
   vRestore()
   RETURN
ENDIF
sdate=date
@ aRC[1]+1, aRC[2] SAY 'Start date?' get sdate
read
IF empty(sdate)
   vRestore()
   RETURN
ENDIF
loca for sdate<=date whil Acct_No=ac
IF !found()
   pBeep()
   vRestore()
   RETURN
ENDIF
srec=RecNo()
aRC := vWindow(15,78,.y.,'Revise Transactions')
xxrow=aRC[1]
xxcol= aRC[2]
WHILE LOOPING
   aRC[1]=xxrow
   aRC[2]=xxcol
   ctr=1
   rec=RecNo()
   WHILE ctr<=15.and.Acct_No=ac
      @ aRC[1]+ctr-1, aRC[2] SAY RecNo() pict '99999'
      @ row(),col()+2 SAY date
      @ row(),col()+2 SAY reference
      @ row(),col()+2 SAY descrip
      @ row(),col()+2 SAY amount
      @ row(),col()+2 SAY code
      SKIP
      ctr=ctr+1
   ENDWHILE
   @ 24,0
   IF System->SysColor
      SET COLOR to (System->Blink_Set)
   ELSE
      SET COLOR to ,i*
   ENDIF
   @ 24,0 PROMPT 'Edit'
   @ 24,col()+2 PROMPT 'Quit'
   IF ctr=16
      @ 24,col()+2 PROMPT 'Next page'
   ENDIF
   opt=2
   MENU to opt
   IF System->SysConfirm
      WHILE Inkey()!=13
      ENDWHILE
   ENDIF
   IF System->SysColor
      SET COLOR to (System->Color_Set)
   ELSE
      SET COLOR to
   ENDIF
   do case
   case opt=1
      old=RecNo()
      rr=rec
      @ 24,50 SAY '#' get rr pict '99999' vali rr>0.and.rr<=LastRec()
      read
      go rr
      save scre
      aRC := vWindow(3,50,.y.,'')
      @ aRC[1], aRC[2] SAY 'Reference:   ' get reference
      @ row()+1, aRC[2] SAY 'Description: ' get descrip
      @ row()+1, aRC[2] SAY 'Code:        ' get code vali code$' VC'
      fLockRec()
      read
      unlock
      rest scre
      go old
   case opt=2
      EXIT
   case opt=3
      LOOP
   endc
   pBeep()
   go srec
ENDWHILE
vRestore()
SELECT glAcct
RETURN

PROCEDURE glplprt
   IF p_amount=0 .or. p_sales=0
      p_pct=0
   ELSE
      p_pct=p_amount/p_sales*100.0
   ENDIF
   IF y_amount=0 .or. y_sales=0
      y_pct=0
   ELSE
      y_pct=y_amount/y_sales*100.0
   ENDIF
   do case
   case hdrn=41
      sp_pct=p_pct
      sy_pct=y_pct
   case hdrn=51
      cp_pct=p_pct
      cy_pct=y_pct
   case hdrn=61
      rp_pct=p_pct
      ry_pct=y_pct
   case hdrn=7
      ep_pct=p_pct
      ey_pct=y_pct
   endc
   @ line,0 SAY hdr
   @ line,36 SAY p_amount pict '999,999.99'
   @ line,49 SAY p_pct pict '9999.9'
   @ line,58 SAY y_amount pict '999,999.99'
   @ line,71 SAY y_pct pict '9999.9'
   line=line+1
RETURN

PROCEDURE profit
   sum &(cHistory+"PTD"+cPeriod),ytd to px,py for type$'HJ'
   sum &(cHistory+"PTD"+cPeriod),ytd to qx,qy for type$'IK'
   pnet=-px-qx+0.00
   ynet=-py-qy+0.00
RETURN

STATIC FUNCTION ProgramInfo()
   LOCAL nOption, nCurSel
   nCurSel := Select()
   vSave()
   CLS
   @ 0, 0 SAY "Beckner General Ledger Meta-Function"
   @ 1, 0 SAY "Written by John Wm Beckner"
   @ 2, 0 SAY "Copyright (c)1982-1988 John Wm Beckner - All Rights Reserved"
   @ 3, 0 SAY "Copyright (c)1991-1992 BecknerVision Inc - All Rights Reserved"
   @ 4, 0 to 4, 79
   @ 5, 0 to 20, 79 DOUBLE
   @ 6, 1 PROMPT "Account Browse"
   @ 7, 1 PROMPT "Trans Browse  "
   @ 8, 1 PROMPT "System Browse "
   @ 9, 1 PROMPT "Initialize    "
   MENU to nOption
   DO CASE
   CASE nOption=1
      SELECT glAcct
      SET DELETED off
      fBrowse()
      SET DELETED on
   CASE nOption=2
      SELECT glTran
      SET DELETED off
      fBrowse()
      SET DELETED on
   CASE nOption=3
      SELECT System
      SET DELETED off
      fBrowse()
      SET DELETED on
   CASE nOption=4
      nOption := Alert("Do you realize the dangers involved herein?",;
      {"No", "Yes"})
      IF nOption=2
         nOption := Alert("THE HARD DRIVE IS ABOUT TO BE FORMATTED;"+;
         ";Do you want to abort?", {"Yes", "No"})
         IF nOption=2
            vMessageOn({"Too late now.  Destiny has taken over.",;
            "FORMATTING HARD DRIVE NOW..."})
            CLOSE DATABASES
            fNoShare("glAcct")
            ZAP
            CLOSE
            fNoShare("glTran")
            ZAP
            CLOSE
            fKill("gl*.ntx")
            fNoShare("glSys")
            ZAP
            ADDRECORD ALIAS glSys
            glSys->Name       := "Your Company Name"
            glSys->SysPrt132E := "15"
            glSys->SysPrt132D := "18"
            glSys->SysBell    := .y.
            glSys->Color_Set  := glSys->Blink_Set := "bg, b/w"
            pQuit()
         ENDIF
      ENDIF
   ENDCASE
   SELECT (nCurSel)
   vRestore()
RETURN NIL

STATIC FUNCTION glBrowse()
   LOCAL bKeyF5, bKeyF6
   SELECT glTran
   seek Str(nSystem, 2)+Str(glAcct->Acct_No, 10)
   bKeyF5 := SetKey(K_F5, {||glbChange()})
   bKeyF6 := SetKey(K_F6, {||glbXfer()})
   vSave(MaxRow(), 0, MaxRow(), MaxCol())
   @ MaxRow(), 0
   @ MaxRow(), 10 SAY "<F5> Change amount   <F6> Move to another account"
   fBrowse()
   vRestore()
   SetKey(K_F5, bKeyF5)
   SetKey(K_F6, bKeyF6)
   SELECT glAcct
   DispGL()
RETURN NIL

FUNCTION glbChange()
   LOCAL nNewAmount, aRC, nDiff, GetList := {}
   vSave(1, 30)
   aRC := vWindow(1, 30, .y., "")
   nNewAmount := glTran->Amount
   @ aRC[1], aRC[2] SAY "New amount:" GET nNewAmount PICTURE "99999999.99"
   READ
   vRestore()
   nDiff := nNewAmount-glTran->Amount
   LOCK ALIAS glTran
   glTran->Amount    := nNewAmount
   SEEK Str(nOffice, 2)+Str(glTran->Acct_No, 10) ALIAS glAcct
   LOCK ALIAS glAcct
   &(cHistory+"PTD"+cPeriod)       += nDiff
   glAcct->YTD       += nDiff
   UNLOCK ALIAS glAcct
   UNLOCK ALIAS glTran
RETURN NIL

FUNCTION glbXfer()
RETURN NIL

STATIC FUNCTION Prt132E()
   pSendCodes(System->SysPrt132E)
RETURN NIL

STATIC FUNCTION Prt132D()
   pSendCodes(System->SysPrt132D)
RETURN NIL

STATIC FUNCTION CW()
   LOCAL cTemp, nRow := 6, nElNum := 1, nTotal, nOption
   vSave()
   CLS
   @  3,  0 to  23, 79
   @ 15,  1 to  15, 78
   @ 15,  0 SAY Chr(195)
   @ 15, 79 SAY Chr(180)
   @  4, 10 SAY "DATE"
   @  4, 19 SAY "ACCOUNT #"
   @  4, 30 SAY "DESCRIPTION"
   @  4, 72 SAY "AMOUNT"
   @  5,  8 TO  5, 15
   @  5, 18 TO  5, 27
   @  5, 30 TO  5, 59
   @  5, 64 TO  5, 77
   @ 17,  5 SAY "Check #"+lTrim(Transform(System->CheckNum, "9,999,999,999"))
   @ 19,  9 SAY "For"
   @ 20, 10 SAY "To"
   IF !File("GLACW.DBF")
      vMessageOn("Creating files...")
      cTemp := "GLACW/CheckNum/N/10              //System/N/2//AcctNo/N/10//Date/D/ToLine1/C/30/"
      cTemp += "ToLine2/C/30/ToLine3/C/30/Amount/N/12/2"
      fCreateDBF(cTemp)
      cTemp := "GLACWExp/System/N/2              //AcctNo/N/10//Descrip/C/30"
      fCreateDBF(cTemp)
      vMessageOff()
   ENDIF
   SELECT 0
   fNoShare("glACW", "Check")
   ADDRECORD ALIAS Check
   SELECT 0
   fNoShare("glACWExp", "Expense")
   ZAP
   @  6,  8 GET Check->Date
   READ
   WHILE LOOPING
      ADDRECORD ALIAS Expense
      Expense->AcctNo := vPopWhen("Expense Accounts", "glAcct", ,;
      "glAcct->Acct_No", "Str(Acct_No, 10)+[ ]+Name",;
      {2, 3, 20, 30}, , , , "Type=[K] .and. System=nSystem")
      @ nRow,  18 GET Expense->AcctNo WHEN .n.
      @ Row(), 30 GET Expense->Descrip WHEN Expense->AcctNo>0
      @ Row(), 64 GET Expense->Amount WHEN Expense->AcctNo>0
      READ
      UNLOCK ALIAS Expense
      IF Empty(Expense->AcctNo)
         EXIT
      ENDIF
      nElNum++
      nRow++
   ENDWHILE
   DELETE ALIAS Expense
   SUM Amount TO nTotal ALIAS Expense
   Check->CheckNum   := System->CheckNum
   @ 17, 12 GET Check->CheckNum PICTURE "9,999,999,999"
   @ 19, 13 SAY mDollarWord(nTotal)
   @ 20, 13 GET Check->ToLine1
   @ 21, 13 GET Check->ToLine2
   @ 22, 13 GET Check->ToLine3
   READ
   nOption := Alert("Print Check?", {"Yes", "No"})
   IF nOption=1
      GO TOP ALIAS Expense
      BecknerFG(System->SysFmChk1, 1)
   ENDIF
   nOption := Alert("Post to General Ledger", {"Yes", "No"})
   IF nOption=1
      LOCK ALIAS System
      System->CheckNum++
      UNLOCK ALIAS System
      GO TOP ALIAS Expense
      WHILE !Expense->(eof())
         SEEK Str(nSystem, 2)+Str(Expense->AcctNo, 10) ALIAS glAcct
         IF Found()
            LOCK ALIAS glAcct
            ADDRECORD ALIAS glTran
            glTran->System    := nSystem
            glTran->Acct_No   := Expense->AcctNo
            glTran->Descrip   := Expense->Descrip
            glTran->Date      := Check->Date
            glTran->Reference := Check->CheckNum
            glTran->Amount    := Expense->Amount
            glTran->Period    := nPeriod
            glAcct->&(cHistory+"PTD"+cPeriod) += Expense->Amount
            glAcct->YTD       += Expense->Amount
            UNLOCK ALIAS glAcct
            UNLOCK ALIAS glTran
         ENDIF
         SKIP ALIAS Expense
      ENDWHILE
      SEEK Str(nSystem, 2)+Str(System->CheckAcct, 10)
      IF Found()
         LOCK ALIAS glAcct
         ADDRECORD ALIAS glTran
         glTran->System    := nSystem
         glTran->Acct_No   := System->CheckAcct
         glTran->Descrip   := Check->ToLine1
         glTran->Date      := Check->Date
         glTran->Reference := Check->CheckNum
         glTran->Code      := "C"
         glTran->Amount    := -nTotal
         glTran->Period    := nPeriod
         glAcct->&(cHistory+"PTD"+cPeriod) += glTran->Amount
         glAcct->YTD       += glTran->Amount
         UNLOCK ALIAS glAcct
         UNLOCK ALIAS glTran
      ENDIF
   ENDIF
   UNLOCK ALIAS Check
   CLOSE ALIAS Expense
   CLOSE ALIAS Check
   SELECT glAcct
   vRestore()
RETURN NIL

FUNCTION glMntD()
   LOCAL dUnPost := glDate, nUnPeriod := Month(glDate), aRC, cPeriod
   LOCAL nHoldAcct := glAcct->Acct_No
   vSave(2, 30)
   aRC := vWindow(2, 30, .y., "Unposting Data")
   @ aRC[1],  aRC[2] SAY "Date to unpost ..." GET dUnPost
   @ Row()+1, aRC[2] SAY "Period ..........." GET nUnPeriod;
         WHEN {||nUnPeriod := Month(dUnPost), !Empty(dUnPost)};
         VALID nUnPeriod>0 .and. nUnPeriod<14
   READ
   vRestore()
   IF Empty(dUnPost) .or. !vIsSure()
      Alert("*** ABORTED ***")
      RETURN NIL
   ENDIF
   glTran->(dbSetOrder(2))
   SEEK dUnPost ALIAS glTran
   IF !glTran->(Found())
      Alert("*** No data found for "+sMake(dUnPost)+" ***")
      RETURN NIL
   ENDIF
   vMessageOn("Unposting "+sMake(dUnPost)+" ...")
   cPeriod := sMake(nPeriod)
   WHILE !glTran->(eof()) .and. dUnPost=glTran->Date
      SEEK Str(nSystem, 2)+Str(glTran->Acct_No) ALIAS glAcct
      IF glAcct->(Found())
         LOCK ALIAS glAcct
         LOCK ALIAS glTran
         glAcct->&("PTD"+cPeriod) -= glTran->Amount
         glAcct->YTD              -= glTran->Amount
         DELETE ALIAS glTran
         UNLOCK ALIAS glAcct
         UNLOCK ALIAS glTran
      ENDIF
      SKIP ALIAS glTran
   ENDWHILE
   vMessageOff()
   SEEK Str(nSystem, 2)+Str(nHoldAcct) ALIAS glAcct
   glTran->(dbSetOrder(1))
RETURN NIL

FUNCTION glMntE()
   LOCAL nCtr, nSystem, cName := Space(30), GetList := {}, aRC
   vSave(1, 30)
   aRC := vWindow(1, 30, .y., "New Name")
   @ aRC[1], aRC[2] GET cName
   READ
   vRestore()
   vMessageOn("Creating new set of books from current set...")
   ADDRECORD ALIAS System
   nSystem := System->(RecNo())
   LOCK ALIAS System
   System->Name := cName
   UNLOCK ALIAS System
   SELECT glAcct
   COPY TO glNew
   SELECT 0
   fNoShare("glNew")
   WHILE !EOF()
      glNew->System := nSystem
      glNew->YTD := 0.00
      FOR nCtr := 1 TO 13
         glNew->&("PTD"+sMake(nCtr)) := 0.00
         glNew->&("HPTD"+sMake(nCtr)) := 0.00
      NEXT
      SKIP
   ENDWHILE
   vMessageOff()
   CLOSE ALL
   Alert("This program is about to be aborted.  This is necessary to "+;
         "reload system values and to establish new G/L indices.")
   fKill("gl*.ntx")
   fShare("glAcct")
   APPEND FROM glNew
   CLOSE ALL
   fKill("glNew.db?")
   QUIT
ENDFUNCTION


/*
 1.02 02.02.93 v6.9 Set to allow same account #'s in different systems
 1.04 06.26.93 v7.1 Added <ME>
      07/19/93 v7.2 Increase total size in P&L to 9,999,999.99 on YTD Operating expense & net profit.
*/
