/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the number of days gone in a quarter
//
// Syntax:
//    dDaysGoneQ([<dAny>]) -> nDays
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dAny        Any date [Date()]
//
// Returns:
//    nDays       Number of days gone in quarter
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("1/1/96")
//       ? dDaysGone(dTest)      /* 1 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the number of days gone in the current quarter, including the
//    specified date, which defaults to the current system date.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dDaysGoneQ(dDate)
   DEFAULT dDate TO Date()
   RETURN dDate-dBegQuarter(dDate)+1
ENDFUNCTION
