/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc             
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "set.ch"

FUNCTION aPrint(aArray, nStart, nCount, cDevice, lFormFeed, nLPP)
   LOCAL lOldDevice, lOldConsole, lOldPrint, nCtr, nLine := 0
   DEFAULT nLPP         TO 58, lFormFeed TO .y., cDevice TO "PRN",;
         nStart    TO 1
   nCount      := iif(nCount = NIL, Len(aArray), nCount+nStart-1)
   lOldDevice  := Set(_SET_DEVICE, cDevice)
   lOldConsole := Set(_SET_CONSOLE, .n.)
   lOldPrint   := Set(_SET_PRINTER, .y.)
   FOR nCtr := nStart to nCount
      qQout(aArray[nCtr], CRLF)
      iif(++nLine>=nLPP, Eval({||qQout(FORMFEED), nLine := 0}), NIL)
   NEXT
   iif(lFormFeed, qQout(FORMFEED), NIL)
   Set(_SET_DEVICE, lOldDevice)
   Set(_SET_CONSOLE, lOldConsole)
   Set(_SET_PRINTER, lOldPrint)
ENDFUNCTION
