;; TIP 877:  PLATDIM.LSP (C)1993, WATSON H. KILBOURNE

;;  Adds surveyor angle and line length dimensions to existing drawing.
;;  Option of linear inline dimensions or over/under line dimensioning.
;;  The lines on drawing must be drawn in correct angular direction.

(defun c:PLATDIM (/ CE BM LN TH YN LX SP EP AN LG MP TA TB TX TY EX EY NY)
   (setq CE (getvar "CMDECHO"))
   (setq BM (getvar "BLIPMODE"))
   (defun NE (NE)
      (setvar "CMDECHO" CE)
      (setvar "BLIPMODE" BM)
      (princ "Function cancelled ")
      (princ)
   )
   (setq OE *error* *error* NE)
   (while (= LN nil)
       (setq LN (entsel "\nSelect line for surveyor dimensions: "))
   )
   (setq TS (getvar "TEXTSIZE"))
   (prompt "\nEnter text height for dimensions <")
   (princ (rtos TS 2 2))
   (setq TH (getreal ">: "))
   (if (= TH nil)
       (setq TH TS)
   )
   (setq YN (getstring "\nOver & under line dimensions? (Y or N) <Y> "))
   (setvar "CMDECHO" 0)
   (setvar "BLIPMODE" 0)
   (setq LX (entget (car LN))                       ; Line identification
         SP (cdr (assoc 10 LX))                     ; Start point of line
         EP (cdr (assoc 11 LX))                     ; End point of line
         AN (angle SP EP)                           ; Angle of line
         LG (distance SP EP)                        ; Length of line
         LF (/ LG 12)                               ; Length of line in feet
         MP (polar SP AN (/ LG 2))                  ; Midpoint of line
         TA (polar MP (+ AN (* pi 0.5)) (/ TH 2))   ; End of angle text
         TB (polar TA AN (* TH 2))                  ; Start of dimension text
         UN (polar MP (+ AN (* pi 1.5)) (* TH 1.5)) ; Under line start
         TX (angtos AN 4 4)                         ; Angle in surveyor units
         TY (rtos LF 2 2)                           ; Length in decimal units
   )
   (if (or (= YN "n") (= YN "N"))
       (progn
          (command ".TEXT" "R" TA TH (/ (* AN 180) pi) (strcase TX))
          (setq EX (entlast))
          (command ".TEXT" TB TH (/ (* AN 180) pi) (strcat (strcase TY) "'"))
          (setq EY (entlast))
       )
       (progn
          (command "TEXT" "C" TA TH (/ (* AN 180) pi) (strcase TX))
          (setq EX (entlast))
          (command "TEXT" "C" UN TH (/ (* AN 180) pi)(strcat(strcase TY) "'"))
          (setq EY (entlast))
       )
   )
   (setq NY (getstring "\nRotate dimension 180 degrees? (Y or N) <N> "))
   (if (or (= NY "y") (= NY "Y"))
           (command "ROTATE" EX EY "" MP "180")
   )
   (setvar  "BLIPMODE" BM)
   (setvar "CMDECHO" CE)
   (setq *error* OE OE nil)
   (princ)
)
