;;TIP 875: DOTLINE.LSP (C)1993, WATSON KILBOURNE

;;  Dotted linetype with variable spacing and dot diameter
;;  Watson Kilbourne, October 12, 1992

(defun C:DOTLINE (/ CE BM OE SP EP DS BD DD AN NU PA)
   (setq CE (getvar "cmdecho"))
   (setq BM (getvar "blipmode"))
   (defun NE (NE)
      (setvar "cmdecho" CE)
      (setvar "blipmode" BM)
      (princ "Function cancelled")
      (princ)
   )
   (setq OE *error* *error* NE)
   (while (= SP nil) (setq SP (getpoint "\nStart of dotted line: ")))
   (while (= EP nil) (setq EP (getpoint "\nNext point of dotted line: ")))
   (setq DS (distance SP EP))
   (setq BD (getdist "\nPick or enter distance between dots: "))
   (if (= BD nil) (setq BD (/ DS 20)))
   (setq DD (getdist "\nPick or enter diameter of dots: "))
   (if (= DD nil) (setq DD (/ BD 4)))
   (setvar "cmdecho" 0)
   (setvar "blipmode" 0)
   (while
      (not (= EP nil))
      (setq DS (distance SP EP)
         AN (angle SP EP)
         NU (/ DS BD)
         PA SP
      )
      (repeat (fix (+ NU 1))
         (command ".donut" "0.001" DD PA "")
         (setq PA (polar PA AN BD))
      )
      (setq SP EP)
      (setq EP (getpoint SP "\nNext point: <RETURN or ENTER to quit> "))
   )
   (setvar "blipmode" BM)
   (setvar "cmdecho" CE)
   (setq *error* OE OE nil)
   (princ)
)
