;TIP #860:  CENLINES.LSP (C)1993, LEONARD R. MILLER

; 12/21/92, Len Miller. 
; AutoCAD's DIMCEN subcommand is limited.  CENLINES.lsp, however,
; creates true centerlines.  Plus it automatically adjusts -
; depending on the circle or arc size - their courseness and
; overlap.
(defun C:CENLINES ( / PT R LN PT2 LFAC) 
   (prompt "Select circle or arc! ") 
   (terpri) 
   (command "select" "si" pause) 
   (setq PT (ssget "P")) 
   (setq PT (ssname PT 0)) 
   (setq PT (entget PT)) 
   (setq R (assoc 40 PT)) 
   (setq PT (cdr(assoc 10 PT))) 
   (setq R (cdr R)) 
   ;set primary centerline overlap ratio 
   (setq R (* 2 R 1.25)) 
   (cond 
      ; automatically select fine, standard, or course linetype 
      ; based on size of arc or circle.  Further refine 
      ; overlap ratio 
      ((< R 0.9) 
      (setq LN "center2" LFAC 1.5)) 
      ((< R 7.0) 
      (setq LN "center" LFAC 1.0)) 
      ((< R 500.0) 
      (setq LN "centerx2" LFAC 0.85)) 
   ) 
   (setq R (* R LFAC)) 
   (command "line" PT (polar PT 0 R)) 
   (command) 
   (setq PT2 (polar PT 0 ( / R 2))) 
   (command "move" "l" "" PT2 (polar PT2 pi (/ R 2))) 
   (command "change" "l" "" "p" "lt" LN "") 
(command "array" "l" "" "p" PT 2 90 "")
); end
