; TIP884:  DIS.LSP (C)1993, Bill Bratt
; Perpendicular Distance

; This is similar to the distance command but sets the osnap to 
; NEAR for the first pick and PERP for the second pick.
; This can be used where you need accurate perpendicular distances.
;****************************************************************
(defun C:DIS ()
     (graphscr)
     (setq SAVE_CMDE (getvar "cmdecho"))
     (setq SAVE_ORTHO (getvar "orthomode"))
     (setq SAVE_OSMODE (getvar "osmode"))
     (setvar "cmdecho" 0)
     (setvar "orthomode" 0)             ;Ortho off
     (setvar "osmode" 512 ) 
     (prompt "\nOSNAP is set at NEAREST")
     (setq FIRST_PNT (getpoint 
     "\nPick your first point to get a distance from: \n\n"))
     (setvar "osmode" 128 ) 
     (prompt "\nOSNAP is set at PERPENDICULAR")
     (setq SECOND_PNT (getpoint 
     "\nPick a point to get a distance from the FIRST POINT: \n\n" FIRST_PNT))
     (setq DIST_1 (distance  FIRST_PNT SECOND_PNT))
     (prompt "\nThe distance from the first point is: ") 
     (prompt (rtos DIST_1 4 6))
     (setvar "cmdecho" SAVE_CMDE )
     (setvar "orthomode" SAVE_ORTHO )
     (setvar "osmode" SAVE_OSMODE )
     (princ)
); end dis.lsp
