; TIP881:  24TO12.LSP (C)1993, John Brown
; Convert Time to 12-Hour Format

;;   Routine to convert 24 hour time format to a 12 hour format.
;;---------------------------------------------------------------
(defun 24TO12 ()
     (setq DATST (rtos (getvar "cdate") 2 16))
     (setq HRS (atoi (substr DATST 10 2)))
     (cond
          ((= HRS 00)
               (setq NHRS (itoa (+ HRS 12)))
               (setq XTR "a.m.")
          )
          ((< HRS 12)
               (setq NHRS (itoa HRS))
               (setq XTR "a.m.")
          )
          ((= HRS 12)
               (setq NHRS (itoa HRS))
               (setq XTR "p.m.")
          )
          ((> HRS 12)
               (setq NHRS (itoa (- HRS 12)))
               (setq XTR "p.m.")
          )
     )
     (setq DATE-STRING
          (strcat
               (substr DATST 5 2)        ; month
               "-"
               (substr DATST 7 2)        ; day
               "-"
               (substr DATST 3 2)        ; year
               " "
               NHRS                      ; hour
               ":"
               (substr DATST 12 2)       ; minute
               " "
               XTR                       ; a.m. or p.m.
          )
     )
); end 24to12.lsp
