; TIP925.LSP: DIMFLIP.LSP    Toggle Dimension Line   (c)1993, Chris Winsor

; Routine to change a drawing's DIMTOFL variable
; and update selected dimensions

(defun C:DIMFLIP (/ cdm last sel)
   (setq cdm (getvar "cmdecho"))
   (setvar "cmdecho" 0)
   (setq last (getvar "dimtofl"))
   (if (= last 0)
      (progn
         (setvar "dimtofl" 1)
         (prompt "To change dimension(s)...")
         (setq sel (ssget))
         (command ".dim" "update" sel "" "exit")
         (prompt "\nDimension variable [DIMTOFL] is now <on>...")
         (prompt "\nWhen text cannot fit between extension lines, ")
         (prompt "a line <will> be drawn!")
      )
   )
   (if (= last 1)
      (progn
         (setvar "dimtofl" 0)
         (prompt "To change dimension(s)...")
         (setq sel (ssget))
         (command ".dim" "update" sel "" "exit")
         (prompt "\nDimension variable [DIMTOFL] is now <off>..." )
         (prompt "\nWhen text cannot fit between extension lines, ") 
         (prompt "a line <will not> be drawn!")
      )
   )
   (redraw)
   (setvar "cmdecho" cdm)
   (princ)
); end dimflip.lsp
