; TIP920.LSP: CHSTYLE.LSP   Change Text Style   (c)1993, Michael Aaly

;
(defun NEW_ERR (msg)                  ;Error handling routine
   (if (/= msg "Function cancelled")
      (princ (strcat "\nError : " msg))
   )
   (setq *error* OLD_ERR)
   (princ)
)
(defun C:CHSTYLE ()
   (setvar "CMDECHO" 0)
   (setq OLD_ERR *error* *error* NEW_ERR)
   (setq NEW_STYLE (getstring  "\nEnter New Style Name -> "))
   (setq OLD_STYLE (getstring  "\nEnter Old Style Name -> "))
   (setq EXIST nil)
   ;
   ;See if both styles are defined then continue
   ;
   (if (and (tblsearch "style" NEW_STYLE) (tblsearch "style" OLD_STYLE))
      (progn
         ;
         ;Set flag true since both styles are defined.
         ;
         (setq EXIST "true")
         ;
         ;Generate selection set SS1 filled with all OLD_STYLE text
         ;
         (setq SS1 (ssget "X" (list (cons 0 "TEXT") (cons 7 OLD_STYLE)))
         I 0)
         ;
         ;Continue only if SS1 not empty
         ; 
         (if SS1
            (progn
               (repeat (sslength SS1) ;Repeat CHANGE command until SS1 empty
                  (setq ENTITI (ssname SS1 I)) ;Here we doing this one at a time
                  (command "change" ENTITI "" "" ""  NEW_STYLE "" "" "" ^C)
                  (setq I (+ 1 I))
               );repeat
            ) ;progn
         )  ;if SS1
         (prompt "DONE!")
      )   ;progn
   )    ;if (and 
   ;
   ;Styles (or one of the styles) do not exist.  Give a message and exit
   ;
   (if (not EXIST)  
   (prompt "\nStyle(s) non_existant. Use 'STYLE' command to generate."))
   (setq *error* OLD_ERR)
   (princ)
); end chstyle.lsp
