; TIP915.LSP: ARAYANG.LSP   Polar Arrays Made Easy   (c)1993, Forbes Dodwell

; Polar array calculates the angle between two objects on the same
; circle and arrays by this angle a specified number of times.
; The direction of array is the direction picked by first angle and
; second angle (either clock-wise or counter clock-wise)


(Defun rtd (y)
   (* 180.0 (/ y pi))
)


(defun C:ARAY (/ DIRANG CENT OBJ NUM); ANG1 ANG2 ROTANG)
   (setq DIRANG (getvar "angdir"))
   (setvar "angdir" 0)
   (setq CENT (getpoint "\nCenter of array:")
      OBJ  (ssget)
   )
   (initget 7)
   (setq NUM    (getint "\nNumber of objects in array:")
      ANG1   (getangle CENT "\nFirst angle point:")
      ANG2   (getangle CENT "\nSecond angle point:")
   )
   (if (= ANG1 0.0)(setq ANG1 (* pi 2)))
   (if (= ANG2 0.0)(setq ANG2 (* pi 2))) 
   (setq ROTANG (* (1- NUM)(rtd(- ANG2 ANG1))))
   (command "array" OBJ "" "P" CENT NUM ROTANG "y")
   (setvar "angdir" DIRANG)
); end arayang.lsp

