/* use all the digits 1 to 9 in a nine digit number where:
    the first digit is divisible by 1,
    the first two digits are divisible by 2,
    ...
    This program finds one solution
    Answer:381654729
          
    by Stephan Galt (1:232/308)
*/

int used[10];           /* 1==used, 0==free                      */
int selection_num=0;    /* the number of digits already selected */
int answer[10];         /* place answers here (in locations 1-9  */
double test_answer;
double helper[10];

#define QUICKCHECK 1000

void build_test_answer(void)
{
      int x;

      test_answer=0;
      for (x = 0; x < selection_num; x++)
      {
            test_answer += helper[selection_num - x] * answer[x + 1];
      }

}


int get_digit(void)
{
      int lx;

      selection_num++;

      for (lx = 1; lx < 10; lx++)
      {
            if (!used[lx]) /* found unused digit */
            {
                  used[lx]=1;
                  answer[selection_num] = lx;

                  /* is answer acceptable? */
                  /* build test_answer */

                  build_test_answer();

                  /* is test_answer evenly divisible by selection_num ? */

                  while (test_answer > 0)
                  {
                        test_answer -=QUICKCHECK * selection_num;
                  }
                  test_answer += QUICKCHECK * selection_num;
                  while (test_answer > 0)
                        test_answer -= selection_num;

                  if (test_answer == 0)
                  {  /* yes */
                        if(selection_num == 9)
                            return(1); /* success to 9th level */
                        else
                        {
                              if(get_digit()==1)
                              {
                                    /*
                                    ** head back to main and display
                                    ** a final answer
                                    */

                                    return(1);
                              }
                        }
                  }    /* end divisible test */

                  /* restore digit to unused */

                  used[lx]=0;
            }       /* end found digit */

      }          /* end loop checking all digits at this level */
      answer[selection_num] = 0; /* just pretty */
      selection_num--;
      return(0);     /* failed to find usuable number at this level */

}
main()
{
      int x=9;

      helper[0]=.1;
      for (x = 1; x < 10; x++)
      {
            used[x] = 0;
            answer[x] = 0;
            helper[x] = 10 * helper[x-1];
      }

      x = 9;
      if (0 == get_digit())
            printf("\a\nNO ANSWER FOUND!!\n\a");
      else
      {
            printf("Number = ");
            while(x--)
            {
                  printf("%d",answer[9-x]);
            }
      }
      exit(0);
}
