/* solve.c -- find solution to simple programming challenge
**
**  public domain by Ray Gardner   5/94
**
** Find a 9-digit number, using all digits 1 thru 9 (once each),
** such that the first n digits are divisible by n, for n <= 9.
*/

#include <stdio.h>
#include <string.h>
#include <setjmp.h>

jmp_buf env;

long RetVal;

void try(long n, int k, char *digits)   /* recursive solver */
{
      int i;

      for (i = 1; i < 10; ++i)            /* look thru remaining digits   */
      {
            if (digits[i] != '*')         /* if not already used          */
            {
                  long nn = n * 10 + i;   /* next candidate               */

                  if (nn % k == 0)        /* passes divisibility test?    */
                  {
                        if (k == 9)       /* if 9 digits, we're done      */
                        {
                              RetVal = nn;
                              longjmp(env, -1);
                        }
                        else              /* else extend partial solution */
                        {
                              digits[i] = '*';        /* flag used digit  */
                              try(nn, k+1, digits);   /* solve            */
                              digits[i] = i + '0';    /* unflag digit     */
                        }
                  }
            }
      }
}

int main(void)
{
      char digits[11];
#ifdef TEST
      int I;

      for (I = 0; I < 1000; ++I)
      {
#endif
            strcpy(digits, "0123456789");
            if (0 == setjmp(env))
                  try(0L, 1, digits);     /* initial state */
#ifdef TEST
      }
#endif
      printf("Number = %lu\n", RetVal);
      return 0;
}
