/*
 * Function to find the "magic" 9 digit number, where every substring
 * of the number (to the left) is divisible by the number of digits in
 * that substring. Non-recursive version.
 *
 * Dave Dunfield - May 20, 1994 - Released to the Public Domain
 */

#include <stdio.h>
#include <string.h>

main()
{
      long num, next;
      char digits[10];
      char lastdig[10];
      int i, n
#ifdef TEST
      , I;

      for (I = 0; I < 1000; ++I)
      {
#else
      ;
#endif
      n = 1;
      num = 0L;
      memset(digits, 0, sizeof(digits));
      memset(lastdig, 0, sizeof(lastdig));

      do
      {
next:
            if(n >= 10)					/* This number qualifies */
            {
#ifdef TEST
			if (999 == I)
#endif
				printf("Number = %ld\n", num);
			break;
            }
            else for(i=lastdig[n]+1; i<10; ++i) /* Test digits 1-9 only  */
            {
                  if(digits[i])                 /* Digit in use          */
                        continue;
                  if(!((next = num*10 + i) % n))/* Divides - proceed     */
                  {
                        digits[i] = (char)-1;   /* Mark digit as used    */
                        num = next;             /* Proceed from here     */
                        lastdig[n++] = i;       /* Save continuation     */
                        goto next;              /* Restart test          */
                  }
            }
            digits[num % 10] = 0;               /* Release digit         */
            num /= 10;                          /* Remove last attempt   */
            lastdig[n] = 0;                     /* Reset lower starts    */
      }
      while(--n);
#ifdef TEST
      }
#endif
      return 0;
}
