/* ObjectWindows
	Test for New mail on network.
	Development Environment:
	BC++ 3.1, DOS 5.0, Novell Netware 3.11,
	Novell Netware Client API 1.0e

	Thomas H. Smith  [70674,3300]
	2/19/94

	Program calls int mailchkw() to get number of unread
	Netware/Pegasus mail messages.  If number is greater
	than 0 and less than 1500, a message saying how much
    	mail is waiting is displayed.


*/

#include <owl.h>
#include <dialog.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <mailchkw.h>	// Accompanies this file in zip package

#include <nwcalls.h>	// Netware include file

const WORD ID_BUTTON = 101;	// for OK button in dialog box 


#define APPNAME "MailChk"

RECT MsgArea;

BOOL ISRUNG = FALSE;

int iMsgCount;

class TMailChkApp : public TApplication
{
public:
  TMailChkApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
	LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow){}
  virtual void InitMainWindow();
  virtual void InitInstance();
  ~TMailChkApp(){};
};


class TMailDialog : public TDialog
{
public:
  HDC DragDC;
  char buffer[80];
  char *sMsgCount;
  char *szMailMsg;

  TMailDialog();
  InitInstance();
  virtual LPSTR GetClassName();
  virtual void GetWindowClass(WNDCLASS&);
  virtual void WMPaint(RTMessage Msg)
  	= [WM_FIRST + WM_PAINT];
  virtual void HandleButtonMsg(RTMessage Msg)
    = [ID_FIRST + ID_BUTTON];

};

TMailDialog::TMailDialog() : TDialog(NULL, APPNAME)
{
}



LPSTR TMailDialog::GetClassName()
{
  return APPNAME;
}

void TMailDialog::GetWindowClass(WNDCLASS& AWndClass)
{
  TDialog::GetWindowClass(AWndClass);
  AWndClass.hIcon = LoadIcon(GetApplication()->hInstance, APPNAME);
}

void TMailDialog::WMPaint(RTMessage)
{

	HDC DC;
	char buffer[35];		// holds text to be printed 
	int nStringLen;
	PAINTSTRUCT dbps;      	// dialog box paint structure
	RECT	dbrect;        	// dialog box rectangle

	char *szMailMsg;

	DWORD dwBackColor;

	szMailMsg=( char *)malloc(35);

	sMsgCount=(char *)malloc(4);

	if(iMsgCount > 0)
    {
		itoa( iMsgCount, sMsgCount, 10);
		strcpy( szMailMsg, "You have ");
		strcat( szMailMsg, sMsgCount);
		strcat( szMailMsg, " new Email Messages\0");
	}
	else
	{
		switch(iMsgCount)
        {
			case(-1):strcpy(szMailMsg, "General Network Failure");
			case(-2):strcpy(szMailMsg, "Could not find Default Connection");
			case(-3):strcpy(szMailMsg, "Could not get Connection Status");
			case(-4):strcpy(szMailMsg, "Could not get connection handle");
			case(-5):strcpy(szMailMsg, "Could not get connection number");
			case(-6):strcpy(szMailMsg, "Could not get connection info");
			case(-7):strcpy(szMailMsg, "Could not cancel drive O: ");
			case(-8):strcpy(szMailMsg, "Could map drive O:");
			case(-9):strcpy(szMailMsg, "Could not change to drive O:");
		 }
    }
	dbps.fErase = 1;
	BeginPaint(HWindow, &dbps);			// Start painting of window
	GetClientRect(HWindow, &dbrect );
	sprintf( buffer, szMailMsg);
	DC = GetDC( HWindow );              // Get Device context

	SetBkMode( DC, TRANSPARENT);        // Make Text background invisible,
										// or desktop background color.

	MoveTo(DC, 0, 0);
	TextOut(DC, 18, 40, buffer, strlen(buffer) );  // Display text
	ReleaseDC(HWindow, DC);
	EndPaint(HWindow, &dbps);			// Release DC and End the painting
										// session
	free(sMsgCount);                    // let go of allocated memory
}


void TMailDialog::HandleButtonMsg(RTMessage)
{
	CloseWindow();		// OK button will close the window and
}                       // this application


void TMailChkApp::InitMainWindow()
{
	  MainWindow = new TMailDialog();
}

void TMailChkApp::InitInstance()
{
	TApplication::InitInstance();
}


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
	iMsgCount = mailchkw();	// Get the number of unread mail messages

	TMailChkApp MailChkApp( APPNAME, hInstance, hPrevInstance,
	lpCmdLine, nCmdShow);

/* -9 thru -1 is left in for possible errors - look at mailchkw.cpp.
   Using an 'if' here may be considered uncouth by some, but it works
   for this application */

	if( (iMsgCount != 0) && (iMsgCount > -9) && (iMsgCount < 1500) )
		MailChkApp.Run();	// Run the application 
	else
		MailChkApp.~TMailChkApp();
	return MailChkApp.Status;
}
