/*

	String object class definition for PCOOPE2

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94

*/

#define CLASS String

#include "pcoope2.h"
#include <string.h>
#include <stdio.h>

object CLASS;

extern object Array;

instVars {unsigned slen;};

INSTANCEPOLY(pGetSz);
INSTANCEPOLY(pSet);
INSTANCEPOLY(pAdd);
INSTANCEPOLY(pPut);
INSTANCEPOLY(pGet);

INCLUDEPOLY(pAcc);
INCLUDEPOLY(pPuts);
INCLUDEPOLY(pGets);

cFunc object New(object instance,const char * source);
iFunc object GetSz(object instance);
iFunc object Set(object instance,const char * newStr);
iFunc object Add(object instance,const char * apdStr);
iFunc object Put(object instance,object stream);
iFunc object Get(object instance,object stream);

ClassInstallFunc
{
pNew(Base,0,sizeof(instVars),&CLASS,Array,NULL);

MAKE_C_POLY(New);

MAKE_I_POLY(GetSz);
MAKE_I_POLY(Set);
MAKE_I_POLY(Add);
MAKE_I_POLY(Put);
MAKE_I_POLY(Get);

EndClassInstall;
}

#define pAcc    I_POLY(pAcc)
#define pGets	I_POLY(pGets)
#define pPuts	I_POLY(pPuts)

cFunc object New(object instance,const char * source)
{
DECLAREivPtr;
BEGIN_NEW;

MakeInstance;
ivPtr->slen=strlen(source);
pNew(Array,ivPtr->slen+1,sizeof(char));
strcpy(pAcc(instance),source);

END_NEW;
}




iFunc object GetSz(object instance)
{
GETIVPTR;

return (object) ((cast) ivPtr->slen);
}


iFunc object Set(object instance,const char * newStr)
{
object newAry;
object newStrm;
GETIVPTR;

ivPtr->slen=strlen(newStr);

newAry=pNew(Array,ivPtr->slen+1,sizeof(char));
strcpy(pAcc(instance),pAcc(newAry));
makePart(instance,newAry);
return instance;
}


iFunc object Add(object instance, const char * apdStr)
{
object newAry;
unsigned newLen;
char * newStr;
GETIVPTR;

newLen=ivPtr->slen+strlen(apdStr);
newAry=pNew(Array,newLen+1,sizeof(char));
newStr=pAcc(newAry);
strcpy(newStr,pAcc(instance));
strcpy(newStr+ivPtr->slen,apdStr);
ivPtr->slen=newLen;
makePart(instance,newAry);
return instance;
}


iFunc object Put(object instance, object stream)
{
if((cast) EOF==((cast) pPuts(stream,pAcc(instance)))) return NULL;
return Base;
}


iFunc object Get(object instance, object stream)
{
GETIVPTR;

if(NULL==pGets(stream,pAcc(instance),ivPtr->slen+1)) return NULL;
return Base;
}





