/*

	Dyn object class definition for PCOOPE2

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94


*/

#define CLASS Dyn

#include "pcoope2.h"
#include <mem.h>

object CLASS;

instVars {unsigned sz;char b[1];};

INSTANCEPOLY(pAcc);
INSTANCEPOLY(pReSz);
INSTANCEPOLY(pGetSz);

cFunc object New(object instance,dSizeT size);
iFunc object Acc(object instance);
iFunc object GetSz(object instance);
iFunc object ReSz(object instance,dSizeT newSize);


ClassInstallFunc
{
pNew(Base,0,sizeof(instVars),&CLASS,NULL);

MAKE_C_POLY(New);
MAKE_I_POLY(Acc);
MAKE_I_POLY(ReSz);
MAKE_I_POLY(GetSz);

EndClassInstall;
}


cFunc object New(object instance,dSizeT size)
{
DECLAREivPtr;
BEGIN_NEW;

SETIVSIZE(size+sizeof(instVars));
ivPtr=makeInst(CLASS,&instance);
ivPtr->sz=size;

END_NEW;
}


iFunc object Acc(object instance)
{
GETIVPTR;
return ivPtr->b;
}


iFunc object GetSz(object instance)
{
GETIVPTR;
return (object) ((cast) ivPtr->sz);
}


iFunc object ReSz(object instance,dSizeT newSize)
{
object 		newDyn;
instVars * 	newIVPtr;
unsigned 	numCpy;
GETIVPTR;

FindivPtr(CLASS,newDyn=pNew(Dyn,newSize),newIVPtr);
numCpy=(newIVPtr->sz>ivPtr->sz)?ivPtr->sz:newIVPtr->sz;
memcpy(newIVPtr->b,ivPtr->b,numCpy);
return makePart(instance,newDyn);
}





