/*
    pcmouse.h - PC Mouse Class - Freeware for Borland C++
    Copyright 1994, John W. Small, All Rights Reserved
    voice: (703) 759-3838,  email: john.small@wdn.com

    Works consulted:

    "Microsoft Mouse Programmer's Reference. 2nd Edition"
        Bellevue, Washington: Microsoft Press, 1991.

    "Microsoft Mouse Programmer's Reference."
        Bellevue, Washington: Microsoft Press, 1989.

    "Microsoft Mouse Programmer's Reference Guide."
        Bellevue, Washington: Microsoft Press, 1986.

    Refer to above works for mouse function documentation.
*/

#include <dos.h>    /* union REGS, struct SREGS, */
                    /*  int86(), int86x(), */
                    /* geninterrupt(), enable(), */
                    /* MK_FP() */
#include "pcmouse.h"


MicrosoftMouse MM;  // Only instance allowed!

/*  Screen Modes Used:
    0x00 - 0x0A, 0x0D - 0x13, 0x20 - 0x26, 0x30,
    0x40 - 0x45, 0x60 - 0x62, 0x6E - 0x6F,
    0x70 - 0x72, 0x74, 0x78 - 0x7B, 0x7E
Note: graphics mode 0x40 maps to 0x3F
    text modes 0x60 - 0x61 map to 0x5E - 0x5F
    See vmodeUpdate().
*/

unsigned char MicrosoftMouse::Xcell[] = {
    16,16, 8, 8, 2, 2, 1, 8,    // 0x00 - 0x07
     4, 1, 1, 1, 1, 2, 1, 1,    // 0x08 - 0x0F
     1, 1, 1, 2, 1, 1, 1, 1,    // 0x10 - 0x17
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x18 - 0x1F
     4, 1, 1, 1, 1, 1, 8, 1,    // 0x20 - 0x27
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x28 - 0x2F
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x30 - 0x37
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x38 - 0x3F
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x40 - 0x47
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x48 - 0x4F
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x50 - 0x57
     1, 1, 1, 1, 1, 1, 8, 8,    // 0x58 - 0x5F
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x60 - 0x67
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x68 - 0x6F
     1, 1, 1, 1, 4, 1, 1, 1,    // 0x70 - 0x77
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x78 - 0x7F
};
unsigned char MicrosoftMouse::Ycell[] = {
     8, 8, 8, 8, 1, 1, 1, 8,    // 0x00 - 0x07
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x08 - 0x0F
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x10 - 0x17
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x18 - 0x1F
     1, 1, 1, 1, 1, 1, 8, 1,    // 0x20 - 0x27
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x28 - 0x2F
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x30 - 0x37
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x38 - 0x3F
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x40 - 0x47
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x48 - 0x4F
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x50 - 0x57
     1, 1, 1, 1, 1, 1, 8, 8,    // 0x58 - 0x5F
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x60 - 0x67
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x68 - 0x6F
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x70 - 0x77
     1, 1, 1, 1, 1, 1, 1, 1,    // 0x78 - 0x7F
};
unsigned char MicrosoftMouse::LeftTopOfs[] = {
     1, 1, 1, 1, 0, 0, 0, 1,    // 0x00 - 0x07
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x08 - 0x0F
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x10 - 0x17
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x18 - 0x1F
     1, 0, 0, 0, 0, 0, 1, 0,    // 0x20 - 0x27
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x28 - 0x2F
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x30 - 0x37
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x38 - 0x3F
     1, 1, 1, 1, 1, 0, 0, 0,    // 0x40 - 0x47
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x48 - 0x4F
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x50 - 0x57
     0, 0, 0, 0, 0, 0, 1, 1,    // 0x58 - 0x5F
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x60 - 0x67
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x68 - 0x6F
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x70 - 0x77
     0, 0, 0, 0, 0, 0, 0, 0,    // 0x78 - 0x7F
};


unsigned MicrosoftMouse::masks_arrow[]  =  {

    // screen mask

    0x9fff,    //  1001111111111111
    0x8fff,    //  1000111111111111
    0x87ff,    //  1000011111111111
    0x83ff,    //  1000001111111111
    0x81ff,    //  1000000111111111
    0x80ff,    //  1000000011111111
    0x807f,    //  1000000001111111
    0x803f,    //  1000000000111111
    0x801f,    //  1000000000011111
    0x800f,    //  1000000000001111
    0x80ff,    //  1000000011111111
    0x887f,    //  1000100001111111
    0x987f,    //  1001100001111111
    0xfc3f,    //  1111110000111111
    0xfc3f,    //  1111110000111111
    0xfe3f,    //  1111111000111111

    // cursor mask

    0x0000,    //  0000000000000000
    0x2000,    //  0010000000000000
    0x3000,    //  0011000000000000
    0x3800,    //  0011100000000000
    0x3c00,    //  0011110000000000
    0x3e00,    //  0011111000000000
    0x3f00,    //  0011111100000000
    0x3f80,    //  0011111110000000
    0x3fc0,    //  0011111111000000
    0x3e00,    //  0011111000000000
    0x3600,    //  0011011000000000
    0x2300,    //  0010001100000000
    0x0300,    //  0000001100000000
    0x0180,    //  0000000110000000
    0x0180,    //  0000000110000000
    0x0000,    //  0000000000000000

};

signed char MicrosoftMouse::arrow_horzHS =  0;
signed char MicrosoftMouse::arrow_vertHS = -1;


unsigned MicrosoftMouse::masks_hand[]  =  {

    // screen mask

    0xe1ff,    //  1110000111111111
    0xe1ff,    //  1110000111111111
    0xe1ff,    //  1110000111111111
    0xe1ff,    //  1110000111111111
    0xe1ff,    //  1110000111111111
    0xe000,    //  1110000000000000
    0xe000,    //  1110000000000000
    0xe000,    //  1110000000000000
    0x0000,    //  0000000000000000
    0x0000,    //  0000000000000000
    0x0000,    //  0000000000000000
    0x0000,    //  0000000000000000
    0x0000,    //  0000000000000000
    0x0000,    //  0000000000000000
    0x0000,    //  0000000000000000
    0x0000,    //  0000000000000000

    //  cursor mask

    0x1e00,    //  0001111000000000
    0x1200,    //  0001001000000000
    0x1200,    //  0001001000000000
    0x1200,    //  0001001000000000
    0x1200,    //  0001001000000000
    0x13ff,    //  0001001111111111
    0x1249,    //  0001001001001001
    0x1249,    //  0001001001001001
    0xf249,    //  1111001001001001
    0x9001,    //  1001000000000001
    0x9001,    //  1001000000000001
    0x9001,    //  1001000000000001
    0x8001,    //  1000000000000001
    0x8001,    //  1000000000000001
    0x8001,    //  1000000000000001
    0xffff,    //  1111111111111111

};

signed char MicrosoftMouse::hand_horzHS = 5;
signed char MicrosoftMouse::hand_vertHS = 0;

void MicrosoftMouse::vmodeUpdate()
{
    _AX = 0x0F00;
    geninterrupt(0x10);
    vmode = (_AL & 0x007F);
/*
    Note: graphics vmode 0x40 must remap to 0x3F and
    text modes 0x60 - 0x61 must remap to 0x5E - 0x5F.
    Rewrite this function as necessary to support
    your target boards.

    Without rewrite, Video7 boards are favored to
    Olivetti and Sprite!
*/
}

void MicrosoftMouse::open()
{
    unsigned char far *vec;

    vmode = 0;
    present = 0;
    buttons = 0;
    leftPressed = 0; rightPressed = 0;
    x = 0; y = 0;
    lastLeftPressX = 0; lastLeftPressY = 0;
    leftPresses = 0;
    buttonRequested = MBleft;
    lastLeftReleaseX = 0; lastLeftReleaseY = 0;
    leftReleases = 0;
    lastRightPressX = 0; lastRightPressY = 0;
    rightPresses = 0;
    lastRightReleaseX = 0; lastRightReleaseY = 0;
    rightReleases = 0;
    vertMickeys= 0; horzMickeys = 0;
    handler = (MouseHandler) 0;
    callMask = 0;
    eventMask = 0x001F;
    eventFlags = 0;
    eventCount = 0;
    eventMoved = 0;
    eventTime = 0;
    clickTimeOut = 10;
    leftClickTime = 0;
    leftClicks = 0;
    rightClickTime = 0;
    rightClicks = 0;
    origState = (void *) 0;
    state = (void *) 0;
    stateSize = 0;
    altHandler = (MouseHandler) 0;
    altCallMask = 0;
    horzPercent = 50; vertPercent = 50;
    doublePercent = 50;
    crtPage = 0;
    mouseIntrVector = (MouseDriver) 0;
    language = MLenglish;
    driverVersionMajor = driverVersionMinor = 0;
    IRQ = -1;
    typeRequired = MTunknown;
    driverType = MDunknown;
    MDDs = 0;
    cursorType = MCunknown;
    intrRate = MIunknown;
    disabled = 0;
    maxX = maxY = maxVX = maxVY = 0;
    accumVertMickeys = accumHorzMickeys = 0;
    scrMask = curMask = 0;
    vmodeString = (char * far) 0;
    horzHS = vertHS = (signed char) 0;
    hidden = 0;
    vec = (unsigned char far *) getvect(MOUSE_INT);
    if (!vec || (*vec == 0xCF)) /* IRET */
        return;
    reset();
    getDriverVer();
    if (!present)
        return;
    getDriverInfo();
    save();
    origState = state;
    state = (void *) 0;
}

void MicrosoftMouse::close()
{
    on();
    restore();
    clearAltInterrupts();
    reset();
    state = origState;
    restore();
}



void MicrosoftMouse::reset()                     /* MF0 */
{
    vmodeUpdate();
    _AX = 0;
    geninterrupt(MOUSE_INT);
    if (_AX) {
        buttons = _BX;
        present = 1;
    }
    else
        buttons = present = 0;
    hidden = -1;
}

void MicrosoftMouse::updateStatusInfo()          /* MF3 */
{
    unsigned buttons;

    _AX = 3;
    geninterrupt(MOUSE_INT);
    buttons = _BX;
    x = _CX;
    y = _DX;
    leftPressed = (buttons & MBleft)? 1 : 0;
    rightPressed = (buttons & MBright)? 1 : 0;
    x = physicalX(x);
    y = physicalY(y);
}

void MicrosoftMouse::gotoxy()                    /* MF4 */
{
    unsigned vx, vy;

    vx = virtualX(x);
    vy = virtualY(y);
    _CX = vx;
    _DX = vy;
    _AX = 4;
    geninterrupt(MOUSE_INT);
}

void MicrosoftMouse::updatePressInfo()           /* MF5 */
{
    union REGS rgs;

    rgs.x.ax = 5;
    rgs.x.bx = buttonRequested >> 1;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    leftPressed = (rgs.x.ax & MBleft)? 1 : 0;
    rightPressed = (rgs.x.ax & MBright)? 1 : 0;
    if (buttonRequested == MBleft)  {
        leftPresses = rgs.x.bx;
        lastLeftPressX = physicalX(rgs.x.cx);
        lastLeftPressY = physicalY(rgs.x.dx);
    }
    else {
        rightPresses = rgs.x.bx;
        lastRightPressX = physicalX(rgs.x.cx);
        lastRightPressY = physicalY(rgs.x.dx);
    }
}

void MicrosoftMouse::updateReleaseInfo()         /* MF6 */
{
    union REGS rgs;

    rgs.x.ax = 6;
    rgs.x.bx = buttonRequested >> 1;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    leftPressed = (rgs.x.ax & MBleft)? 1 : 0;
    rightPressed = (rgs.x.ax & MBright)? 1 : 0;
    if (buttonRequested == MBleft)  {
        leftReleases = rgs.x.bx;
        lastLeftReleaseX = physicalX(rgs.x.cx);
        lastLeftReleaseY = physicalY(rgs.x.dx);
    }
    else {
        rightReleases = rgs.x.bx;
        lastRightReleaseX = physicalX(rgs.x.cx);
        lastRightReleaseY = physicalY(rgs.x.dx);
    }
}

void MicrosoftMouse::trap()                  /* MF7, MF8 */
{
    unsigned d1, d2;

    d1 = virtualX(x1);
    d2 = virtualX(x2);
    _CX = d1;
    _DX = d2;
    _AX = 7;
    geninterrupt(MOUSE_INT);
    d1 = virtualY(y1);
    d2 = virtualY(y2);
    _CX = d1;
    _DX = d2;
    _AX = 8;
    geninterrupt(MOUSE_INT);
}

void MicrosoftMouse::graphicsCursor(
    signed char horzHS,
    signed char vertHS,
    unsigned far *scrCurMask)                    /* MF9 */
{
    unsigned h, v;

    if (!scrCurMask)
        return;
    h = ((unsigned) horzHS) * Xcell[vmode];
    v = ((unsigned) vertHS) * Ycell[vmode];
    _ES = FP_SEG(scrCurMask);
    _DX = FP_OFF(scrCurMask);
    _BX = h;
    _CX = v;
    _AX = 9;
    geninterrupt(MOUSE_INT);
    cursorType = MCgraphics;
    this->horzHS = horzHS;
    this->vertHS = vertHS;
}

void MicrosoftMouse::textCursor                  /* MF10 */
    (unsigned scrMask, unsigned curMask,
    unsigned type)
{
    _BX = type;
    _CX = scrMask;
    _DX = curMask;
    _AX = 10;
    geninterrupt(MOUSE_INT);
    cursorType = type;
    this->scrMask = scrMask;
    this->curMask = curMask;
}

void MicrosoftMouse::condOff()                   /* MF16 */
{
    unsigned covx1, covy1, covx2, covy2;

    covx1 = virtualX(cox1);
    covy1 = virtualY(coy1);
    covx2 = virtualX(cox2);
    covy2 = virtualY(coy2);
    _DI = covy2;
    _SI = covx2;
    _DX = covy1;
    _CX = covx1;
    _AX = 16;
    geninterrupt(MOUSE_INT);
}


void MicrosoftMouse::swapInterrupts()            /* MF20 */
{
    union REGS rgs;
    struct SREGS srgs;

    rgs.x.ax = 20;
    rgs.x.cx = callMask;
    rgs.x.dx = FP_OFF(handler);
    srgs.es = FP_SEG(handler);
    (void) int86x(MOUSE_INT,&rgs,&rgs,&srgs);
    callMask = rgs.x.cx;
    handler = (MouseHandler) MK_FP(srgs.es,rgs.x.dx);
}

/* Stack overflow check overwrites AX : do not compile with -N */
/* Do not call!  Use to cookbook your own if needed. */
#pragma argsused
void interrupt MMautoEventHandler(
    unsigned iBP,
    unsigned vertMickeys,    /* di */
    unsigned horzMickeys,    /* si */
    unsigned iDS,
    unsigned iES,
    unsigned y,              /* dx */
    unsigned x,              /* cx */
    unsigned buttonState,    /* bx */
    unsigned conditionMask,  /* ax */
    unsigned iIP,
    unsigned iCS,
    unsigned pseudoFlags)     /* not present */
{
    MM.eventTime = (*(long far *)MK_FP(0x0040,0x006C));
    enable();

    MM.eventCount++;
    MM.eventFlags = conditionMask;
    MM.leftPressed = (buttonState & MBleft)? 1 : 0;
    MM.rightPressed = (buttonState & MBright)? 1 : 0;

    MM.x = MM.physicalX(x);
    MM.y = MM.physicalY(y);
    MM.horzMickeys = horzMickeys;
    MM.vertMickeys = vertMickeys;

    if (conditionMask & MEmoved)
        MM.eventMoved++;

    if (conditionMask & MEleftPressed)  {
        MM.leftPressed = 1;
        MM.lastLeftPressX = MM.x;
        MM.lastLeftPressY = MM.y;
        MM.leftPresses++;
        MM.buttonRequested = MBleft;
        if ((MM.leftClickTime > MM.eventTime) ||
            ((MM.eventTime - MM.leftClickTime)
            > MM.clickTimeOut))  {
            MM.leftClickTime = MM.eventTime;
            MM.leftClicks = 0;
        }
    }
    if (conditionMask & MEleftReleased)  {
        MM.leftPressed = 0;
        MM.lastLeftReleaseX = MM.x;
        MM.lastLeftReleaseY = MM.y;
        MM.leftReleases++;
        MM.buttonRequested = MBleft;
        if ((MM.leftClickTime > MM.eventTime) ||
            ((MM.eventTime - MM.leftClickTime)
            > MM.clickTimeOut))  {
            MM.leftClickTime = MM.eventTime;
            MM.leftClicks = 0;
        }
        else
            MM.leftClicks++;
    }
    if (conditionMask & MErightPressed)  {
        MM.rightPressed = 1;
        MM.lastRightPressX = MM.x;
        MM.lastRightPressY = MM.y;
        MM.rightPresses++;
        MM.buttonRequested = MBright;
        if ((MM.rightClickTime > MM.eventTime) ||
            ((MM.eventTime - MM.rightClickTime)
            > MM.clickTimeOut))  {
            MM.rightClickTime = MM.eventTime;
            MM.rightClicks = 0;
        }
    }
    if (conditionMask & MErightReleased)  {
        MM.rightPressed = 0;
        MM.lastRightReleaseX = MM.x;
        MM.lastRightReleaseY = MM.y;
        MM.rightReleases++;
        MM.buttonRequested = MBright;
        if ((MM.rightClickTime > MM.eventTime) ||
            ((MM.eventTime - MM.rightClickTime)
            > MM.clickTimeOut))  {
            MM.rightClickTime = MM.eventTime;
            MM.rightClicks = 0;
        }
        else
            MM.rightClicks++;
    }

/*
    Convert from Interrupt stack frame to FAR call stack
    frame then return from FAR.  Since the mouse driver
    FAR calls this interrupt handler instead of issuing
    an interrupt call to get here, this event handler
    needs to return from a FAR call instead of returning
    from an interrupt!  A Turbo C++ interrupt function
    was used since it automatically restores DS to the
    data segment.  The mouse driver also passes
    parameters in registers instead of on the
    stack.  TC++'s interrupt keyword forces the function
    to automatically stack these registers so that they
    can be accessed.
*/

    asm mov ax,iDS       /* restore DS */
    asm mov ds,ax

    conditionMask = iBP; /* skip over parameters */
    asm add bp,16        /* OFFSET conditionMask */

    asm mov sp,bp        /* exit far proc */
    asm pop bp
    asm retf
}

void MicrosoftMouse::autoEventUpdate()           /* N/A  */
{
    handler = (MouseHandler) MMautoEventHandler;
    callMask = eventMask;
    swapInterrupts();
}

void MicrosoftMouse::save()               /* MF21, MF22 */
{
    union REGS rgs;
    struct SREGS srgs;

    if (state) return;
    _AX = 21;
    geninterrupt(MOUSE_INT);
    stateSize = _BX;
    if ((state = (void *) new char [stateSize])
        == (void *) 0) return;
    srgs.es = FP_SEG((void far *)state);
    rgs.x.dx = FP_OFF((void far *)state);
    rgs.x.ax = 22;
    (void) int86x(MOUSE_INT,&rgs,&rgs,&srgs);
}

void MicrosoftMouse::restore()                   /* MF23 */
{
    union REGS rgs;
    struct SREGS srgs;

    if(!state) return;
    srgs.es = FP_SEG((void far *)state);
    rgs.x.dx = FP_OFF((void far *)state);
    rgs.x.ax = 23;
    (void) int86x(MOUSE_INT,&rgs,&rgs,&srgs);
    delete state;
    state = (void *) 0;
}

void MicrosoftMouse::clearAltInterrupts()        /* N/A  */
{
    altHandler = (MouseHandler) 0;
    altCallMask = MEshiftPressed
        | MEctrlPressed | MEaltPressed;
    setAltInterrupt();
    altCallMask = MEshiftPressed | MEctrlPressed;
    setAltInterrupt();
    altCallMask = MEshiftPressed | MEaltPressed;
    setAltInterrupt();
    altCallMask = MEctrlPressed | MEaltPressed;
    setAltInterrupt();
    altCallMask = MEshiftPressed;
    setAltInterrupt();
    altCallMask = MEctrlPressed;
    setAltInterrupt();
    altCallMask = MEaltPressed;
    setAltInterrupt();
}

void MicrosoftMouse::setInterruptRate
    (unsigned rate)                              /* MF28 */
{
    if (typeRequired != MTinPort || rate > MI200)
        return;
    intrRate = rate;
    _BX = rate;
    _AX = 28;
    geninterrupt(MOUSE_INT);
}

void MicrosoftMouse::off()                       /* MF31 */
{
    union REGS rgs;
    struct SREGS srgs;

    if (mouseIntrVector) return;
    rgs.x.ax = 31;
    (void) int86x(MOUSE_INT,&rgs,&rgs,&srgs);
    if (rgs.x.ax == 0xFFFF) return;
    mouseIntrVector = getvect(MOUSE_INT);
    setvect(MOUSE_INT, (MouseDriver)
        MK_FP(srgs.es,rgs.x.bx));
    disabled = 1;
}

void MicrosoftMouse::on()                        /* MF32 */
{
    if (!mouseIntrVector) return;
    setvect(MOUSE_INT, mouseIntrVector);
    mouseIntrVector = (MouseDriver) 0;
    _AX = 32;
    geninterrupt(MOUSE_INT);
    disabled = 0;
}

void MicrosoftMouse::softReset()                 /* MF33 */
{
    vmodeUpdate();
    _AX = 33;
    geninterrupt(MOUSE_INT);
    present = ((_AX == 0xFFFF) && (_BX == 2))? 1 : 0;
    hidden = -1;
}

void MicrosoftMouse::getDriverVer()              /* MF36 */
{
    union REGS rgs;

    rgs.x.ax = 36;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    driverVersionMajor = (rgs.x.bx >> 8);
    driverVersionMinor = (rgs.x.bx & 0x00FF);
    IRQ = rgs.h.cl;
    typeRequired = rgs.h.ch;
}

int MicrosoftMouse::getDriverInfo()              /* MF37 */
{
    union REGS rgs;

    if (driverVersionMajor < 6) return 0;
    if (driverVersionMinor < 26) return 0;
    rgs.x.ax = 37;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    driverType = ((rgs.x.ax & 0x8000)?
        MDsys : MDcom);
    MDDs = ((rgs.x.ax & 0x4000)?
        (rgs.x.ax & 0x00FF)
        : 0);
    if (rgs.x.ax & 0x2000)
        cursorType = MCgraphics;
    else if (rgs.x.ax & 0x1000)
        cursorType = MChardText;
    else
        cursorType = MCsoftText;
    intrRate = ((rgs.x.ax >> 8) & 0x000F);
    return 1;
}

int MicrosoftMouse::getMaxCoor()                 /* MF38 */
{
    union REGS rgs;

    if (driverVersionMajor < 6) return 0;
    if (driverVersionMinor < 26) return 0;
    rgs.x.ax = 38;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    disabled = rgs.x.bx;
    maxX = physicalX(maxVX = rgs.x.cx);
    maxY = physicalY(maxVY = rgs.x.dx);
    return 1;
}

int MicrosoftMouse::getMaskKey()                 /* MF39 */
{
    union REGS rgs;

    if (driverVersionMajor < 7) return 0;
    if (driverVersionMinor < 1) return 0;
    rgs.x.ax = 39;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    accumVertMickeys = rgs.x.dx;
    accumHorzMickeys = rgs.x.cx;
    if (cursorType == MCgraphics ||
        driverVersionMinor < 2)
        return 1;
    scrMask = rgs.x.ax;
    curMask = rgs.x.bx;
    return 1;
}

int MicrosoftMouse::setVmode(unsigned vmode,
    unsigned fontSize)            /* MF40 */
{
    union REGS rgs;

    if (driverVersionMajor < 7) return 0;
    if (!vmode) return 0;
    rgs.x.ax = 40;
    rgs.x.cx = vmode;
    rgs.x.dx = fontSize;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    if (!rgs.x.cx)
        this->vmode = vmode;
    return 1;
}

unsigned MicrosoftMouse::getVmode
    (unsigned nextFirst)                         /* MF41 */
{
    union REGS rgs;

    if (driverVersionMajor < 7) return 0;
    rgs.x.ax = 41;
    rgs.x.cx = nextFirst;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    vmodeString = (char * far)
        MK_FP(rgs.x.bx,rgs.x.dx);
    return rgs.x.cx;
}

int MicrosoftMouse::getCursor()                  /* MF42 */
{
    union REGS rgs;

    if (driverVersionMajor < 7) return 0;
    if (driverVersionMinor < 2) return 0;
    rgs.x.ax = 42;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    horzHS = (signed char) rgs.x.bx;
    vertHS = (signed char) rgs.x.cx;
    typeRequired = rgs.x.dx;
    hidden = (int) rgs.x.ax;
    return 1;
}

int MicrosoftMouse::loadAC
    (MouseAccelerationCurves far * MAC,
    int curve)                /* MF43 */
{
    union REGS rgs;
    struct SREGS srgs;

    if (driverVersionMajor < 7) return 0;
    if (!curve || curve < -1 || curve > 4)
        return 0;
    rgs.x.ax = 43;
    rgs.x.bx = curve;
    rgs.x.si = FP_OFF(MAC);
    srgs.es = FP_SEG(MAC);
    return !int86x(MOUSE_INT,&rgs,&rgs,&srgs);
}

int MicrosoftMouse::readAC
    (MouseAccelerationCurves far ** MAC)         /* MF44 */

{
    union REGS rgs;
    struct SREGS srgs;

    if (driverVersionMajor < 7) return 0;
    if (!MAC) return 0;
    rgs.x.ax = 44;
    if (int86x(MOUSE_INT,&rgs,&rgs,&srgs))
        return 0;
    *MAC = (MouseAccelerationCurves far *)
        MK_FP(srgs.es,rgs.x.si);
    return rgs.x.bx;
}

int MicrosoftMouse::setGetAAC(int curve,
    char far ** curveName)                       /* MF45 */
{
    union REGS rgs;
    struct SREGS srgs;

    if (driverVersionMajor < 7) return 0;
    if (!curve || curve < -1 || curve > 4)
        return 0;
    rgs.x.ax = 45;
    rgs.x.bx = curve;
    if (int86x(MOUSE_INT,&rgs,&rgs,&srgs))
        return 0;
    if (curveName)
        *curveName = (char far *)
        MK_FP(srgs.es,rgs.x.si);
    return rgs.x.bx;
}

int MicrosoftMouse::hardReset()                  /* MF47 */
{
    if (driverVersionMajor < 7) return 0;
    if (driverVersionMinor < 2) return 0;
    _AX = 47;
    geninterrupt(MOUSE_INT);
    return _AX;
}

int MicrosoftMouse::setBallPoint()               /* MF48 */
{
    union REGS rgs;

    if (driverVersionMajor < 7) return 0;
    if (driverVersionMinor < 4) return 0;
    rgs.x.ax = 48;
    rgs.x.bx = ballPointRotationAngle;
    rgs.x.cx = ballPointButtonMasks;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    return ((((int)rgs.x.ax) == -1)? 0 : 1);
}

int MicrosoftMouse::getBallPoint()               /* MF48 */
{
    union REGS rgs;

    if (driverVersionMajor < 7) return 0;
    if (driverVersionMinor < 4) return 0;
    rgs.x.ax = 48;
    rgs.x.bx = ballPointRotationAngle;
    rgs.x.cx = 0;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    if (((int)rgs.x.ax) == -1)
        return 0;
    ballPointButtonState = rgs.x.ax;
    ballPointRotationAngle = rgs.x.bx;
    ballPointButtonMasks = rgs.x.cx;
    return 1;
}


int MicrosoftMouse::getTrap()                    /* MF49 */
{
    union REGS rgs;

    if (driverVersionMajor < 7) return 0;
    if (driverVersionMinor < 5) return 0;
    rgs.x.ax = 49;
    (void) int86(MOUSE_INT,&rgs,&rgs);
    x1 = physicalX(rgs.x.ax);
    y1 = physicalY(rgs.x.bx);
    x2 = physicalX(rgs.x.cx);
    y2 = physicalY(rgs.x.dx);
    return 1;
}

unsigned MicrosoftMouse::getActAdvFncs()         /* MF50 */
{
    if (driverVersionMajor < 7) return 0;
    if (driverVersionMinor < 5) return 0;
    _AX = 50;
    geninterrupt(MOUSE_INT);
    return _AX;
}

int MicrosoftMouse::getSwitches
    (MouseSwitches far * MS)                     /* MF51 */
{
    union REGS rgs;
    struct SREGS srgs;

    if (driverVersionMajor < 7) return 0;
    if (driverVersionMinor < 5) return 0;
    if (!MS) return 0;
    rgs.x.ax = 51;
    rgs.x.cx = sizeof(MouseSwitches);
    rgs.x.dx = FP_OFF(MS);
    srgs.es = FP_SEG(MS);
    (void) int86x(MOUSE_INT,&rgs,&rgs,&srgs);
    return 1;
}

char far * MicrosoftMouse::getMouse_ini()        /* MF52 */
{
    union REGS rgs;
    struct SREGS srgs;

    if (driverVersionMajor < 8)
        return (char far *) 0;
    rgs.x.ax = 52;
    (void) int86x(MOUSE_INT,&rgs,&rgs,&srgs);
    return (char far *) MK_FP(srgs.es,rgs.x.dx);
}

