; File MSSDEF.H
;; MASM v6, use MASM 5.1 constructions (/Zm)	OPTION	M510
	.xlist			; suppress listing in program
	.sall			; don't list macro expansions
version equ	313		; master version number
verdef	macro
	db	' MS-DOS Kermit: 3.13 8 July 1993'
	endm

BELL	EQU	07H
TAB 	EQU	09H
LF  	EQU	0AH
FF  	EQU	0CH
CR  	EQU	0DH
XON 	EQU	11H
XOFF	EQU	13H
ESCAPE 	EQU	1BH
DEL 	EQU	7FH
BS  	EQU	08H
CTLZ	EQU	1AH
SOH 	EQU	01H     ; Start of header char
SPC 	EQU	20H
SS2	equ	8eh
SS3	equ	8fh
DCS	equ	90h
CSI	equ	9bh
STCHR	equ	9ch

DOS 	EQU	21H

CONIN	EQU	01H
CONOUT	EQU	02H
LSTOUT	EQU	05H
DCONIO	EQU	06H
CONINQ	EQU	07H	; quiet console input
PRSTR	EQU	09H
CONSTAT	EQU	0BH
SELDSK	EQU	0EH	; Select disk
GCURDSK	EQU	19H	; Current disk
SETDMA	EQU	1AH
SETINTV	EQU	25H	; Set interrupt vector from ds:dx
GETDATE EQU	2AH	; Get date
GETTIM	EQU	2CH	; Get the time of day 
DOSVER	EQU	30H	; dos version #
GETINTV	EQU	35H	; get interrupt vector to es:bx
GSWITCH	EQU	37H	; undocumented get/set switch character
CHDIR	EQU	3BH	; change directory
CREAT2	EQU	3CH	; create
OPEN2	EQU	3DH	; open
CLOSE2	EQU	3EH	; close
READF2	EQU	3FH	; read
WRITE2	EQU	40H	; write
DEL2	EQU	41H	; delete
LSEEK	EQU	42H	; lseek
IOCTL	EQU	44H	; i/o control
GCD	EQU	47H	; get current directory
ALLOC	EQU	48H	; allocate memory
FREEMEM	EQU	49H	; free memory
SETBLK	EQU	4AH	; modify allocated memory map
EXEC	EQU	4BH	; execute task
FIRST2	EQU	4EH	; search for first
NEXT2	EQU	4FH	; search for next

PAREVN	EQU	00	; Even parity
PARMRK	EQU	01	; Mark parity
PARNON	EQU	02	; No parity.	
PARODD	EQU	03	; Odd parity
PARSPC	EQU	04	; Space parity

FLOXON	EQU	1113H	; Use XON/XOFF for flow control
FLONON	EQU	0	; Don't do flow control
DEFHAND	EQU	XON	; Use XON as default handshake

MODCD	EQU	80H	; MODEM CD handshake line status responses
MODCTS	EQU	10H	; MODEM CTS
MODDSR	EQU	20H	; MODEM DSR
MODRI	EQU	40H	; MODEM RI

			; flags.remflg byte definitions
DQUIET	EQU	1	; Display mode, suppress file xfer statistics
DREGULAR EQU	2	; Regular formatted screen display of statistics
DSERIAL	EQU	4	; Serial mode (non-formatted screen)
D8BIT	EQU	8	; Display chars as 8-bit vs 7-bit quantities
DSERVER	EQU	10H	; Server mode active, if this bit is set

MAXTAK	EQU	25	; Max number of TAKE's allowed
DEFMXTRY EQU	5	; default number of retries on a data packet (63 max)
			; Init packet gets three times this number of tries

DEFESC	EQU	1DH	; The default escape character (Control rt sq bracket)
DRPSIZ	EQU	94	; Default receive packet size, regular pkts
DSPSIZ	EQU	94	; Default send packet size, regular pkts
DSTIME	EQU	8	; Default send time out interval
DSQUOT	EQU	23H	; Default send (and receive) quote char
DQBIN	EQU	26H	; Default 8-bit prefix
DCHKLEN	EQU	1	; Default checksum length
DEFPAR	EQU	PARNON	; Default parity (none) 

bufsiz	equ	512	; size of serial port input buffer
buffsz	equ	512	; size of disk file i/o buffer (buff)
cmdblen	equ	1000	; length of command lines (sharing buffers)
cptsiz	equ	256	; size of session capture buffer
tbufsiz	equ	128	; size of Take buffers
maxwind equ	31	; max number of window slots
macmax	equ	100	; max number of macros

			; bit defs for flags.capflg (LOG command)
logoff	equ	0	; Off = no or suspended logging
logdeb	equ	1	; log debugging (not yet imp)
logpkt	equ	2	; log packets sent/received
logses	equ	4	; log connect mode session
logtrn	equ	8	; log (file) transaction

			; Attributes-allowed bits in flags.attflg 
attchr	equ	1	; File Character-set
attdate	equ	2	; File Date/Time
attlen	equ	4	; File Length
atttype	equ	8	; File Type

xfr_xparent	equ	0	; transfer character set indices
xfr_latin1	equ	1	;  ref table charids in mssfil.asm
xfr_latin2	equ	2
xfr_hebiso	equ	3
xfr_cyrillic	equ	4
xfr_japanese	equ	5

lock_disable	equ	0	; transfer locking shift capability
lock_enable	equ	1
lock_force	equ	2

; Terminal emulator section

; Kinds of terminals available
ttgenrc equ	0			; no emulation done by Kermit
ttheath equ	1			; Heath-19
ttvt52	equ	2			; VT52
ttvt100	equ	4			; VT100
ttvt102	equ	8			; VT102
ttvt220	equ	10h			; VT220
ttvt320	equ	20h			; VT320
tttek	equ	40h			; Tektronix 4010
tthoney	equ	80h			; Honeywell VIP7809
ttpt200	equ	100h			; Prime PT200
ttd463	equ	200h			; Data General D463
ttd470	equ	400h			; Data General D470
TTTYPES equ	12			; Number of terminal types defined
; tekflg bits in byte
tek_active equ	1			; actively in graphics mode
tek_tek	equ	2			; Tek terminal
tek_dec	equ	4			; Tek submode of DEC terminals
tek_sg	equ	8			; special graphics mode

; DEC emulator status flags (bits in words vtemu.vtflgst and vtemu.vtflgop)
anslnm  equ	1H			; ANSI line feed/new line mode
decawm  equ	2H			; DEC autowrap mode
decscnm equ	80H			; DEC screen mode
decckm  equ	200H			; DEC cursor keys mode
deckpam equ	400H			; DEC keypad application mode
decom   equ	800H			; DEC origin mode
deccol	equ	1000H			; DEC column mode (0=80 col)
decanm  equ	2000H			; ANSI mode
;dececho equ	4000H			; ANSI local echo on (1 = on)
     
; Terminal SETUP mode flags (joint with bits above, some name dups)
vsnewline	equ	1H		; ANSI new line (0 = off)
vswrap		equ	2H		; Line wrap around (0 = no wrap)
vsnrcm		equ	4H		; National Rep Char set (0=none)
vswdir		equ	8H		; Writing direction (0=left, 1 right)
vskeyclick	equ	10H		; Keyclick (0 = off)
vsmarginbell	equ	20H		; Margin bell (0 = off)
vscursor	equ	40H		; Cursor (0 = block, 1 = underline)
vsscreen	equ	80H		; Screen (0 = normal, 1 = rev. video)
vscntl		equ	100h		; 8 or 7 bit controls (1 = 8-bit)
vshscroll	equ	4000h		; horiz scroll (0=auto, 1=manual)
vscompress	equ	8000h		; compressed text(0=graphics,1=132col)

; VTxxx defaults for SETUP
; Note: Tab stops default to columns 9, 17, 25, 33, etc
;
; VSDEFAULTS holds Kermit startup time settings for the VT100 emulator
; Configure it by adding together names from the setup mode flags above
; to turn on features (they default to being off if not mentioned).
; Set the kind of terminal by placing a ttxxxx name in VTFLGS in the
; FLGINFO structure well below.

vsdefaults	equ	0+vscursor+vshscroll+vscompress	; default conditions

emulst	struc			; structure for terminal emulator global data
vtflgst	dw	0		; VTxxx setup flags
vtflgop	dw	0		; VTxxx runtime flags, like setup flags
vttbs	dw	0		; pointer to default tab stops 
vttbst	dw	0		; pointer to tab stops (both in mszibm)
vtchset	db	16		; value of default character set (15=Latin-1)
vtchop	db	16		; value of operational char set
att_ptr	dw	0		; pointer to video attributes: norm, rev
vttable db	4 dup (0ffh)	; char set number for G0..G3 overrides
emulst	ends
; end of terminal emulator section

; Structure definitions

ifdef save_mem2			; define only for Xenix builds
save_mem equ	1		; for Xenix
endif

ifndef save_mem2		; for regular DOS builds
; Command parser information
cmdinfo	struc
cmrprs	dd 0		; offset,segment of where to jmp on reparsing
cmostp  dw 0
cmprmp	dw 0		; Address of prompt
cmwhite	db 0		; non-zero to permit leading whitespace
cmcr	db 0		; Say whether bare CR is allowed
cmper	db 0		; Allow literal backslash-percent in command
cmquiet	db 0		; non-zero for no echoing
cmkeep	db 0		; non-zero to keep Take/Macro open after EOF
cmblen	dw 0		; length of caller's cmtxt receiving buffer
impdo	db 0		; non-zero for keyword search failure to use DO cmd
cmdinfo	ends

; Command parser equates
cmkey	equ	1	; parse a keyword
cmeol	equ	4	; parse a CR end of line character
cmline	equ	5	; parse line of text up to CR
cmword	equ	6	; parse an arbitrary word

endif

; Flags information
flginfo	struc
belflg	db 1		; Use bell
comflg	db 1		; Use COM1 by default
abfflg	db 1		; Discard incoming file if abort
debug	db 0		; Debugging mode (default off)
flwflg	db 0		; File warning (collision) flag (default rename)
extflg	db 0		; Exit flag (default off)
vtflg	dw ttvt320	; term emulation type, default
cxzflg	db 0		; ^X/^Z to interrupt file x-fer
xflg	db 0		; Seen "X" packet
eoflag	db 0		; EOF flag; non-zero on EOF
capflg	db 0		; On if capturing data
takflg	db 0		; On if echoing commands of TAKE file
timflg	db 1		; Say if are timing out or not
destflg	db 1		; Incoming files destination: disk or printer
eofcz	db 0		; ^Z signals eof if non-zero
remflg	db DREGULAR	; server (remote) mode plus display flag bits
modflg	db 1		; non-zero if mode line on
attflg	db 0ffh		; non-zero if file attributes packets are enabled
chrset	dw 0		; ident of file character set (437=hardware, CP437)
unkchs	db 0		; files w/unknown-character-set (0=keep, 1=cancel)
xltkbd	db 1		; keyboard character-set translation (1=on, 0=off)
oshift	db 0		; output-shift (1 = auto, 0 = none, default none)
flginfo	ends

ifndef save_mem2
; Transmission parameters
trinfo	struc
maxdat	dw 0		; Max packet size for send, word for long packets
chklen	db 1		; Number of characters in checksum
seol  	db cr		; Send EOL char
reol  	db cr		; Receive EOL char
ssoh  	db soh		; Send start-of-packet character
rsoh  	db soh		; Receive start-of-packet character
squote	db dsquot	; Send quote character
rquote	db dsquot	; Receive quote character
rptq	db 7eh		; Repeat quote character (tilde)
spsiz 	db dspsiz	; Send (regular) packet size
rpsiz 	db drpsiz	; Receive (regular) packet size
stime 	db dstime	; Send timeout. (Don't timeout)
rtime 	db 5		; Receive timeout
sdelay	db 0		; Send delay time (sec) for just SEND command
spad  	db 0		; Send number of padding char
rpad  	db 0		; Receive number of padding char
spadch	db 0		; Send padding char
rpadch	db 0		; Receive padding char
ebquot	db 'Y'		; Send 8-bit quote character
escchr	db defesc	; Escape character
capas	db 2,0		; Capas bytes (just two for now)
windo	db 1		; number of window slots
rlong	dw drpsiz	; long pkt size we want to receive
slong	dw 9024		; long pkt size we could send (negotiated with host)
xchset	db 0		; transfer char set (0=hardware) on comms wire
xchri	db 0		; transfer char set readable (0) or invertible (1)
xtype	db 0		; file type for xfer (0=text,1=binary,etc)
sdbl	db 0		; char to be doubled when sending (if non-null)
rign	db 0		; char to be ignored when received (if non-null)
lshift	db lock_enable	; locking shift (0=disable, 1=enable, 2=force on)
trinfo	ends
endif

ifndef save_mem
pktinfo	struc
datadr	dd 0		; data field address (segment:offset)
datlen	dw 0		; length of data field in a packet
datsize	dw 0		; length of data field buffer
pktype	db 0		; packet type, a letter
seqnum	db 0		; packet SEQ number
ackdone	db 0		; zero if pkt not ack'ed yet
numtry	db 0		; number of tries on this packet
pktinfo	ends
endif

filest	struc
dta	db 26 dup(0)	; DOS, 21 resev'd bytes, file attr, 2 each date & time
sizelo	dw 0		; DOS, file size double word
sizehi	dw 0
fname	db 13 dup(0)	; DOS, filename, asciiz, with dot. End of DOS section
handle	dw -1		; Kermit, file handle
string	db 64 dup(0)	; Kermit, filename string, including drive and path
fstat	db 0		; Kermit, status of Find First DOS call
filest	ends

takinfo	struc		; Take file structure
taktyp	db 0		; type: 0FEh = valid file handle, 0FFh = a macro
takhnd	dw 0		; file handle
takbuf	dw 0		; offset of Take buffer
takptr	dw 0		; pointer in buffer to next char to read
takcnt	dw 0		; number of unread bytes in buffer
takctr	dw 0		; COUNT variable for script program control
takargc	dw 0		; argument quantity count
takinfo ends

; Port Information
prtinfo	struc
baud	dw 0		; Default baud rate
ecoflg	db 0		; Local echo flag (default off)
parflg	db 0		; Parity flag (default none)
floflg	db 0		; If need flow control
hndflg	db 0		; If need handshake during file transfer
hands	db 0		; Default handshake
flowc	dw 0		; Do flow control with XON/XOFF
duplex	db 0		; Do full (0) or half (1) duplex comms
portrdy db 0		; Non-zero if comms port is still active
sndproc dw 0		; byte sending procedure
rcvproc dw 0		; byte receiving procedure
cloproc dw 0		; session close procedure
prtinfo	ends
				; ENABLE/DISABLE bits for denyflg
cwdflg	equ	1		; deny remote cwd
delflg	equ	2		; deny remote del
dirflg	equ	4		; deny remote dir
hostflg	equ	8		; deny remote host
spcflg	equ	10H		; deny remote space
finflg	equ	20H		; deny fin, bye, logo to server
getsflg	equ	40H		; deny paths in get cmds to server
sndflg	equ	80H		; deny paths in send cmds to server
typflg	equ	100H		; deny paths in type
pasflg	equ	200h		; username/password required
kerflg	equ	400h		; deny remote kermit
prtflg	equ	800h		; deny remote print
tekxflg	equ	8000h		; deny automatic Tektronix invokation

ifndef save_mem
statinfo struc			; statistics, basic information layout
prbyte	dw	2 dup (0)	; number of bytes received by port
psbyte	dw	2 dup (0)	; number of bytes sent to port
frbyte	dw	2 dup (0)	; bytes received
fsbyte	dw	2 dup (0)	; bytes sent
prpkt	dw	2 dup (0)	; number of packets received
pspkt	dw	2 dup (0)	; number of packets sent
nakrcnt	dw	0		; count of naks received
nakscnt	dw	0		; count of naks sent
btime	dw	2 dup (0)	; start time (seconds) of transfer
etime	dw	2 dup (0)	; elapsed time (seconds) of transfer
pretry	dw	0		; packet retries
xstatus	db	0		; transfer status
xname	db	64 dup (0)	; alias (send/receive as) filename
statinfo ends

endif

scptinfo struc			; scripts
inactv	db	0		; input action value (default proceed)
incasv	db	0dfh		; input case  (default ignore)
indfto	dw	1		; input and pause timeout (def 1 sec)
inecho	db	1		; echo Input cmd text (0 = no)
xmitfill db	0		; non-zero to TRANSMIT filler for blank line
xmitlf	db	0		; non-zero to TRANSMIT LF's
xmitpmt	db	lf		; default prompt for line acknowledgments
xmitpause dw	0		; millisec pause between lines
scptinfo ends

; definitions for terminal handler:
termarg	struc
flgs	db 0		; flags
prt	db 0		; port to use (0,1,etc)
captr	dw 0		; routine to call with captured data
baudb	db 0		; baud rate bits
parity	db 0		; parity
termarg	ends

; bits for flag byte
capt	equ 40h		; capture output
emheath	equ 20h		; emulate heath
trnctl	equ 08h		; translate controls (debug)
modoff	equ 04h		; mode line off
lclecho	equ 01h		; local echo

; bits for kstatus general Kermit status word
kssuc	equ	0000h	; success condition
kssend	equ	0001h	; send file failed
ksrecv	equ	0002h	; get/receive file failed
ksrem	equ	0004h	; Remote command failed
kstake	equ	0008h	; Take file failure
ksgen	equ	0010h	; general command failure
ksuser	equ	0080h	; user intervention (aka Control-C)

mkeyw	macro	key,value	; widely used data structure
	local	keylen,start
start	equ	$		; remember start address of structure
	dw	keylen		; length of "key"
	db	key		; "key" itself
keylen	equ	$-(start+2)	; number of bytes in "key"
	dw	value		; action value
	endm
;
; Note well. The following segment references are in THIS file to provide
; the desired ordering of them in memory. To wit: lowest addresses for
; 'code', followed by 'data', and only then by 'stack'.
code	segment public 'kcode'
code	ends
code1	segment public 'kcode'
code1	ends
code2	segment public 'kcode'
code2	ends
data	segment public 'kdata'
data	ends
data1	segment public 'kdata'
data1	ends
_TEXT	SEGMENT  WORD PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
_STACK	SEGMENT	WORD STACK 'STACK'
_STACK	ENDS
DGROUP	GROUP	CONST, _BSS, _DATA, _STACK
	.list
