
/*

	ShortInt class definition   7/13/94 by Brian Lee Price

	This is a flag class.

	Compatible with experimental strong typing option

	Released as Public Domain    July, 1994.

*/

#define CLASS ShortInt

#include "gcoope10.h"

#include <stdio.h>

object CLASS;

extern object String;
extern object Char;
extern object LongInt;
extern object Unsigned;

USEGEN(changeVal);
USEGEN(valueOf);
USEGEN(asString);
USEGEN(asHexStr);
USEGEN(asChar);
USEGEN(asLongInt);
USEGEN(asUnsigned);
USEGEN(asShortInt);

cmethod object m4New(object instance, short initVal)
{
if(((objHndl *) &instance)->fext)
    {
    short * ivptr;
    if(NULL==(ivptr=getIVptr(instance))) return 0;
    *ivptr=initVal;
    }
else
    {
    ((objHndl *) &instance)->fext=(tag)instance | ~SIGNMASK;
    (tag) instance=0;
    (short) instance=initVal;
    }
return instance;
}


imethod object m4changeVal(object instance, short newVal)
{
if(instance>=0)
    {
    short * ivptr;
    if(NULL==(ivptr=getIVptr(instance))) return FUNCFAIL;
    *ivptr=newVal;
    }
else (short) instance=newVal;
return FUNCOKAY;
}


imethod short m4valueOf(object instance)
{
if(instance>=0)
    {
    short * ivptr;
    ivptr=getIVptr(instance);
    return *ivptr;
    }
else return (short) instance;
}


imethod object m4asString(object instance)
{
char strBuf[16];
short a;

if(instance>=0) a=*((short *) getIVptr(instance));
else a=(short) instance;
sprintf(strBuf,"%d",(int) a);
return g(New)(String,strBuf);
}


imethod object m4asHexStr(object instance)
{
char strBuf[16];
short a;

if(instance>=0) a=*((short *) getIVptr(instance));
else a=(short) instance;
sprintf(strBuf, "%x", (unsigned) a);
return g(New)(String,strBuf);
}


imethod object m4asChar(object instance)
{
short a;

if(instance>=0) a=*((short *) getIVptr(instance));
else a=(short) instance;
return g(New)(Char,(char) a);
}


imethod object m4asLongInt(object instance)
{
short a;

if(instance>=0) a=*((short *) getIVptr(instance));
else a=(short) instance;
return g(New)(LongInt,(long) a);
}


imethod object m4asUnsigned(object instance)
{
short a;

if(instance>=0) a=*((short *) getIVptr(instance));
else a=(short) instance;
return g(New)(Unsigned,(unsigned short) a);
}


CLASS_INSTALL
{
stat x=FUNCFAIL;

if(END==(CLASS=g(New)(Class, 0, sizeof(short), END))) goto end;
if(addGMthd(CLASS, New, (method) m4New)) goto end;
if(addGMthd(CLASS, GEN(changeVal), (method) m4changeVal)) goto end;
if(addGMthd(CLASS, GEN(valueOf), (method) m4valueOf)) goto end;
if(addGMthd(CLASS, GEN(asString), (method) m4asString)) goto end;
if(addGMthd(CLASS, GEN(asHexStr), (method) m4asHexStr)) goto end;
if(addGMthd(CLASS, GEN(asChar), (method) m4asChar)) goto end;
if(addGMthd(CLASS, GEN(asLongInt), (method) m4asLongInt)) goto end;
if(addGMthd(CLASS, GEN(asUnsigned), (method) m4asUnsigned)) goto end;
if(addGMthd(CLASS, GEN(asShortInt), bounceBack)) goto end;
x=FUNCOKAY;

end:
return x;
}
