/*==========================================================================
 *
 *  EXAMP002.C                                      Wednesday, April 6, 1994
 *
 *  sample source code for The BESTLibrary, intended to give examples of:
 *    txt_fade_in
 *    txt_fade_out
 *    txt_fill_area
 *    txt_flood
 *    txt_print
 *    txt_set_act
 *    txt_set_vis
 *    txt_str_show
 *
 *  Authored independently by George Vanous
 *
 *==========================================================================*/


/* ------------------------------------------------------------------------ */
/* ----------------------------  INCLUDE FILES  --------------------------- */

#include <alloc.h>
#include <stdlib.h>
#include "!bestlib.h"                  /* include !BESTLIB.H in compilation */

/* ------------------------------------------------------------------------ */
/* ------------------------------  CONSTANTS  ----------------------------- */

#define BGCLR BLUE                              /* background color         */
#define TEXTHEIGHT 12                           /* y-height of printed text */
#define BUFFERSPACE 100                         /* byte size of "buffer"    */
#define PRINT(x, y, text) _16_boxfill(x, y+2, textwidth(text), TEXTHEIGHT-2, BLACK, COPY_IMAGE); outtextxy(x, y, text);

/* ------------------------------------------------------------------------ */
/* ------------------------------  MESSAGES  ------------------------------ */

#define ERR01 "\nI require 65,536 bytes (64kb) of free memory\nBut there is only %ld bytes currently available\n\nDo you want me to continue regardless [y/N] ? "
#define MSG01 "\n\nI suggest you try removing any unnecessary TSRs (Terminate but Stay Resident\nprograms) to increase the amount of available memory.\n\n"
#define DASHES printf("\n--------------------------------------------------------------------------------")

/* ------------------------------------------------------------------------ */
/* -------------------------  GLOBAL DEFINITIONS  ------------------------- */

/* The following three definition are required by TheBESTLibrary to be
   present, even if they are not all used.  If they are not present, the
   compiler will produce a "linker error". */
asciiscan key;                         /* global structure "key"            */
cursordata cursor;                     /* global structure "cursor"         */
mousedata msdata;                      /* global structure "msdata"         */

filldata fidata;                       /* global structure "fidata"         */
printdata prdata;                      /* global structure "prdata"         */

byte curx, cury,                       /* the cursor (x,y)                  */
     oldmode;                          /* old video mode                    */
char *buffer;                          /* general-purpose string buffer     */

/* ------------------------------------------------------------------------ */
/* -------------------------  FUNCTION PROTOTYPES  ------------------------ */

void begin_sequence(void);                      /* beginning sequence       */
void exit_sequence(void);                       /* exitting sequence        */
void mouse_demo(void);                          /* demonstrate mouse        */
void floodtext(char *text[]);                   /* part of "mouse_demo"     */
void showtext(char *text[]);                    /* part of "mouse_demo"     */
void string_demo(void);                         /* demonstrate strings      */
void text_animate(void);                        /* animates text            */
void text_fade(void);                           /* demonstrate text fading  */

void (*menuselect[])(void) = {                  /* pointer to functions     */
  mouse_demo, string_demo, text_animate, text_fade
};

/* ------------------------------------------------------------------------ */


/*----------------------------------------------------------------------------
 * MAIN SUBROUTINE OF EXAMPLE SOURCE CODE 002
 */
void main(void)
{
  int choice;                          /* user's menu choice                */
  byte count;

  begin_sequence();                    /* perform the beginning sequence    */
  txt_flood(WHITE, BLUE, " ");         /* flood with white fg and blue bg   */
  txt_str_show(0, 0, "MOUSE", ALIGN_NONE);
  txt_str_show(80, 0, "STRING", ALIGN_HORZ);
  txt_str_show(80, 0, "TEXT MODE", ALIGN_RIGHT);
  txt_str_show(0, 2, "Demonstration", ALIGN_HORZ);
  txt_str_show(2, 5, "1) Mouse demonstration", ALIGN_NONE);
  txt_str_show(2, 6, "2) String demonstration", ALIGN_NONE);
  txt_str_show(2, 7, "3) Text animation", ALIGN_NONE);
  txt_str_show(2, 9, "4) Text fading", ALIGN_NONE);
  txt_str_show(0, 11, "<ESC> Exit to DOS", ALIGN_NONE);
  txt_scroll_over(400);                /* scroll up the menu screen         */
  txt_set_act(TEXTPAGE1);              /* set first text page as active     */
  txt_set_vis(TEXTPAGEACTIVE);         /* show active text page             */
  txt_split(1023);                     /* restore screens to normal         */

  while (TRUE) {
    kbd_clear();                       /* clear keyboard buffer             */
    count = txt_get_num(25, 14, &choice, 1, '', "Type in your selection: ",
                        LIGHTCYAN, LIGHTBLUE, "4");
    if (count != -1 && choice >= 1 && choice <= 4)
      (*menuselect[choice-1])();       /* perform the desired demonstration */
    else
      break;                           /* else exit program                 */
    txt_set_act(TEXTPAGE1);            /* set first text page as active     */
    txt_set_vis(TEXTPAGEACTIVE);       /* show active text page             */
  };

  exit(0);  /* executes the procedure "exit_sequence()" because of the line
               "atexit(exit_sequence)" in procedure "begin_sequence"        */
}

/*----------------------------------------------------------------------------
 * Beginning sequence.
 */
void begin_sequence(void)
{
  char ch;                             /* generic character holder          */
  byte i, j;                           /* cursor position holders           */

  /* allocate space for a generic string buffer */
  buffer = (char *) malloc(BUFFERSPACE);

  /* check amount of available memory */
  DASHES;                              /* print one line of dashes          */
  if (coreleft() < 64000L) {
    sprintf(buffer, ERR01, coreleft());
    fprintf(stderr, buffer);           /* print low memory warning message  */
    cur_get_coord_abs(&i, &j);         /* get the cursor position           */
    while ((ch = case_up(getchre(i, j))) != 'Y' && ch != 'N' && ch != 13) {
      beep();                          /* signal invalid keypress           */
      txt_chr_erase(i, j, 1);          /* erase character                   */
    }
    if (ch != 'Y') {                   /* if 'Y' chosen                     */
      fprintf(stderr, MSG01);          /*   print suggestion message        */
      exit(1);                         /*   exit to DOS with ERRORLEVEL 1   */
    }                                  /* else continue with program        */
  }

  /* initialize The BEST Library and save old video mode
   * set 25-line text mode (TEXT25) and initialize the mouse (TRUE)         */
  oldmode = bestlib_init(TEXT25, TRUE);
  txt_set_act(TEXTPAGELAST);           /* set last text page as active      */
  txt_mem(TEXTSHOW, NULL);             /* write DOS screen to text page 2   */
  txt_set_vis(TEXTPAGEACTIVE);         /* show active text page             */
  txt_set_act(TEXTPAGE1);              /* set first text page as active     */

  /* store that status of the insert, caps, num, and scroll lock */
  kbd_status_save();

  ms_show();                           /* show mouse cursor                 */
  txt_blink(FALSE);                    /* enable 16 background colors       */
  cur_off();                           /* hide the cursor                   */
  atexit(exit_sequence);               /* define the exit procedure         */
//txt_fade_out();                      /* fade current text screen to black */
}

/*----------------------------------------------------------------------------
 * Exiting sequence.
 */
void exit_sequence(void)
{
  kbd_status_load();
  ms_hide();                           /* hide mouse cursor                 */
//txt_fade_out();                      /* fade original text screen back in */
  txt_set_vis(TEXTPAGELAST);           /* show last text page               */
  txt_scroll_over(-400);               /* restore original text screen      */
  video_restore(oldmode);              /* restore original video status     */
//txt_fade_in();                       /* fade in the text screen           */
  exit(0);                             /* exit to DOS with ERRORLEVEL 0     */
}

/*----------------------------------------------------------------------------
 * Demonstrate mouse routines.
 */
void mouse_demo(void)
{
#define TXT01 0
#define TXT02 1
#define TXT03 2
#define TXT04 3
#define TXT05 4
#define TXT06 5
#define TXT07 6
#define TXT08 7
#define TXT09 8
#define TXT0A 9
#define TXT0B 10
#define TXT0C 11
#define LOC1 7
#define LOC2 11
#define LOC3 5
#define LOC4 0
#define LOC5 24
#define QUE01 12
#define QUE02 13

  char *text[] = {
    "Demonstration of Microsoft compatible mouse routines",        /* TXT01 */
    "Authored independently by George Vanous",                     /* TXT02 */
    "left button is not pressed",                                  /* TXT03 */
    "left button is pressed    ",                                  /* TXT04 */
    "left button was pressed at",                                  /* TXT05 */
    "left button was released at",                                 /* TXT06 */
    "right button is not pressed",                                 /* TXT07 */
    "right button is pressed    ",                                 /* TXT08 */
    "right button was pressed at",                                 /* TXT09 */
    "right button was released at",                                /* TXT0A */
    " cursor is located at",                                       /* TXT0B */
    "press any key to terminate",                                  /* TXT0C */
    "Which ASCII character to use as cursor? [219] ",              /* QUE01 */
    "What color? [7] "                                             /* QUE02 */
  };
  int chr, color;
  shortint count;

  txt_set_act(TEXTPAGE2);              /* make text page 2 active now       */
  txt_flood(LIGHTGREY, BLACK, " ");    /* clear the screen and set colors   */
  prdata.x = 55, prdata.y = 11;        /* set the next print position       */
  txt_set_vis(TEXTPAGEACTIVE);         /* show active text page             */
  count = txt_get_num(prdata.x, prdata.y, &chr, 3, ' ', text[QUE01],
                 BLACK, WHITE, "219"); /* get the user's input              */
  if (count == -1) return;             /* return to menu if <ESC> pressed   */
  prdata.y += 2;                       /* set the next print position       */
  count = txt_get_num(prdata.x, prdata.y, &color, 1, ' ', text[QUE02],
                   BLACK, WHITE, "7"); /* get the user's input              */
  if (count == -1) return;             /* return to menu if <ESC> pressed   */

  txt_flood(LIGHTGREY, BLACK, " ");    /* clear the screen and set colors   */
  showtext(text);                      /* print up the screen               */
  prdata.y = LOC1;                     /* define the y-coordinate to print  */
  prdata.command = -1;                 /* specify no modifications          */
  prdata.text = text[TXT03];           /* specify the string to print       */
  txt_print(MEM, MEM, &prdata);        /* print left mouse button status    */
  prdata.y = LOC2;                     /* define the y-coordinate to print  */
  prdata.text = text[TXT07];           /* specify the string to print       */
  txt_print(MEM, MEM, &prdata);        /* print right mouse button status   */
  ms_shape(chr, color, -1);            /* change mouse cursor and color     */
  stopw(0, 15);                        /* start stopwatch 0                 */

  fidata.fgclr = GREEN, fidata.bgclr = BLACK,
  fidata.x = fidata.y = 0,
  fidata.length = 80, fidata.height = 25,
  fidata.print = NULL;
  while (!keyhit()) {
    floodtext(text);                   /* fill the entire screen            */
    ms_stat();                         /* read the mouse status             */
    if (msdata.pos[0] != msdata.npos[0]) {
      msdata.pos[0] = msdata.npos[0];
      msdata.update += 1;              /* if the mouse x-position changed.. */
    }
    if (msdata.pos[1] != msdata.npos[1]) {
      msdata.pos[1] = msdata.npos[1];
      msdata.update += 2;              /* if the mouse y-position changed.. */
    }
    if (msdata.buts[0] != msdata.nbuts[0]) {
      msdata.buts[0] = ~msdata.buts[0];
      msdata.update += 4;      /* if the left mouse button state changed..  */
    }
    if (msdata.buts[1] != msdata.nbuts[1]) {
      msdata.buts[1] = ~msdata.buts[1];
      msdata.update += 8;      /* if the right mouse button state changed.. */
    }
    if (msdata.update) {               /* if mouse registered activity..    */
      msdata.update = 0;               /* reset the mouse activity flag     */
      prdata.fgclr = YELLOW;           /* set the foreground text color     */
      prdata.command = 0;              /* specify text to be centered       */
      prdata.x = 0, prdata.y = LOC3;   /* define the location to print      */
      sprintf(prdata.text = buffer, "%s %d, %d  ",
              text[TXT0B], msdata.pos[0], msdata.pos[1]);
      txt_print(MEM, MEM, &prdata);    /* print cursor location             */
      prdata.command = -1;             /* specify no modifications          */
      prdata.y = LOC1;                 /* define y-coordinate of next print */
      if (!msdata.buts[0]) {           /* if left button is not pressed..   */
        prdata.text = text[TXT03];
        txt_print(MEM, MEM, &prdata);  /* print left button not pressed     */
        sprintf(prdata.text = buffer, "%s %d, %d  ",
                text[TXT06], msdata.butlr[0], msdata.butlr[1]);
        prdata.y++;                    /* increment y-coordinate of print   */
      }
      else {                           /* else left button is pressed..     */
        prdata.text = text[TXT04];
        txt_print(MEM, MEM, &prdata);  /* print left button is pressed      */
        sprintf(prdata.text = buffer, "%s %d, %d  ",
                text[TXT05], msdata.butlp[0], msdata.butlp[1]);
        prdata.y += 2;                 /* add to y-coordinate of print      */
      }
      txt_print(MEM, MEM, &prdata);    /* print left button coordinates     */
      prdata.y = LOC2;                 /* define new y-coordinate for print */
      if (!msdata.buts[1]) {           /* if right button is not pressed..  */
        prdata.text = text[TXT07];
        txt_print(MEM, MEM, &prdata);  /* print right button unpressed      */
        sprintf(prdata.text = buffer, "%s %d, %d  ",
                text[TXT0A], msdata.butrr[0], msdata.butrr[1]);
        prdata.y++;                    /* increment y-coordinate of print   */
      }
      else {                           /* else right button is pressed..    */
        prdata.text = text[TXT08];
        txt_print(MEM, MEM, &prdata);  /* print right button is pressed     */
        sprintf(prdata.text = buffer, "%s %d, %d  ",
                text[TXT09], msdata.butrp[0], msdata.butrp[1]);
        prdata.y += 2;                 /* add to y-coordinate of print      */
      }
      txt_print(MEM, MEM, &prdata);    /* print right button coordinates    */
    }
  }
}

/* 32 250 249 46 7 176 177 178 219
 *           .               */
void floodtext(char *text[])
#define FLOODCHARNO 8
{
  static int cycle = 1, dir = 1;
  int data[] = { 32, 250, 249, 46, 7, 176, 177, 178, 219 };

  if (stopw(0, 0) == TRUE) {
    fidata.fillchar = data[cycle];     /* set the character to fill with    */
    sprintf(buffer, "%c", data[cycle - dir]);
    fidata.overwrite = buffer;         /* specify the string to overwrite   */
    if (cycle == FLOODCHARNO || (cycle == 1 && dir < 0))
      dir = -dir;                      /* cycle fill characters in reverse  */
    cycle += dir;                      /* get the next fill character       */
    txt_fill_area(MEM, MEM, &fidata);  /* fill screen with the character    */
    msdata.update++;                   /* reprint the mouse status onscreen */
    showtext(text);                    /* reprint the standard text         */
    stopw(0, 15);                      /* reset stopwatch 0                 */
  }
}

/*----------------------------------------------------------------------------
 * Print initial text.
 */
void showtext(char *text[])
{
  prdata.fgclr = WHITE, prdata.bgclr = BLUE;         /* set printing colors */
  prdata.command = ALIGN_HORZ;         /* center the text to print          */
  prdata.x = 0, prdata.y = LOC4;       /* define the coordinates to print   */
  prdata.text = text[TXT01];           /* specify the string to print       */
  txt_print(MEM, MEM, &prdata);        /* print first line of title         */
  prdata.y++;                          /* increment the y-coordinate        */
  prdata.text = text[TXT02];           /* specify the string to print       */
  txt_print(MEM, MEM, &prdata);        /* print second line of title        */
  prdata.y = LOC5;                     /* define the y-coordinate to print  */
  prdata.text = text[TXT0C];           /* specify the string to print       */
  txt_print(MEM, MEM, &prdata);        /* print the "any key exits" message */
}

/*----------------------------------------------------------------------------
 * Demonstrate string routines.
 */
void string_demo(void)
{

}

/*----------------------------------------------------------------------------
 * Animate text.
 */
void text_animate(void)
{

}

/*----------------------------------------------------------------------------
 * Demonstrate text fading.
 */
void text_fade(void)
{
  fade_out();                          /* fade current screen to black      */
  fade_in();                           /* fade screen back in               */
}

