/*
 *   Copyright 1992, 1993, 1994 John Melton (G0ORX/N6LYT)
 *              All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
	message.c

	Prepare a PacSat message for uploading

	John Melton
	G0ORX, N6LYT

	4 Charlwoods Close
	Copthorne
	West Sussex
	RH10 3QZ
	England

	INTERNET:	g0orx@amsat.org
			n6lyt@amsat.org
			john@images.demon.co.uk
			J.D.Melton@slh0613.icl.wins.co.uk

	History:

	0.1	initial version.
	0.2	fixed file length in header.
*/

#define INSERTCRLF

#define VERSION_STRING "message (version 0.2 by g0orx/n6lyt)"

#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/font.h>
#include <xview/svrimage.h>
#include <xview/textsw.h>
#include <xview/notice.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <malloc.h>
#include <dirent.h>
#include "header.h"
#include "ftl0.h"

Frame frame;
Panel panel;
Panel_item panel_from;
Panel_item panel_to;
Panel_item panel_title;
Panel_item panel_key_words;
Panel_item panel_file_type;
Panel_item panel_compression;
Panel_item panel_comp_desc;
Panel_item panel_message_source;
Textsw textsw;

char myCall[32];
char toCall[32];
char title[80];

#define MAXHEADER 1024
unsigned char header[MAXHEADER];
int nHeader;

unsigned char	szHeaderId[2];
unsigned long	nFileNumber;
char		szFileName[9] = "        ";
char		szFileExt[4] = "   ";
unsigned long	nFileSize = 0;
unsigned long	nCreateTime = 0;
unsigned long	nModifiedTime = 0;
unsigned char	nSEUflag = 0;
unsigned char	nFileType;
unsigned int	nBodyChecksum = 0;
unsigned int	nHeaderChecksum = 0;
unsigned int	nBodyOffset;
unsigned char	szSource[32];
unsigned char	szUploader[7] = "      ";
unsigned long	nUploadTime = 0;
unsigned char	nDownloadCount = 0;
char		szDestination[32];
char		szDownloader[7] = "      ";
unsigned long	nDownloadTime = 0;
unsigned long	nExpireTime = 0;
unsigned char	nPriority;
unsigned char	nCompressionType;
char		cBBSMessageType = ' ';
char		szBullitinId[16] = "";


char		szTitle[255];
char		szKeywords[255];
char		szDescription[255] = "";
char		szCompressionDescription[255] = "";
char		szSourceFile[128];
int		source;
int		fileType;
char		szText[4096];

extern void exit( );
void panel_select( Panel_item item, char * string, caddr_t client_data,
			Panel_list_op op, Event *event );
void panel_quit( void );
void panel_prepare( void );
int PrepareFile( int uploadSeq, int source );

main( int argc, char ** argv )
{
	Xv_Font font;

	xv_init( XV_INIT_ARGS, argc, argv, NULL );

	if( getenv( "MYCALL" ) == (char *)0 )
		strcpy( myCall, "NOCALL" );
	else
		strcpy( myCall, getenv( "MYCALL" ) );

	if( argc > 1 )
		strcpy( toCall, argv[1] );
	else
		strcpy( toCall, "" );

	if( argc > 2 )
		strcpy( title, argv[2] );
	else
		strcpy( toCall, "" );
	
	frame = (Frame)xv_create( (Frame)NULL, FRAME,
				FRAME_LABEL, VERSION_STRING,
				XV_WIDTH, 600,
				NULL );
	font = (Xv_Font)xv_find( frame, FONT,
				FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
				FONT_SIZE, 12,
				NULL );
	panel = (Panel)xv_create( frame, PANEL,
				PANEL_LAYOUT, PANEL_VERTICAL,
				XV_FONT, font,
				NULL );

	textsw = (Textsw)xv_create( frame, TEXTSW,
		WIN_BELOW, panel,
		XV_X, 4, NULL );

	xv_set( panel, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL );

	(void)xv_create( panel, PANEL_BUTTON,
		PANEL_FONT, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
		PANEL_LABEL_STRING, "Quit",
		PANEL_NOTIFY_PROC, panel_quit,
		XV_FONT, font,
		NULL );

	(void)xv_create( panel, PANEL_BUTTON,
		PANEL_FONT, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
		PANEL_LABEL_STRING, "Prepare",
		PANEL_NOTIFY_PROC, panel_prepare,
		XV_FONT, font,
		NULL );

	xv_set( panel, PANEL_LAYOUT, PANEL_VERTICAL, NULL );

	font = (Xv_Font)xv_find( panel, FONT,
				FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
				NULL );

	panel_from = (Panel_item)xv_create( panel, PANEL_TEXT,
		PANEL_LABEL_STRING, "From:     ",
		PANEL_VALUE, myCall,
		PANEL_VALUE_DISPLAY_LENGTH, 32,
		PANEL_VALUE_STORED_LENGTH, 32,
		NULL );

	panel_to = (Panel_item)xv_create( panel, PANEL_TEXT,
		PANEL_LABEL_STRING, "To:       ",
		PANEL_VALUE, toCall,
		PANEL_VALUE_DISPLAY_LENGTH, 32,
		PANEL_VALUE_STORED_LENGTH, 32,
		NULL );

	panel_title = (Panel_item)xv_create( panel, PANEL_TEXT,
		PANEL_LABEL_STRING, "Title:    ",
		PANEL_VALUE, title,
		PANEL_VALUE_DISPLAY_LENGTH, 64,
		PANEL_VALUE_STORED_LENGTH, 64,
		NULL );

	panel_key_words = (Panel_item)xv_create( panel, PANEL_TEXT,
		PANEL_LABEL_STRING, "Key Words:",
		PANEL_VALUE_DISPLAY_LENGTH, 64,
		PANEL_VALUE_STORED_LENGTH, 64,
		NULL );

	panel_file_type = (Panel_item)xv_create( panel, PANEL_CHOICE_STACK,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "File Type",
		PANEL_CHOICE_STRINGS, "ASCII text",
					"RLI/MBL message(single)",
					"RLI/MBL message(multiple)",
					"UoSAT WOD",
					"PacSat WOD",
					"UoSAT CPE",
					"MS/PC-DOS .exe",
					"MS/PC-DOS .com",
					"Keps (NASA 2-line)",
					"Keps (AMSAT)",
					"Error logs",
					"Activity logs",
					"Other",
					NULL,
		PANEL_VALUE, 0,
		NULL );

	panel_compression = (Panel_item)xv_create( panel, PANEL_CHOICE_STACK,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "Compression Type",
		PANEL_CHOICE_STRINGS, "Not Compressed",
					"PKARC",
					"PKZIP",
					NULL,
		PANEL_VALUE, 0,
		NULL );

	panel_comp_desc = (Panel_item)xv_create( panel, PANEL_TEXT,
		PANEL_LABEL_STRING, "Compression Description:",
		PANEL_VALUE_DISPLAY_LENGTH, 64,
		PANEL_VALUE_STORED_LENGTH, 64,
		NULL );

	panel_message_source = (Panel_item)xv_create( panel, PANEL_CHOICE,
		PANEL_LABEL_STRING, "Message Source",
		PANEL_CHOICE_STRINGS, "File", "Inline Text", NULL,
		PANEL_VALUE, 1,
		NULL );

	window_fit_height( panel );


	xv_set( textsw, WIN_BELOW, panel, NULL );

	xv_main_loop( frame );
}

void panel_select( Panel_item item, char * string, caddr_t client_data,
			Panel_list_op op, Event *event )
{
	switch( op )
	{
	case PANEL_LIST_OP_SELECT:
		break;
	case PANEL_LIST_OP_DESELECT:
		break;
	}
}

void panel_quit( )
{
	textsw_reset( textsw, 0, 0 );
	xv_destroy_safe( frame );
}

void panel_prepare( )
{
	int t;
	char temp[80];

	t = (int)time( (time_t *)&t );

	/* extract data from the panel */
	strcpy( szSource, (char *)xv_get( panel_from, PANEL_VALUE, NULL ) );
	strcpy( szDestination, (char *)xv_get( panel_to, PANEL_VALUE, NULL ) );
	strcpy( szTitle, (char *)xv_get( panel_title, PANEL_VALUE, NULL ) );
	strcpy( szKeywords, (char *)xv_get( panel_key_words, PANEL_VALUE, NULL ) );
#ifdef INSERTCRLF
	{
		char temp[2048];
		char *src;
		char *dest;

		xv_get( textsw, TEXTSW_CONTENTS, 0, temp, 2048, NULL );
		src = temp;
		dest = szText;
		while( *src )
		{
			if( *src == 0x0A )
				*dest++ = 0x0D;
			*dest++ = *src++;
		}
		*dest++ = 0x00;
	}
#else
	xv_get( textsw, TEXTSW_CONTENTS, 0, szText, 2048, NULL );
#endif
	source = (int)xv_get( panel_message_source, PANEL_VALUE, NULL );
	fileType = (int)xv_get( panel_file_type, PANEL_VALUE, NULL );
	nCompressionType = (int)xv_get( panel_compression, PANEL_VALUE, NULL );
	if( fileType == 12 )
	{
		fileType = 255;
		strcpy( szCompressionDescription,
			(char *)xv_get( panel_comp_desc, PANEL_VALUE, NULL ) );
	}

	/* prepare the header and the data */
	if( !PrepareFile( t, source ) )
	{
		sprintf( temp, "Message prepared: file %x.upl", t );

		(void)notice_prompt( panel, NULL,
				NOTICE_MESSAGE_STRINGS, temp, NULL,
				NOTICE_BUTTON, "OK", 100,
				NULL );
	}
			
}

void HeaderOut( int v )
{
	if( nHeader < MAXHEADER )
	{
		header[nHeader] = v;
		nHeader++;
	}
}

void Header( unsigned int id, char * string, int length )
{
	int i;

	HeaderOut( id );
	HeaderOut( 0 );
	HeaderOut( length );
	for( i=0; i<length; i++ )
		HeaderOut( string[i] );
}

int PrepareFile( int uploadSeq, int source )
{
	int      	hSource;
	int      	hOut;
	char		szSourceFilePrefix[16];
	char		szOut[128];
	int      	i, j;
	int		updateFileSize;
	int		updateBodyChecksum;
	int		updateHeaderChecksum;
	int		updateBodyOffset;
	int		savedHeaderOffset;
	int		nBytes;
	unsigned char	buffer[512];

	nHeaderChecksum = 0;
	nBodyChecksum = 0;
	nFileSize = 0;
	nBodyOffset = 0;

	switch( source )
	{
		case 0:
			strcpy( szSourceFile, szText );
			i = strlen( (char *)szSourceFile ) - 1;
			while( (i>0) && (szSourceFile[i]!='/') )
				i--;
			if( szSourceFile[i] == '/' )
				i++;
			if( i != 0 )
				strcpy( szSourceFile, szSourceFile+i );
			break;
		case 1:
			sprintf( szSourceFile, "%x.txt", uploadSeq );
			break;
	}

	sprintf( szOut, "%x.upl",  uploadSeq );

	nHeader = 0;

	HeaderOut( 0xAA );
	HeaderOut( 0x55 );
	Header( 0x01, (char *)&nFileNumber, 4 );
	Header( 0x02, (char *)szFileName, 8 );
	Header( 0x03, (char *)szFileExt, 3 );
	updateFileSize = nHeader;
	Header( 0x04, (char *)&nFileSize, 4 );
	Header( 0x05, (char *)&nCreateTime, 4 );
	Header( 0x06, (char *)&nModifiedTime, 4 );
	Header( 0x07, (char *)&nSEUflag, 1 );
	Header( 0x08, (char *)&nFileType, 1 );
	updateBodyChecksum = nHeader;
	Header( 0x09, (char *)&nBodyChecksum, 2 );
	updateHeaderChecksum = nHeader;
	Header( 0x0A, (char *)&nHeaderChecksum, 2 );
	updateBodyOffset = nHeader;
	Header( 0x0B, (char *)&nBodyOffset, 2);

	Header( 0x10, (char *)szSource, strlen( (char *)szSource ) );
	Header( 0x11, (char *)szUploader, 6 );
	Header( 0x12, (char *)&nUploadTime, 4 );
	Header( 0x13, (char *)&nDownloadCount, 1 );
	Header( 0x14, (char *)szDestination, strlen( (char *)szDestination ) );
	Header( 0x15, (char *)szDownloader, 6 );
	Header( 0x16, (char *)&nDownloadTime, 4 );
	Header( 0x17, (char *)&nExpireTime, 4 );
	Header( 0x18, (char *)&nPriority, 1 );
	Header( 0x19, (char *)&nCompressionType, 1 );
	Header( 0x22, (char *)szTitle, strlen( (char *)szTitle ) );
	/* Header( 0x20, (char *)&cBBSMessageType, 1 ); */
	/* Header( 0x21, (char *)szBullitinId, 0 ); */
	if( strlen( (char *)szKeywords ) != 0 )
		Header( 0x23, (char *)szKeywords, strlen( (char *)szKeywords ) );
	/* Header( 0x24, (char *)szDescription, strlen( (char *)szDescription ) ); */
	if( fileType == 255 )
		Header( 0x25, (char *)szCompressionDescription, strlen( (char *)szCompressionDescription ) );

	Header( 0x26, (char *)szSourceFile, strlen( szSourceFile ) );

	HeaderOut( 0x00 );
	HeaderOut( 0x00 );
	HeaderOut( 0x00 );

	savedHeaderOffset = nHeader;
	nBodyOffset = nHeader;
	nHeader = updateBodyOffset;
	Header( 0x0B, (char *)&nBodyOffset, 2);
	nHeader = savedHeaderOffset;

	nFileSize = nHeader;

	switch( source )
	{
		case 0:
			hSource = open( szText, O_RDONLY );
			if( hSource == - 1 )
			{
				perror( szText );
				return -1;
			}
			hOut = open( szOut, O_RDWR | O_CREAT | O_TRUNC, 0666 );
			lseek( hOut, nBodyOffset, 0 );
			nBytes = read( hSource, (char *)buffer, sizeof( buffer ) );
			while( nBytes > 0 )
			{
				nFileSize = nFileSize + nBytes;
				write( hOut, (char *)buffer, nBytes );
				for( i=0; i<nBytes; i++ )
					nBodyChecksum = nBodyChecksum + (unsigned int)buffer[i];
				nBytes = read( hSource, (char *)buffer, sizeof( buffer ) );
			}
			close( hSource );
			break;

		case 1:
			hOut = open( szOut, O_RDWR | O_CREAT | O_TRUNC, 0666 );
			lseek( hOut, nBodyOffset, 0 );
			write( hOut, szText, strlen( szText ) );
			for( i=0; i<strlen( szText ); i++ )
				nBodyChecksum = nBodyChecksum + (unsigned int )szText[i];
			nFileSize = nHeader+strlen( szText );
			break;

	}

	savedHeaderOffset = nHeader;
	nHeader = updateBodyChecksum;
	Header( 0x09, (char *)&nBodyChecksum, 2 );
	nHeader = savedHeaderOffset;

	savedHeaderOffset = nHeader;
	nHeader = updateFileSize;
	Header( 0x04, (char *)&nFileSize, 4 );
	nHeader = savedHeaderOffset;

	for( i=0; i<nHeader; i++ )
		nHeaderChecksum=nHeaderChecksum+(unsigned int)header[i];
		
	savedHeaderOffset = nHeader;
	nHeader = updateHeaderChecksum;
	Header( 0x0A, (char *)&nHeaderChecksum, 2 );
	nHeader = savedHeaderOffset;

	lseek( hOut, 0, 0 );
	write( hOut, header, nHeader );
	close( hOut );

	return 0;
}
