/*
 *   Copyright 1992, 1993, 1994 John Melton (G0ORX/N6LYT)
 *              All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
	directory.c

	list pacsat directory

	John Melton
	G0ORX, N6LYT

	4 Charlwoods Close
	Copthorne
	West Sussex
	RH10 3QZ
	England

	INTERNET:	g0orx@amsat.org
			n6lyt@amsat.org
			john@images.demon.co.uk
			J.D.Melton@slh0613.icl.wins.co.uk

	History:

	0.1	Initial version.
	0.2	Added view selection.
	0.3	Fixed selected entry after update.
	0.4	Added Fill button.
*/

#define VERSION_STRING "(version 0.4 by g0orx/n6lyt)"

#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/font.h>
#include <xview/svrimage.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <malloc.h>
#include <dirent.h>
#include "header.h"
#include "ftl0.h"

char myCall[16];
Frame frame;
Panel panel;
Panel_item panel_view;
Panel_item panel_list_item;
int nList = 0;
int view;

unsigned long selectedFileId;

int s;
struct sockaddr_in loc_addr;
struct sockaddr_in rem_addr;

extern void exit( );
void view_notify_proc( Panel_item item, int value, Event *event );
void panel_select( Panel_item item, char * string, caddr_t client_data,
			Panel_list_op op, Event *event );
void panel_quit( void );
void panel_update( void );
void FillFile( void );
void FillDirectory( void );

void LoadDirectory( char * dirName );

main( int argc, char ** argv )
{
	Xv_Font font;
	char title[80];

	xv_init( XV_INIT_ARGS, argc, argv, NULL );

	if( getenv( "MYCALL" ) == (char *)0 )
		strcpy( myCall, "NOCALL" );
	else
		strcpy( myCall, getenv( "MYCALL" ) );

	sprintf( title, "directory %s", VERSION_STRING );
	frame = (Frame)xv_create( (Frame)NULL, FRAME,
				FRAME_LABEL, title,
				NULL );
	font = (Xv_Font)xv_find( frame, FONT,
				FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
				FONT_SIZE, 12,
				NULL );
	panel = (Panel)xv_create( frame, PANEL,
				PANEL_LAYOUT, PANEL_VERTICAL,
				XV_FONT, font,
				NULL );

	xv_set( panel, PANEL_LAYOUT, PANEL_HORIZONTAL, NULL );

	(void)xv_create( panel, PANEL_BUTTON,
		PANEL_FONT, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
		PANEL_LABEL_STRING, "Quit",
		PANEL_NOTIFY_PROC, panel_quit,
		XV_FONT, font,
		NULL );

	(void)xv_create( panel, PANEL_BUTTON,
		PANEL_FONT, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
		PANEL_LABEL_STRING, "Update",
		PANEL_NOTIFY_PROC, panel_update,
		XV_FONT, font,
		NULL );

	(void)xv_create( panel, PANEL_BUTTON,
		PANEL_FONT, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
		PANEL_LABEL_STRING, "Fill Directory",
		PANEL_NOTIFY_PROC, FillDirectory,
		XV_FONT, font,
		NULL );

	(void)xv_create( panel, PANEL_BUTTON,
		PANEL_FONT, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
		PANEL_LABEL_STRING, "Fill File",
		PANEL_NOTIFY_PROC, FillFile,
		XV_FONT, font,
		NULL );

	panel_view = (Panel_item)xv_create( panel, PANEL_CHOICE_STACK,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, view_notify_proc,
		PANEL_LABEL_STRING, "View",
		PANEL_CHOICE_STRINGS, "All",
					"My Mail",
					"Broadcast",
					"EIS",
					NULL,
		PANEL_VALUE, 0,
		NULL );

	xv_set( panel, PANEL_LAYOUT, PANEL_VERTICAL, NULL );

	font = (Xv_Font)xv_find( panel, FONT,
				FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
				NULL );

	(void)xv_create( panel, PANEL_MESSAGE,
		XV_WIDTH, 600,
		XV_FONT, font,
		PANEL_LABEL_STRING,
		"        Id Date/Time From     To         Size Title",
		NULL );

	panel_list_item = (Panel_item)xv_create( panel, PANEL_LIST,
		PANEL_LIST_DISPLAY_ROWS, 10,
		PANEL_LIST_WIDTH, 600,
		PANEL_READ_ONLY, 1,
		XV_FONT, font,
		PANEL_NOTIFY_PROC, panel_select,
		NULL );

	window_fit( panel );
	window_fit( frame );

	/* setup to talk to xpb */
	memcpy( (char *)&loc_addr, 0, sizeof( rem_addr ) );
	loc_addr.sin_family = AF_INET;
	loc_addr.sin_addr.s_addr= INADDR_ANY;
	loc_addr.sin_port = htons( 0 );

	s = socket( AF_INET, SOCK_DGRAM, 0 );
	if( s == -1 )
	{
		perror( "socket" );
	}

	if( bind( s, (struct sockaddr *)&loc_addr, sizeof( loc_addr ) ) == -1 )
	{
		perror( "bind" );
	}

	memcpy( (char *)&rem_addr, 0, sizeof( rem_addr ) );
	rem_addr.sin_family = AF_INET;
	rem_addr.sin_port = htons( 5100 );
	rem_addr.sin_addr.s_addr = htonl( 0x7f000001 );

	view = 0;
	panel_update( );

	xv_main_loop( frame );
}

void view_notify_proc( Panel_item item, int value, Event *event )
{
	view = value;	
	panel_update( );
}

void panel_select( Panel_item item, char * string, caddr_t client_data,
			Panel_list_op op, Event *event )
{
	switch( op )
	{
	case PANEL_LIST_OP_SELECT:
		selectedFileId = (unsigned long)client_data;
		break;
	case PANEL_LIST_OP_DESELECT:
		selectedFileId = 0;
		break;
	}
}

void panel_quit( )
{
	xv_destroy_safe( frame );
}

void panel_update ( )
{
	DIR		*pDir;
	struct dirent	*pDirent;
	int i;

	xv_set( frame, FRAME_BUSY, 1, NULL );
	xv_set( panel_list_item, XV_SHOW, 0, NULL );
	xv_set( panel_list_item, PANEL_CHOOSE_ONE, FALSE, NULL );
	xv_set( panel_list_item, PANEL_CHOOSE_NONE, TRUE, NULL );

	/* flush out the current list */
	for( ; nList>0; nList-- )
		xv_set( panel_list_item, PANEL_LIST_DELETE, 0, NULL );

	/* walk through the directory files */
	pDir = opendir( "." );
	while( (pDirent = readdir( pDir )) != NULL )
	{
		if( strncmp( pDirent->d_name, "pb__", 4 ) == 0 )
			LoadDirectory( pDirent->d_name );
	}
	closedir( pDir );

	if( nList )
	{
		xv_set( panel_list_item, PANEL_LIST_SORT, PANEL_REVERSE, NULL );
		xv_set( panel_list_item, PANEL_CHOOSE_NONE, FALSE, NULL );
		xv_set( panel_list_item, PANEL_CHOOSE_ONE, TRUE, NULL );
		xv_set( panel_list_item, PANEL_LIST_SELECT, 0, TRUE, NULL );
		selectedFileId = xv_get( panel_list_item, PANEL_LIST_CLIENT_DATA, 0, NULL );
	}
	xv_set( panel_list_item, XV_SHOW, 1, NULL );
	xv_set( frame, FRAME_BUSY, 0, NULL );
}

void LoadDirectory( char * dirName )
{
	int hDir;
	int fileLength;
	int offset;
	char * pBuffer;
	static struct tm * GMT;
	char szTemp[128];
	int headerSize;
	HEADER *pHeader;
	int j;
	int display;
	char *p;

	/* open the directory file */
	hDir = open( dirName, O_RDONLY );
	if( hDir == -1 )
	{
		perror( dirName );
		return;
	}

	/* get the file length */
	fileLength = lseek( hDir, 0, 2 );
	pBuffer = malloc( fileLength );
	lseek( hDir, 0, 0 );

	/* read in the complete file */
	read( hDir, pBuffer, fileLength );

	/* close the file */
	close( hDir );

#ifdef DEBUG
printf( "LoadDirectory: filesize:%d\n", fileLength );
#endif

	/* walk through the file extracting the headers */
	offset = 0;
	while( offset < fileLength )
	{
		pHeader = ExtractHeader( &pBuffer[offset], fileLength-offset, &headerSize );

		if( pHeader == NULL )
		{
			printf( "invalid header entry (at offset %d (0x%X))\n", offset, offset );
			offset = fileLength;
		}
		else
		{
			/* truncate the source and destination */
			j = 0;
			while( isalnum( pHeader->source[j] ) )
				j++;
      			pHeader->source[j] = '\0';
			j = 0;
			while( isalnum( pHeader->destination[j] ) )
				j++;
      			pHeader->destination[j] = '\0';

			GMT = gmtime( &pHeader->uploadTime );

			if( strlen( pHeader->title ) == 0 )
				sprintf( szTemp, "%8x %02d%02d/%02d%02d %-8s %-8s %6d %-40s",
					pHeader->fileId,
					GMT->tm_mon+1, GMT->tm_mday, GMT->tm_hour, GMT->tm_min,
					pHeader->source,
					pHeader->destination,
					pHeader->fileSize,
					pHeader->fileName );
			else
				sprintf( szTemp, "%8x %02d%02d/%02d%02d %-8s %-8s %6d %-40s",
					pHeader->fileId,
					GMT->tm_mon+1, GMT->tm_mday, GMT->tm_hour, GMT->tm_min,
					pHeader->source,
					pHeader->destination,
					pHeader->fileSize,
					pHeader->title );


			if( headerSize > pHeader->bodyOffset )
				offset += headerSize;
			else
				offset += pHeader->bodyOffset;

			p = pHeader->source;
			while( *p )
			{
				if( islower( *p ) )
					*p=toupper( *p );
				p++;
			}

			p = pHeader->destination;
			while( *p )
			{
				if( islower( *p ) )
					*p=toupper( *p );
				p++;
			}

			switch( view )
			{
				case 0:
					display = 1;
					break;
				case 1:
					if( (strcmp( myCall, pHeader->source ) == 0)
						|| (strcmp( myCall, pHeader->destination ) == 0) )
						display = 1;
					else
						display = 0;
					break;
				case 2:
					if( strcmp( "ALL", pHeader->destination ) == 0 )
						display = 1;
					else
						display = 0;
					break;
				case 3:
					if( strcmp( "EIS", pHeader->source ) == 0 )
						display = 1;
					else
						display = 0;
			}
			if( display )
			{
				xv_set( panel_list_item, PANEL_LIST_INSERT, nList, NULL );
				xv_set( panel_list_item, PANEL_LIST_STRING, nList, szTemp, NULL );
				xv_set( panel_list_item, PANEL_LIST_CLIENT_DATA, nList, pHeader->fileId, NULL );
				nList++;
			}
			free( pHeader );
#ifdef DEBUG
printf( "entry: %s\n", szTemp );
#endif
		}
	}
}

void FillFile( )
{
	if( sendto( s, (char *)&selectedFileId, sizeof( selectedFileId ), 0, (struct sockaddr *)&rem_addr, sizeof( rem_addr ) ) == -1)
	{
		perror( "sendto" );
	}
}

void FillDirectory( )
{
	unsigned long id = 0;

	if( sendto( s, (char *)&id, sizeof( id ), 0, (struct sockaddr *)&rem_addr, sizeof( rem_addr ) ) == -1)
	{
		perror( "sendto" );
	}
}
