		   ---------------------------
		   -- Byte Magazine's       --
		   -- Prime Sieve Benchmark --
		   ---------------------------

without type_check -- makes no difference

constant BATCH = 5
constant BENCH_TIME = 15

constant SIZE = 8191, 
	 ON  = 1, 
	 OFF = 0

sequence flags 

function sieve()
    integer prime, start, count, still_prime

    count = 0
    flags = repeat(ON, SIZE)
    for i = 1 to SIZE do
        still_prime = flags[i]
        if still_prime then
  	    prime = i + i
	    prime = prime + 1 
	    -- printf(1, "%d ", prime)
	    start = prime + i
	    for k = start to SIZE by prime do
		flags[k] = OFF
	    end for 
	    count = count + 1
	end if
    end for
    return count
end function

atom t, cycles

puts(1, "prime sieve benchmark ...\n")
cycles = 0
t = time()
while time() < t + BENCH_TIME do
    for iter = 1 to BATCH do
        if sieve() != 1899 then
            puts(2, "whoops!\n")
        end if
    end for
    cycles = cycles + BATCH
end while
t = time() - t
printf(1, "%6.1f sieves per second\n", cycles / t)

