		----------------
		-- mouse test --
		----------------
-- This is a very simple program to demonstrate the get_mouse() built-in
-- function. No call is made to mouse_events(), so by default all events are
-- reported by get_mouse(). 

include mouse.e
include graphics.e

sequence vc
vc = video_config()
if graphics_mode(17 + vc[VC_COLOR]) then -- 640x480 (16 colors)
    puts(1, "Can't get good graphics mode\n")
    abort(1)
end if 
vc = video_config()

procedure beep()
    atom t
    sound(500)
    t = time()
    while time() < t+0.07 do
    end while
    sound(0)
end procedure

constant origin = {vc[VC_XPIXELS]/2, vc[VC_YPIXELS]/2}

procedure try_mouse()
    integer color
    object event

    color = 14
    while 1 do
    	event = get_mouse()
    	if sequence(event) then
	    printf(1, "event: %d, x:%d, y:%d       \r", event)

	    if event[1] = MOVE then
		mouse_pointer(0)
		draw_line(color, {origin, {event[2], event[3]}}) 
		mouse_pointer(1)

	    elsif event[1] = LEFT_DOWN then
		beep()
	        color = color + 1
		if color > 15 then
		    color = 0
		end if 

	    elsif event[1] = LEFT_UP then
		beep()
				
	    elsif event[1] = RIGHT_DOWN or 
		  event[1] = MIDDLE_DOWN then
		exit
	    end if
	end if
    end while
end procedure

try_mouse()

if graphics_mode(-1) then
end if
