# ANIMAWK2.AWK  v1.0  gjpateman  5/4/94

BEGIN {
  frames = 30                  # total number of frames in the FLI, duh!
  startf = 7                   # def = 1, change to preview/continue job
  stepf  = 1                   # def = 1, change to preview
  endf   = 8                   # def = frames, change to preview

  split( ARGV[1], str, "." )   # discard the ".POV" extension if supplied
  Scene    = str[1]            # POV file to animate
  POVfile  = Scene ".POV"      # add ".POV" to scene file name
  ANIfile  = Scene ".ANI"      # "#include" this file in the .POV scene file
  FLIfile  = Scene ".FLI"      # note: use ".FLC" if larger than 320 x 200 TGAs
  LOGfile  = Scene ".LOG"      # keep logs from all frames in one file

  DTAopts  = " /r1 /s5 "       # r1 = 320 x 200 FLI, s5 = speed 5

  Cr = 10   # major radius of the constant-position torus
  d  = 1.5  # distance from orbiting torus to the constant-position torus

  pi = atan2( 0, -1 )
  circumf = pi * 2
  onethird = circumf / 3    
  twothirds = circumf * 2 / 3

  for ( f = 1; f <= frames; f += 1 )   # loop regardless of start/end/step vals
  {
    T = onethird * f / frames    # 0 to 2pi/3 radians

    T1x = d * cos( T ) + Cr
    T2x = d * cos( T + onethird ) + Cr
    T3x = d * cos( T + twothirds ) + Cr

    T4x = 2 * d * cos( T ) + Cr
    T5x = 2 * d * cos( T + onethird ) + Cr
    T6x = 2 * d * cos( T + twothirds ) + Cr

    T7x = 3 * d * cos( T ) + Cr
    T8x = 3 * d * cos( T + onethird ) + Cr
    T9x = 3 * d * cos( T + twothirds ) + Cr

    T1y = d * sin( T )
    T2y = d * sin( T + onethird )
    T3y = d * sin( T + twothirds )

    T4y = 2 * d * sin( T )
    T5y = 2 * d * sin( T + onethird )
    T6y = 2 * d * sin( T + twothirds )

    T7y = 3 * d * sin( T )
    T8y = 3 * d * sin( T + onethird )
    T9y = 3 * d * sin( T + twothirds )

    if ( ( f >= startf ) && ( f <= endf ) && ( ( f - startf ) % stepf == 0 ) )
    {
      printf "Creating %s for frame #%d of %d\n", ANIfile, f, frames

      printf "#declare Cr = %f\n", Cr  >  ANIfile
      printf "#declare T1x = %f\n", T1x  >> ANIfile
      printf "#declare T2x = %f\n", T2x  >> ANIfile
      printf "#declare T3x = %f\n", T3x  >> ANIfile

      printf "#declare T4x = %f\n", T4x  >> ANIfile
      printf "#declare T5x = %f\n", T5x  >> ANIfile
      printf "#declare T6x = %f\n", T6x  >> ANIfile

      printf "#declare T7x = %f\n", T7x  >> ANIfile
      printf "#declare T8x = %f\n", T8x  >> ANIfile
      printf "#declare T9x = %f\n", T9x  >> ANIfile

      printf "#declare T1y = %f\n", T1y  >> ANIfile
      printf "#declare T2y = %f\n", T2y  >> ANIfile
      printf "#declare T3y = %f\n", T3y  >> ANIfile

      printf "#declare T4y = %f\n", T4y  >> ANIfile
      printf "#declare T5y = %f\n", T5y  >> ANIfile
      printf "#declare T6y = %f\n", T6y  >> ANIfile

      printf "#declare T7y = %f\n", T7y  >> ANIfile
      printf "#declare T8y = %f\n", T8y  >> ANIfile
      printf "#declare T9y = %f\n", T9y  >> ANIfile

      close( ANIfile )

# exit # dbug line

      printf "Rendering TGA frame #%d of %d ...\n", f, frames
      TGAfile = sprintf( "%0.4d.TGA", f )  # 0001.TGA, 0002.TGA, etc
      # POV options set in POVRAY.DEF in current directory
      system("POVRAY.EXE +i" POVfile " +o" TGAfile)
    }
  }

  printf "Creating the FLI ...\n"
  system("DTA.EXE " DTAopts " /o" FLIfile " *.TGA")

  printf "Playing the animation file ...\n"
  system("DFV.EXE " FLIfile)

  exit
}
