/////////////////////////////////////////////////////////////////////////////
//
// V.U.R.T.U.A.L.   INTERVUR MODULE   (C)opyright 1994  by  Robert J. Tiess
//
//
// Virtually Unlimited Resources Transcending Ultimately All Limitations
//
//
// This progrmam interprets programs composed in VURTUAL.
//
//
// The Source Code Explained:
//
// 		This source code provides the skeleton for what could be an
//		interesting, alternative, and highly personalized programming
//		environment.  VURTUAL is a interpreted language, like BASIC.
//		It cannot produce executable code or stand-alone programs.  To
//		create programs for VURTUAL to process you must use EDIT, NOTEPAD,
//		or any other editor that can save in pure ASCII.
//
//		The philosophy and programming techniques of VURTUAL can be perused
//		in the text file "VURTUAL.WHY"--this will explain what VURTUAL is
//		all about, how to make programs for it, and why the hell you might
//		waste your time dabbling with YET ANOTHER LANGUAGE.  But then, can
//		your language interface with ALL OTHER COMPUTER LANGUAGES AND
//		PROGRAMS?  Can your language change?  Can your language produce
//		variables larger than 64k?  One megabyte?  Ten megabytes?  Twenty...?
//		How about your run-time code?  Typically, compiled programs range
//		anywhere from 50k to several hundred kilobytes.  The average VURTUAL
//		program occupies 200 to 10000 bytes.  BYTES!
//
//
//		COMMANDS:
//
//		There are only several native commands known to VURTUAL:
//
//      beginprogam:		This marks the beginning of your program
//		newscreen:			Erases screen/puts cursor in upper left corner
//		display,
//		enddisplay:			Display whatever you write between these two cmds
//		variable,
//		endvariable:		Declare a variable & store it in its own .VAR file
//		viewvariable:		Display the contents of a variable file
//		showreturns:		Display the contents of a return file
//		do, doend:			This is the VURTUAL equivalent of the FOR LOOP
//		if, endif:			Define a simple conditional block
//		goto:				Jump to another location in the program
//		userinput:			Wait for user to press a key, store input
//		commentary,
//		endcommentary:		Define a section of comments (ignored by INTERVUR)
//		exitprogram:		Terminate program immediately
//		endprogram:			This marks the end of your program
//
//		[Do not append colons or commas to these commands.]
//
//
//		Before you attempt to do anything in VURTUAL, do yourself a favor
//		and read VURTUAL.WHY to learn how to implement these commands and
//		how to extend VURTUAL's "vocabulary" using the computer language
//		of your choice.
//
//		I retain the copyright to this work but do not ask for monetary
//		reimbursement.  What I DO request is that, if you plan to upload
//		VURTUAL anywhere (as I hope you will), please upload this file
//		and the supportive files in this .ZIP archive as they were in their
//		original, unchanged state.  This way, people you know and interact
//		with and people you will never meet can all begin with the same
//		tabula rasa [blank tablet] that you received and encounter VURTUAL
//		as it was intended to be: anything YOU can make it become.
//
/////////////////////////////////////////////////////////////////////////////


#include <fstream.h>
#include <iostream.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <process.h>


// Functions REMSPACESL and REMSPACESR were derived from my SUPRASTRING C++
// Library.  If you are interested in gaining powerful string manipulation
// to use in your own applications, look for this file and download it.
// It is called, SUPRASTR.ZIP, and will quickly prove to be an invaluable
// weapon in your C++ programming arsenal.

char * RemSpacesL(char a[])
{
	if (a==NULL) return NULL;
	int x, y=0, z=0;
	for (x=0; x<strlen(a)+1; x++)
	{
		if (a[x]==32 || a[x]==9) y++;
		if ((a[x]>32 || a[x]<32) && a[x]!=9) break;
	}
	if (y>0)
	{
		for (x=y; x<strlen(a)+1; x++)
		{
			a[z]=a[x];
			z++;
		}
		a[z]='\0';
	}
	return a;
}

char * RemSpacesR(char a[])
{
	if (a==NULL) return NULL;
	int x, y=0;
	strrev(a);
	for (x=0; x<strlen(a)+1; x++)
	{
		if (a[x]==32 || a[x]==9) y++;
		if ((a[x]>32 || a[x]<32) && a[x]!=9) break;
	}
	strrev(a);
	a[(strlen(a)-y)]='\0';
	return a;
}

char * RemAllSpaces(char a[])
{
	return RemSpacesL(RemSpacesR(a));
}

void cs(char a[])
{
	strlwr(RemAllSpaces(a));
}

int main(int argc, char * argv[])
{
	clrscr();

	//Copy argv[0] (path\filename) and append .VUR (main file) extension
	char vmainfile[14];
	stpcpy(vmainfile,argv[1]);
	strcat(vmainfile,".VUR"); // VURTUAL source text file

	//Display program name, date work was copyrighted
	cout << "V.U.R.T.U.A.L.  (C)opyright 1994   Robert J. Tiess\n\n"
	<< "Interpreting " << vmainfile << "...\n\n\n";

	// Define the resident system command strings:
	char *beg="beginprogram";
	char *cls="newscreen";
	char *dol="do";
	char *den="doend";
	char *sdisp="display";
	char *sdispend="enddisplay";
	char *viewvariable="viewvariable";
	char *showreturns="showreturns";
	char *ifbegin="if";
	char *doesnotequal="does not equal";
	char *morethan="is more than";
	char *lessthan="is less than";
	char *ifend="endif";
	char *gotocmd="goto";
	char *exitprogram="exitprogram";
	char *endprogram="endprogram";
	char *commentary="commentary";
	char *commentaryend="endcommentary";
	char *userinput="userinput";
	char *variable="variable";
	char *endvariable="endvariable";
	char *cmdreturn="return";
	char *value="value";
	char labelname[256];
	char var1,var2,ret1,ret2,uip;
	long number1, number2;
	unsigned long fileposition,beginposition;

	// Define flags and counters used to process system commands
	int keep=0,f,notequal,comptype,comptype2,
		conditional,varfiles=0,retfiles=0,
		screenlines=0,vr;

	// If programmer specifies /keep option, .VAR and .RET files generated
	// in this session will not be deleted until the next time INTERVUR is
	// run without this directive.
	if (!strcmp(argv[2],"/keep")) keep=1;

	// Define the input buffer lines
	char inputline[255],inputline2[255],inputline3[255];

	// Define file-position containers for DO loop;
	unsigned long filpos,dolo[20];

	// Define counters for Do loop, If blocks, arguments, etc.
	int doloop=0,dotimes[20],doloopnum,argumen,success,c,retcnt,x,y,z;

	// Define #system paramaters to be passed to external command
	char syscmd[8][16];


/////////////////////////  INTERPRETER BEGINS HERE  ////////////////////////

	//access filename specified in argv[1] from the command line
	ifstream f1(vmainfile);
	// if the file is not found, terminate with error message
	if (!f1)
	{
		cout << "File access error.  Check spelling.\n";
		exit(1);
	}
	// read first line of file to initialize LocateBeginning loop.
	// this is how VURTUAL programs can actually contain pages of comments
	// without the need for REM /* */ or // (comment) statements
	f1.getline(inputline, 255,'\n');

	LocateBeginning:
	cs(inputline);
	// Does line == "beginprogram" ?  If not, get another line.
	if (!(!strcmp(inputline,beg)))
	{
		f1.getline(inputline, 255,'\n');
		if (!f1)
		{
			cout << "BEGINPROGRAM not found!\n";
			exit(1);
		}
		goto LocateBeginning;
	}
	beginposition=f1.tellg();

///////////////////////// The Central Interpretive Loop /////////////////////


	ParsingLoop:
		// Extract a line of input from the .VUR file to be interpreted
		f1.getline(inputline, 255,'\n');

		// Erase leading/trailing spaces from inputline and convert to
		// lowercase so the parser can correctly identify the command
		cs(inputline);
		if (!f1)
		{
			cout << "ENDPROGRAM command not found!\n";
			exit(1);
		}

		// You will see the above (!f1) and this if(strlen()) line below
		// throughout the parser routines.  They exist simply to throw
		// away empty/null lines and to advance the interpreter through
		// the program.  If the anticipated command is NOT found, INTERVUR
		// halts all processing and lets you know it.
		if(strlen(inputline)==0) goto ParsingLoop;

		/////////////////////////////////////////////////////////////////////
		//
		// COMMENTARY/ENDCOMMENTARY
		//
		// Is this a COMMENTARY block?  If so, ignore all following lines
		// until ENDCOMMENTARY is detected, then return to the top of the
		// Parsing Loop to examine the next line.
		//
		// You may place COMMENTARY blocks all throughout your program.
		// You may NOT, however, put commentaries in the middle of a command--
		// just as you wouldn't think of putting a REM statement in the
		// middle of a BASIC command.  Place COMMENTARY blocks before or
		// after commands.  Examine the two examples provided below:
		//-------------------------------------------------------------------
		// beginprogram
		//
		// commentary
		//		I can put my comments here
		// endcommentary
		// variable
		//		wrong
		// commentary
		// 		There is something wrong here.
		//		Do you see it?
		// endcommentary
		// endvariable
		//
		// endprogram
		//-------------------------------------------------------------------
		// The above is an example of where you should NOT put a commentary.
		// The first comment/endcommentary is fine and will be properly
		// ignored by INTERVUR.  The second instance, however, is wrong.
		// What will happen?  The above variable/endvariable definition
		// for "wrong" will include the words, "commentary," the two lines
		// of text, and "endcommentary."  These will appear in your variable
		// definition, since the variable module assigns EVERYTHING after
		// the variable, "wrong," to the variable, until "endvariable" is
		// reached.  Tracking these sort of errors are difficult, even in
		// professional languages, because the program looks good to the
		// computer, even though there is an obvious error.  INTERVUR,
		// like any other interpreter/compiler, can only check against
		// syntax.  How would you catch an error like the one above?  When
		// you run INTERVUR, use the /keep directive so that INTERVUR doesn't
		// erase the variables it created during the session.  From the
		// command line, type "DIR *.var" to list all variables.  If the
		// variables are small, you can use the TYPE command to view them.
		// If they are larger, use the TYPE | MORE option or use EDIT.
		// For example, you would type "TYPE wrong.var" and the contents of
		// the above variable, wrong, would appear.  If you see something
		// that shouldn't be in that variable's definition, you can return
		// to the editor and set your program straight.
		/////////////////////////////////////////////////////////////////////

		if (!strcmp(inputline,commentary))
		{
			EndofComments:
				f1.getline(inputline2, 255, '\n');
				cs(inputline2);
				if (!f1)
				{
					cout << "ENDCOMMENTARY not found!\n";
					exit(1);
				}
				if (!(!strcmp(inputline2,commentaryend))) goto EndofComments;
		}

		// Is this line a Label Definition, if so, ignore, goto top of loop
		if (inputline[strlen(inputline)-1]==58) goto ParsingLoop;

		// Is this line a GOTO command, if so, get LABEL info and jump
		if (!strcmp(inputline,gotocmd)) // GOTO command, find label
		{
			Again:
			f1.getline(inputline, 255, '\n');// get Label name, search
			cs(inputline);
			if (!f1)
			{
				cout << "GOTO LABEL not found!\n";
				exit(1);
			}
			if (strlen(inputline)==0) goto Again;

			/////////////////////////////////////////////////////////////////
			//
			// GOTO
			//
			// Branching command.  Allows you to jump to other parts of
			// your VURTUAL program.  Same as BASIC or C's GOTO.
			//
			//---------------------------------------------------------------
			//		beginprogram
			//
			//			display
			//				this program illustrates the goto routine
			//			displayend
			//			goto
			//				labelA:
			//
			//			labelB:
			//				display
			//					this code will be skipped
			//				displayend
			//
			//			labelA:
			//				display
			//					goto has arrived at its proper destination
			//				displayend
			//
			//		endprogram
			//---------------------------------------------------------------
			//
			// GOTO goes to the "beginprogram" mark and works its way down.
			// Since the same label can be used throughout a program in
			// reference to GOTO's, the problem is to detect the TRUE
			// label (will the real label please stand up?)  This is
			// accomplished by a detection routine built-in here to
			// ignore all GOTO's, keeping INTERVUR from getting confused.
			/////////////////////////////////////////////////////////////////


			// GOTO "beginprogram" line of file
			f1.seekg(beginposition,ios::beg);

			// Preset "found label" flag to zero, assuming the destination
			// label will not be found or is mispelled, causing program
			// to terminate with a "Label x not found" error.
			f=0;

			// While f1 (the source file) has not reached EOF, search
			while(f1)
			{
				// Retrieve possible label for review
				Again2:
				f1.getline(inputline2,255,'\n');
				cs(inputline2);
				if (!strcmp(inputline2,gotocmd))
				{
					GetFalseLabel:
					f1.getline(inputline2,255,'\n');
					cs(inputline2);
					if (strlen(inputline2)==0) goto GetFalseLabel;
					goto Again2;
				}
				if (!f1)
				{
					cout << "LABEL \"" << inputline << "\" not found!\n";
					exit(1);
				}
				if (strlen(inputline2)==0) goto Again2;

				// Remember the current file position
				filpos=f1.tellg();

				// Compare line with label to be found.  The && is the
				// logical operator, AND.  This is the conditional expression
				// of what we saw in the example program above:
				// if label == input line AND this is not the GOTO line,
				// make the jump to the new file position and return
				// control to the parser module.
				if (!strcmp(inputline,inputline2))
				{
					// Increment "found label" flag to 1
					f++;

					// Terminate WHILE loop and advance to next conditional
					break;
				}
			}
			if (f)
			{

				// If the label has been found, jump to its new file
				// address (measured in bytes from the BEGINNING of the .VUR
				// file.
				f1.seekg(filpos,ios::beg);
				goto ParsingLoop;
			}

			// If label has NOT been found, report it and terminate
			cout << "LABEL \"" << inputline << "\" NOT FOUND!\n";
			exit(1);
		}

		// Is this a DO block?  If so, process it
		if (!strcmp(inputline,dol))
		{
				////////////////////////////////////////////////////////////
				// This routine allows for NESTED DO LOOPS (DO LOOPS
				// inside of DOLOOPS).  To do this requires two arrays,
				// dolo[] and dotimes[], and a counter, DOLOOP.
				//
				// DOLO[] is the file-position array (defined as an
				// unsigned long in anticipation of files that could
				// conceivably get that large).
				//
				// DOTIMES[] is the internal DO counter array for each
				// DO block.  Combined with DOLOOP (an int), DOTIMES[]
				// keeps track of how many iterations are left in each
				// DO block.
				//
				// This is actually HALF of the DO code.  For the rest
				// of it, you must go almost to the END of INTERVUR.CPP,
				// where the DOEND routine takes action
				//
				////////////////////////////////////////////////////////////

				// Insert current file position in DOLO[] array
				dolo[doloop]=f1.tellg();

				// Retrieve DO TIMES #
				Again3:
				f1.getline(inputline,255,'\n');
				cs(inputline);
				if (!f1)
				{
					cout << "DO TIMES # not found\n";
					exit(1);
				}
				if (strlen(inputline)==0) goto Again3;

				// Convert string to integer, place in DOTIMES[] array
				dotimes[doloop]=atoi(inputline);

				// Increment doloop counter, the return control to Parser--
				// temporarily, that is: until DOEND is detected
				doloop++;
				goto ParsingLoop;
		}

		// Is this a DISPLAY command, if so process
		if (!strcmp(inputline,sdisp))
		{
			//////////////////////////////////////////////////////////////
			//
			// DISPLAY & DISPLAYEND:
			//
			// Since screen output is critical in ANY language, I decided
			// it would be best to give VURTUAL the ability to do so without
			// the complexity of other languages.  You do not need quotes,
			// but if you use them, they appear in the output.  Examine the
			// following example:
			//
			//		display
			//
			//			"And you can quote me!"
			//
			//		displayend
			//
			// Since EVERYTHING between these two commands gets displayed,
			// expect to extra lines in the output:  the lines skipped after
			// display and before displayend get displayed, too.
			//
			// You might have noticed cs(inputline)'s running throughout this
			// file.  That is a "string cleaning" function I created to
			// remove all leading and trailing spaces from each line.  This
			// was important for three reasons:	 To promote legibility in
			// VURTUAL programs, to create a "structured-looking" environment,
			// and to allow you to use the display/displayend commands from
			// wherever you are horizontally in a document.  INTERVUR
			// actually sees the above code as:
			//
			// display
			//
			// "And you can quote me!"
			//
			// displayend
			//
			// By doing so, your VURTUAL programs will have the look and
			// feel of a structured language rather than having INTERVUR
			// force you to left-justify every command.
			//
			////////////////////////////////////////////////////////////////

			ContinueDisplay:

			// Get a line to initialize DISPLAY loop
			f1.getline(inputline2,255,'\n');
			// Remove unnecessary spaces
			RemAllSpaces(inputline2);
			if (!f1)
			{
				cout << "ENDDISPLAY command not found!\n";
				exit(1);
			}

			// Has the "displayend" command appeared yet? If not, continue...
			if(!(!strcmp(inputline2,sdispend)))
			{
				cout << inputline2 << "\n";
				goto ContinueDisplay;
			}
		}

		////////////////////////////////////////////////////////////////////
		//
		// DOEND:
		//
		// This is the second half of the DO/DOEND processing code.
		//
		// DOEND had to be partially dissociated from DO because the
		// Parser has to be able to process the commands in the DO loop
		// before it can end the loop.  Premature exiting from a DO loop
		// is possible through the IF conditional.
		//
		// Take the following program which accepts three words from a
		// user.  The DO loop is set for 3 iterations but can be exited
		// early if the user types "exit":
		//------------------------------------------------------------------
		// beginprogram
		//
		//		variable
		//			exitprog
		//				exit
		//		endvariable
		//
		//		display
		//			Please enter three words.
		//
		//		displayend
		//
		//		do
		//			3
		//
		//			userinput
		//				keyboard
		//			if
		//				variable
		//					keyboard
		//				equals
		//					exitprog
		//				goto
		//					EndofProgram:
		//			endif
		//		doend
		//
		//	EndofProgram:
		//
		//	endprogram
		//-------------------------------------------------------------------
		// If the user does not enter "exit," the program will terminate
		// upon exhausting DO's limit of 3 iterations.
		/////////////////////////////////////////////////////////////////////

		// Is this a DOEND command? If so, process.
		if (!strcmp(inputline,den))
		{

			// Back-out one level from the DO LOOP nest
			dotimes[doloop-1]--;

			// If there are more iterations in THIS DO LOOP to perform,
			// move to file position stored in dolo[] array, return to Parser
			if (dotimes[doloop-1]>0)
			{
				f1.seekg(dolo[doloop-1], ios::beg);
			}
			else
			{
				if (doloop>0) doloop--;  // If not, decrease doloop counter
			}
		}

		/////////////////////////////////////////////////////////////////////
		//
		// IF/ENDIF
		//
		// Conditions are an integral aspect in a language's ability to
		// handle data, react to changes in variables, direct the user and/or
		// the computer, and prevent things from happening.
		//
		// VURTUAL's present IF/ENDIF pivots on four possibile outcomes:
		// "equals," "does not equal," "is more than," "is less than"
		//
		// Because all variables and command returns are actually files,
		// they are compared as files, byte by byte.  This is also to say
		// that every variable in VURTUAL is a string and is treated as
		// such by IF.
		//
		// The following represents the syntactical flow of VURTUAL's IF:
		//
		//		if
		//			(variable/return comparison type)
		//				(variable/return name)
		//					(conditional)
		//			(variable/return comparison type)
		//				(variable/return name)
		//			(perform action(s))
		//		endif
		//
		// The "variable/return comparison type" simply specifies whether
		// IF should be comparing variable files (.VAR) or command-return
		// files (.RET).  The following code shows how two variables would
		// be defined and compared:
		//-------------------------------------------------------------------
		// beginprogram
		//
		//		variable
		//			apples
		//				fruit
		//		endvariable
		//
		//		variable
		//			oranges
		//				fruit
		//		endvariable
		//
		//		if
		//			variable
		//				apples
		//			equals
		//			variable
		//				oranges
		//			display
		//				You CAN compare apples and oranges!
		//			displayend
		//		endif
		//
		// endprogram
		//------------------------------------------------------------------
		// The variables, Apples and Oranges, are both defined as "fruit"
		// and will trigger a EQUALS/TRUE response, causing IF to execute
		// the display routine.  If we were to define Apples as "red," IF
		// would return a DOESNOTEQUAL/FALSE response, jumping to the
		// ENDIF statement and returning full control to INTERVUR.
		//------------------------------------------------------------------
		// For NUMERICAL operations, the IS MORE THAN and IS LESS THAN
		// conditionals provide a way to mathematically assess a variable:
		//------------------------------------------------------------------
		// beginprogram
		//
		// 		variable
		//			number1
		//			1000
		//		endvariable
		//
		//		variable
		//			number2
		//			2000
		//		endvariable
		//
		//		if
		//			variable
		//			number1
		//				is less than
		//			variable
		//			number2
		//				display
		//					1000 < 2000
		//				enddisplay
		//		endif
		//
		// endprogram
		//------------------------------------------------------------------
		// IF is not restricted to variable comparisons.  There will be
		// times when you will wish to check a variable against what is
		// called a CONSTANT VALUE:
		//------------------------------------------------------------------
		// beginprogram

		// Get User Response:
		//
		//	   display
		//	   		Type 'exit' to exit program
		//	   enddisplay
		//
		//	   userinput
		//			key
		//
		//	   if
		//			variable
		//			key
		//				does not equal
		//			value
		//			exit
		//			goto
		//				Get User Response:
		//	   endif
		//
		// endprogram
		/////////////////////////////////////////////////////////////////////

		// Is this an IF command?  If so, process
		if (!strcmp(inputline,ifbegin))
		{
			Again5:
			// Is this a .VAR variable file or a .RET command return file?
			f1.getline(inputline,255,'\n');
			cs(inputline);
			if (!f1)
			{
				cout << "VARIABLE/RETURN/VALUE command not found!\n";
				exit(1);
			}
			if (strlen(inputline)==0) goto Again5;

			// Make .VAR the default
			comptype=1;

			// If this is a .RET comparison, set comtype to 0
			if (!strcmp(inputline,cmdreturn)) comptype=0;

			// IF THIS IS A VALUE CONSTANT EXPRESSION, set comtype to 2
			if (!strcmp(inputline,value)) comptype=2;

			// Is the next item a variable or a command return file?
			Again6:
			f1.getline(inputline,255,'\n');
			cs(inputline);
			if (!f1)
			{
				cout << "VARIABLE/RETURN NAME/VALUE not found!\n";
				exit(1);
			}
			if (strlen(inputline)==0) goto Again6;

			// What sort of comparison will we be performing?
			Again7:
			f1.getline(inputline2,255,'\n');
			cs(inputline2);
			if (!f1)
			{
				cout << "COMPARISON TYPE not found!\n";
				exit(1);
			}
			if (strlen(inputline2)==0) goto Again7;

			// Make "equals" the default conditional
			conditional=0;

			// If this is a "doesnotequal" IF, set flag to 1
			if(!strcmp(inputline2,doesnotequal)) conditional=1;

			// If this is a MORE THAN condition, set flag to 2
			if(!strcmp(inputline2,morethan)) conditional=2;

			// If this is a LESS THAN condition, set flag to 3
			if(!strcmp(inputline2,lessthan)) conditional=3;

			// PERFORM THE SAME AS ABOVE FOR THE SECOND ITEM IN COMPARISON:
			comptype2=1;
			Again9:
			f1.getline(inputline2,255,'\n');
			cs(inputline2);
			if (!f1)
			{
				cout << "VARIABLE/RETURN/VALUE command not found!\n";
				exit(1);
			}
			if (strlen(inputline2)==0) goto Again9;

			if (!strcmp(inputline2,cmdreturn)) comptype2=0;

			if (!strcmp(inputline2,value)) comptype2=2;

			Again10:
			f1.getline(inputline2,255,'\n');
			cs(inputline2);
			if (!f1)
			{
				cout << "VARIABLE/RETURN NAME/VALUE not found!\n";
				exit(1);
			}
			if (strlen(inputline2)==0) goto Again10;

			////////////////////////////////////////////////////////////////
			//
			// Because .VAR and .RET files are restricted to 8 characters
			// under DOS, preempt any I/O complications by truncating
			// their names to 8 characters, even if programmer has used
			// a longer name (which is valid).
			//
			////////////////////////////////////////////////////////////////

			// TRUNCATE NAME only if it is a RETURN or VARIABLE NAME
			if (comptype<2) inputline[8]='\0'; // truncate ret/var name if nec.

			// If this is a VALUE, put the value (now in INPUTLINE) in
			// its own file, V0000001.VAR, then copy that filename into
			// INPUTLINE for use by the file I/O routine
			if (comptype==2)
			{
				ofstream f3("v0000001.var");
				f3 << inputline << "\n";
				f3.close();
				stpcpy(inputline,"v0000001.var");
			}

			// If this is a VARIABLE comparison, append .VAR extension to
			// variable name to construct corresponding filename
			if (comptype==1)
			{
				strcat(inputline,".var");
			}
			if (comptype==0)
			{
				strcat(inputline,".ret");
			}

			if (comptype2<2) inputline2[8]='\0'; // truncate ret/var name if nec.

			// If this is a VALUE, put the value (now in INPUTLINE2) in
			// its own file, V0000002.VAR, then copy that filename into
			// INPUTLINE2 for use by the file I/O routine
			if (comptype2==2)
			{
				ofstream f3("v0000002.var");
				f3 << inputline2 << "\n";
				f3.close();
				stpcpy(inputline2,"v0000002.var");
			}
			// If this is a COMMAND RETURN comparison, append .RET extension
			// to the command return name
			if (comptype2==1)
			{
				strcat(inputline2,".var");
			}
			if (comptype2==0)
			{
				strcat(inputline2,".ret");
			}

			/////////////////////////////////////////////////////////////////
			//
			// IF (EQUALS/DOESNOTEQUAL) .VAR/.RET comparison routine
			//
			// All variables in VURTUAL are treated as files containing
			// strings.  Therefore, we compare files, not actuall variables
			// in memory.  This is how the variables come under the VIRTUAL
			// category, since they are stored on disk, not in RAM.
			//
			// Of course, this creates a new breed of problems, such as
			// whether or not the file has been created or if it is there
			// under the proper filename.  At one time, I had INTERVUR
			// return NULL, but this gets you nowhere if no file was found.
			// This gives a true but false response to IF--lying by
			// ommission!: yes, A does not equal B (nevermind that B does
			// not exist...)  So, to promote proper programming practices,
			// INTERVUR will abort interpreting your program to tell you
			// the variable/command return file is not there or it is not
			// spelled correctly.  Hopefully it's the latter of the two....
			/////////////////////////////////////////////////////////////////

			ifstream f3(inputline);
			if (!f3)
			{
				cout << "Variable/return file " << inputline << " not found!\n";
				exit(1);
			}
			ifstream f4(inputline2);
			if (!f4)
			{
				cout << "Variable file " << inputline2 << " not found!\n";
				exit(1);
			}
			if (conditional==2) // more than
			{
				f3.getline(inputline,255,'\n');
				f4.getline(inputline2,255,'\n');
				number1=atol(inputline);
				number2=atol(inputline2);
				if (number1>number2) goto ParsingLoop;
				FindEndofIf:
				f1.getline(inputline,255,'\n');
				cs(inputline);
				if (!f1)
				{
					cout << "ENDIF not found!\n";
					exit(1);
				}
				if (strlen(inputline)==0) goto FindEndofIf;
				if (!(!strcmp(inputline,ifend))) goto FindEndofIf;
			}
			if (conditional==3) // less than
			{
				f3.getline(inputline,255,'\n');
				f4.getline(inputline2,255,'\n');
				number1=atol(inputline);
				number2=atol(inputline2);
				if (number1<number2) goto ParsingLoop;
				FindEndofIf2:
				f1.getline(inputline,255,'\n');
				cs(inputline);
				if (!f1)
				{
					cout << "ENDIF not found!\n";
					exit(1);
				}
				if (strlen(inputline)==0) goto FindEndofIf2;
				if (!(!strcmp(inputline,ifend))) goto FindEndofIf2;
			}

			if (conditional<2)
			{
				// Preset NOTEQUAL flag to 0, assuming both .VAR/.RET files
				// are equal in contents
				notequal=0;

				// While both files are not at their EOF, continue.
				// The AND logical operator prevents continuation should
				// one or the other or both files reach their EOFs.
				while (f3 && f4)
				{
					f3.get(var1);
					f4.get(var2);

					// If an inequality (A.byte != B.byte) exit the WHILE loop
					// and report that indeed A does NOT equal B
					if (var1!=var2)
					{
						notequal=1;
						break;
					}
				}

				// Close the .RET/.VAR files
				f3.close();
				f4.close();

				// If A doesn't = B && it was supposed to, jump to ENDIF statement
				if (conditional==0 && notequal==1)
				{
					EndofIf:
						f1.getline(inputline,255,'\n');
						cs(inputline);
						if (!f1)
						{
							cout << "ENDIF not found!\n";
							exit(1);
						}
						if (strlen(inputline)==0) goto EndofIf;
						if (!(!strcmp(inputline,ifend))) goto EndofIf;
				}
				// IF A == B, and it shouldn't, jump to ENDIF
				if (conditional==1 && notequal==0)
				{
					EndofIf2:
						f1.getline(inputline,255,'\n');
						cs(inputline);
						if (!f1)
						{
							cout << "ENDIF not found!\n";
							exit(1);
						}
						if (strlen(inputline)==0) goto EndofIf2;
						if (!(!strcmp(inputline,ifend))) goto EndofIf2;
				}

			////////////////////////////////////////////////////////////////
			// The result of the conditional is handled thusly:
			//
			// IF DESIRED RESULT RETURNS, give the code after IF to
			// INTERVUR to process.
			//
			// IF FALSE, advance fileposition to ENDIF line, THEN return
			// to parser, preventing INTERVUR from executing the code
			// reserved for a TRUE response.
			////////////////////////////////////////////////////////////////

				goto ParsingLoop;
			}
		}
		/////////////////////////////////////////////////////////////////////
		//
		// VARIABLE/ENDVARIABLE
		//
		// Variables are unsung heroes of computer programming.  Functions
		// do many things, but it is the variables that help them carry out
		// their tasks, holding values, changing on command, until they
		// are deallocated or the program ends.
		//
		// VURTUAL treats every variable as a string.  WHY?  Flexibility.
		// In mostly all established computer languages (the exception being
		// BASIC), variables must be predefined and are limited by memory
		// and the programming language itself.  Even in BASIC you must
		// use A$ to refer to a string and A to refer to a number.  In
		// VURTUAL, the limitation comes from DOS, which keeps all filenames
		// to eight characters or less, and your own hard drive, which may
		// or may not have substantial free space.  Other than that, VURTUAL
		// variable can contain ANY information--binary, numbers, strings,
		// entire booklength text files, or any of these combined.
		//
		// Manipulating these strings and text files will be your challenge
		// as VURTUAL has no provisions for advanced or rudimentary
		// string-manipulation.  This is where the #system commands will
		// prove your strongest allies.  See VURTUAL.WHY for more information.
		//
		// To define a variable, follow this format:
		//
		// 		variable
		//			nameofvariable
		//				contents
		//				contents
		//		endvariable
		//
		// You couldn't want it any easier.  Upon receiving the "Variable"
		// command, INTERVUR creates a .VAR variable file and places the
		// "contents" of your variable definition in the file, placing a
		// '\n' (newline) after each line.
		//
		// The following code represents a simple variable definition:
		//
		//-------------------------------------------------------------------
		// 		beginprogram
		//
		//			variable
		//				greetings
		//					Hello there.
		//					How are you today?
		//			endvariable
		//
		//		endprogram
		//-------------------------------------------------------------------
		// The lifetime of any variable definition is as long as INTERVUR
		// is processing your .VUR program.  Once the end of your program
		// has been reached, all .VAR and .RET files created during that
		// VURTUAL session will be deleted.  This frees you from worrying
		// whether or not several huge variable declarations will consume
		// your hard disk space--they will not.  For the purpose of the
		// programmer who, no doubt, wants control over his programs and to
		// be able to track variables and command return files, you can
		// force INTERVUR to leave all .VAR and .RET files untouched after
		// your program has finished.  To do so, type:
		//
		//					intervur myprog /keep
		//
		// All .VAR and .RET files (if any) will remain for your review.
		// INTERVUR uses the C++ fstream class library for file I/O and
		// is designed to OVERWRITE any preexistent variable definitions
		// and command return files if you run your program again.
		//
		// Variable definitions can appear ANYWHERE in a VURTUAL program,
		// but it is best if you do so at the beginning of your program
		// so you can easily track and modify them when necessary.
		//
		// For advanced users, VURTUAL variables can hold any number of
		// definitions.  You can, in effect, assign thousands of alphanumeric
		// values to a single variable.  To do so would require you to
		// write a #system command that would treat each line in a VURTUAL
		// .VAR file as a separate value.  This is not for beginners and
		// should be avoided in normal computing practices.  It is something
		// unique to VURTUAL that can be powerful when implemented
		// properly and confusing if conducted otherwise.
		/////////////////////////////////////////////////////////////////////

		// Is this a Variable Definition?  If so, process
		if (!strcmp(inputline,variable))
		{
			// Set "variable files in use" flag (to be used at end of
			// INTERVUR to decide whether or not to invoke the system(delete)
			// command).
			varfiles=1;

			// Retrieve the name of the variable
			Again11:
			f1.getline(inputline,255,'\n');
			cs(inputline);
			if (!f1)
			{
				cout << "VARIABLE NAME not found!\n";
				exit(1);
			}
			if (strlen(inputline)==0) goto Again11;

			// Retrieve the data to be stored in this variable
			Again12:
			f1.getline(inputline2,255,'\n');


			////////////////////////////////////////////////////////////////
			// Since you might want to preserve the case of your variable
			// definition (e.g. This IS a test), I have elected to use
			// RemAllSpaces instead of the cs() (clean-string) function.
			// This removes all trailing/leading spaces from the string
			// if you indented it, but leaves the case intact.  If you
			// decide it would be better to restrain variable declarations
			// to lowercase, you can change this to read cs(inputline2);
			// but you must ALSO change the next two occurrences of
			// RemAllSpaces.  Just skip down a few lines to find the second
			// one and goto USERINPUT command, further down, for the third
			// RemAllSpaces.  Changing all three to either cs() or back to
			// RemAllSpaces will assure you that user input and variables
			// can be compared without any discrepancies in case.  When
			// you make any changes, be sure to do it to a backup copy
			// and insert a comment saying you did so.  This simple measure
			// will keep INTERVUR performing properly, and in the event of
			// any difficulties, you always have your backup to use.
			////////////////////////////////////////////////////////////////

			RemAllSpaces(inputline2);
			if (!f1)
			{
				cout << "VARIABLE DATA error!\n";
				exit(1);
			}

			// Create .VAR filename and the file, itself
			strcat(inputline,".var");
			ofstream f3(inputline);

			// Continue Variable Declaration Loop (for extended definitions)
		ContinueVarDeclaration:
			f3 << inputline2 << "\n";
			f1.getline(inputline2,255,'\n');

			// THIS IS THE SECOND OCCURRENCE OF REMALLSPACES.  If you read
			// the above note, you would know this is about.  If you

			RemAllSpaces(inputline2);

			// If we haven't reached the "endvariable" declaration, continue
			if (!f1)
			{
				cout << "ENDVARIABLE command not found!\n";
				exit(1);
			}
			if (!(!strcmp(inputline2,endvariable))) goto ContinueVarDeclaration;
			f3.close();

			// Close file and return to Parsing Loop for next command
			goto ParsingLoop;
		}

		/////////////////////////////////////////////////////////////////////
		//
		// USERINPUT
		//
		// You can't have an interactive program without input.  Userinput
		// allows you to easily accept information from the user, be it a
		// word, a name, a command, a number, or an entire sentence.
		//
		// The syntax for USERINPUT is:
		//
		//				userinput
		//					nameofvariable
		//
		// That's all.  A cursor will appear and the user can type whatever
		// needs to be typed.  That information will be stored in a .VAR
		// file.  Since nothing else but a cursor appears, you want to
		// prompt the user to type something specific.  Look at this
		// example program:
		//-------------------------------------------------------------------
		// beginprogram
		//
		//		variable
		//			choice1
		//			1
		//		endvariable
		//
		//		variable
		//			choice2
		//			2
		//		endvariable
		//
		//		GETCHOICE:
		//
		//		display
		//			1.	Choice number one
		//			2.	Choice number two
		//
		//		displayend
		//
		//		userinput
		//			choice
		//		if
		//			variable
		//				choice
		//					equals
		//          variable
		//				choice1
		//			display
		//				You have selected number one.
		//			displayend
		//			exitprogram
		//		endif
		//		if
		//			variable
		//				choice
		//					equals
		//			variable
		//				choice2
		//			display
		//				You have selected number two.
		//			displayend
		//			exitprogram
		//		endif
		//		display
		//			Sorry, you can only choose 1 or 2.
		//		displayend
		//		goto
		//			GETCHOICE:
		// endprogram
		//-------------------------------------------------------------------
		if (!strcmp(inputline,userinput))
		{
			Again13:
			f1.getline(inputline,255,'\n');// retrieve var name to store inp

			/////////////////////////////////////////////////////////////////
			// Important: I have again elected to use RemAllSpaces instead
			// of the cs() ("clean string") function because you might
			// want to perform case-sensitive checking.  You may find this
			// to be a detriment, rather than a benefit.  If you change
			// this to read cs(inputline); please change the one in
			// the Variable Declaration to cs() too.
			/////////////////////////////////////////////////////////////////
			RemAllSpaces(inputline);
			if (!f1)
			{
				cout << "USERINPUT VARIABLE NAME not found!\n";
				exit(1);
			}
			if (strlen(inputline)==0) goto Again13;

			// Get input from user, store input in its own .VAR file
			cin.getline(inputline2,80,'\n');
			strcat(inputline,".var");
			ofstream f3(inputline);
			f3 << inputline2 << "\n";
			f3.close();
			goto ParsingLoop;
		}

		// Is this a NEWSCREEN command? If so, clear the screen.
		if (!strcmp(inputline,cls)) clrscr();

		////////////////////////////////////////////////////////////////////
		//
		// VIEWVARIABLE
		//
		// Because you need to access variables on a regular basis, I have
		// created this command which automatically searches for the
		// corresponding .VAR file of the variable you specify.  Since the
		// output could easily span several screen-pages (each page measured
		// at 25 lines) and variable files could go well into hundreds of
		// lines, I provided a prompt which appears every 25th line asking
		// you to either press RETURN to continue viewing the variable or
		// to enter an X if you wish to terminate this command.
		//
		// The syntax for viewvariable is:
		//
		// 			viewvariable
		//				variablename
		//
		// It is expected that the variablename has been defined prior to
		// this command.  The secret behind a great program is that it
		// thinks ahead, always ready for the unexpected entry, the
		// typographical error, the small mistake that sends computers
		// crashing to the floor.  Viewvariable will look for the
		// corresponding .VAR file.  If it does not find it, the program
		// will be halted and you will receive an error message.
		//
		////////////////////////////////////////////////////////////////////

		/////////////////////////////////////////////////////////////////////
		// Is this a VIEWVARIABLE or SHOWRETURNS command?  If so, process
		//
		// This grouped comparison is not recommended.  Every command should
		// have its own, separate code.  Doing it any other way can be
		// dangerous and lead to malfunctions.  I will, however, make
		// an exception in this case:  Viewreturn is virtually the same
		// command as ViewVariable--the difference is their file extensions
		// (.VAR & .RET).  A little hackery two lines down checks the
		// 10th character of inputline, which will either be 'b' or 'n';
		// A 'b' indicates "viewvariable," wheras 'n' indicates "showreturns."
		// Again, a very slick trick, but dangerous in consequence when
		// enacted carelessly.
		/////////////////////////////////////////////////////////////////////

		if (!strcmp(inputline,viewvariable) || !strcmp(inputline,showreturns))
		{
			// Default vr (variable read) to 0 (variable)
			vr=0;

			// If this is the "showreturns" command
			if (inputline[9]==110) vr=1;
			//(strcmp(inputline,showreturns)) vr=1;
			// Retrieve name of variable
			Again14:
			f1.getline(inputline,255, '\n');
			cs(inputline);
			if (!f1)
			{
				cout << "VARIABLE/RETURN NAME not found!\n";
				exit(1);
			}
			if (strlen(inputline)==0) goto Again14;

			// Truncate if necessary, create .VAR/.RET filename, open it
			if (strlen(inputline)>8) inputline[8]='\0';

			// If this is a "returns" command, use .RET extension
			if (vr==1)
			{
				strcat(inputline,".ret");
			}
			else  // If not, use .VAR exetension
			{
				strcat(inputline,".var");
			}

			// Open the .RET/.VAR file for INPUT
			ifstream f3(inputline);

			// FILE ERROR, terminate and return with error
			if (!f3)
			{
				// File error message for RETURN file
				if (vr==1)
				{
					cout << "Return file \"" << inputline << "\" not found!\n";
				}
				else // File error message for VARIABLE file
				{
					cout << "Variable file \"" << inputline << "\" not found!\n";
				}
				// Terminate upon error
				exit(1);
			}

			// Get the first line of the .VAR file; initialize WHILE loop
			f3.getline(inputline2,255, '\n');

			// reset screenline counter to zero
			screenlines=0;

			// Continue until EOF of .VAR file, output to screen
			while(f3)
			{
				cout << inputline2 << "\n";

				// increment screenlines with each output
				screenlines++;

				// get the next line in the .VAR file
				f3.getline(inputline2,255,'\n');

				// check if prompt should now appear
				if (screenlines==24)
				{
					cout << "Press RETURN to continue or enter X to stop.";
					cin.get(uip);

					// Detect both upper and lowercase X; if yes, terminate
					if (uip==88 || uip==120) break;
					screenlines=0;
				}
			}
			// Close file, return to Parser
			f3.close();
			goto ParsingLoop;
		}

		if (inputline[0]=='#') // Scan for system commands
		{
			// Set the "return files used" flag--used to decide whether
			// or not any .RET files should be deleted after program
			// processing is completed.  Overridden by the "/keep" directive.
			retfiles=1;

			// Preset/Reset syscmds to all NULL values
			for (int nf=0; nf<8; nf++)
			{
				stpcpy(syscmd[nf],NULL);
			}

			// Retrieve the number of parameters to pass to #SYSTEM COMMAND
			Again15:
			f1.getline(inputline2,255,'\n');
			cs(inputline2);
			if (!f1)
			{
				cout << "#SYSTEM COMMAND PARAMETERS not found!\n";
				exit(1);
			}
			if (strlen(inputline2)==0) goto Again15;

			// Convert the parameter # to an INTEGER
			argumen=atoi(inputline2);

			// Read parameters into syscmd[] array
			for (c=1; c<argumen+1; c++)
			{
				Again16:
				f1.getline(inputline2,255,'\n');
				cs(inputline2);
				if (!strcmp(inputline2,variable))
				{
					f1.getline(inputline3,255,'\n');
					cs(inputline3);
					strcat(inputline3,".var");
					ifstream f2(inputline3);
					if (!f2)
					{
						cout << "ERROR ACCESSING VARIABLE \"" << inputline3 << "\"! \n";
						exit(1);
					}
					f2.getline(inputline3,255,'\n');
					f2.close();
					stpcpy(inputline2,inputline3);
				}
				if (!strcmp(inputline2,cmdreturn))
				{
					f1.getline(inputline3,255,'\n');
					cs(inputline3);
					strcat(inputline3,".ret");
					ifstream f2(inputline3);
					if (!f2)
					{
						cout << "ERROR ACCESSING RETURN FILE \"" << inputline3 << "\"! \n";
						exit(1);
					}
					f2.getline(inputline3,255,'\n');
					f2.close();
					stpcpy(inputline2,inputline3);
				}
				if (!f1)
				{
					cout << "TOO MANY #SYSTEM COMMAND PARAMETERS!\n";
					exit(1);
				}
				if (strlen(inputline2)==0) goto Again16;
				stpcpy(syscmd[c],inputline2);
			}

			/////////////////////////////////////////////////////////////////
			// USE DOS's SPAWNL command to access #SYSTEM COMMAND, which DOS
			// considers another program.  The "P_WAIT" causes INTERVUR to
			// go into temporary dormancy while the #SYSTEM COMMAND carries
			// out its operations.  Control is returned upon successful
			// execution of a #SYSTEM COMMAND.  The "success" flag returns
			// negative if A) The command could not be found or B) The
			// command returned a negative, indicating there was an error
			// in processing the parameters.  In either A or B, INTERVUR will
			// abort further processing of your file and report the error.
			/////////////////////////////////////////////////////////////////

			success=spawnl(P_WAIT,inputline,syscmd[0],syscmd[1],syscmd[2],syscmd[3],syscmd[4],syscmd[5],syscmd[6],syscmd[7],NULL);

			// If there was an error, let user/programmer know about it. EXIT.
			if (success<0)
			{
				cout << "****ERROR ACCESSING SYSTEM COMMAND \"" << inputline << "\"****" << "\n";
				exit(1);
			}

			// All went well.  Return to parser to get more information.
			goto ParsingLoop;
		}

		// EXIT PROGRAM? EXIT PROGRAM!
		if (!strcmp(inputline,exitprogram)) goto ProgramExit;

		// END OF PROGRAM?  EXIT PROGRAM!
		if (!strcmp(inputline,endprogram)) goto ProgramExit;

		// Is there more data in source code file?  Go to top of ParsingLoop.
		if (f1) goto ParsingLoop;

	// INTERVUR has reached an EOF or an EXITPROGRAM command has been
	// encountered.
	ProgramExit:

	// Close the source code file.
	f1.close();

	/////////////////////////////////////////////////////////////////////////
	// If there were any .VAR variable or .RET system return files created
	// during this session, delete them using DOS's DEL command.  BUT, if
	// the user/programmer specified "/keep" at the command line, leave
	// the .VAR / .RET files there.  HOWEVER, if you fail to specify
	// "/keep" the NEXT time you run INTERVUR, regardless of what program
	// you are using, all .VAR / .RET files WILL BE DELETED because of the
	// "*.var" and "*.ret" wildcard deletion.
	/////////////////////////////////////////////////////////////////////////
	// *** NOTE:  Of the five #SYSTEM COMMANDS I included with this version
	// of VURTUAL, four produce .RET files.  The fifth, #STRCOPY, doesn't
	// produce any .RET files.  Because INTERVUR does not know which system
	// command is being used and whether or not the command you are using
	// produces a .RET file, it will set the RETFILES flag to 1 anyway.
	// What happens?  The line below (system("del *.ret");) will be executed.
	// DOS will report "File not found" if INTERVUR attempts to delete a
	// .RET file that is not there.  Disregard this message.
	/////////////////////////////////////////////////////////////////////////

	if ((varfiles || retfiles) && keep==0) cout << "\n\nDeleting any .VAR/.RET files...\n";
	if (varfiles && keep==0) system("del *.var");
	if (retfiles && keep==0) system("del *.ret");

	// This INTERVUR session has ended.  Return to DOS.
	return 0;
}
