///////////////////////////////////////////
//    V.U.R.T.U.A.L.   #SYSTEM COMMAND   //
//	  (C)opyright 1994 Robert J. Tiess   //
//---------------------------------------//
// #STRBIND								 //
// SYNTAX:								 //
// 				#STRBIND				 //
//				2					 	 //
//				variablename1			 //
//				variablename2			 //
//---------------------------------------//
// #STRBIND binds the contents of one   //
// variable (variablename1) to another   //
// (variablename2).  Variablename2 will  //
// lose any data it contained prior to   //
// this operation.						 //
//---------------------------------------//
// A sample V.U.R.T.U.A.L. program:		 //
//---------------------------------------//
// beginprogram							 //
//										 //
// variable								 //
// 		stringa							 //
// 			Let me count the ways...	 //
// endvariable							 //
//										 //
// variable								 //
// 		stringb							 //
//			How do I love thee?			 //
// endvariable							 //
//										 //
// #strbind								 //
// 2									 //
// stringa								 //
// stringb								 //
//										 //
// viewvariable							 //
// stringb								 //
//---------------------------------------//
// STRINGA (above) is appended to the 	 //
// end of STRINGB.  This should be taken //
// into consideration before you merge	 //
// the two variables.  If you need the   //
// data merged the other way around,     //
// reverse the order in which you hand   //
// them to #STRBIND.  Whatever order you //
// choose, the second variable item will //
// no longer contain its original data.  //
// It will hold both varible1 & 2.       //
///////////////////////////////////////////
// *** NOTE: #STRBIND does NOT produce   //
// a .RET return file because it works   //
// directly on the variables you pass    //
// to it.  Use VIEWVARIABLE to see the   //
// results of this operation.			 //
///////////////////////////////////////////

#include <fstream.h>
#include <string.h>
#include <process.h>

int main(int argc, char *argv[])
{

	// Create VARIABLEA & VARIABLEB for incoming parameters
	char variableA[12];
	char variableB[12];
	stpcpy(variableA,argv[1]);
	stpcpy(variableB,argv[2]);

	// Define a temporary char reserved for input
	char inp;

	// Attach the .VAR variable identification extension
	strcat(variableA,".VAR");
	strcat(variableB,".VAR");

	// Open VARIABLEA for INPUT and VARIABLEB for OUTPUT
	ifstream f3(variableA);
	ofstream f4(variableB,ios::app);

	// If something's wrong with VARIABLEA (Not there?) ABORT STRBIND,RETURN
	if (!f3)
	{
		cout << "#SYSTEM COMMAND ERROR:  ERROR ACCESSING \"" << variableA << "\"!\n";
		exit(1);
	}

	// While VARIABLEA has not reached its EOF, copy contents to VARIABLEB
	while(f3 && f3.get(inp)) f4.put(inp);

	// Done.  Close the files, return control to INTERVUR
	f3.close();
	f4.close();

	// Return to INTERVUR for next command
	return 0;
}
