/*****************************************************************
 * Pegasus Tools and PegRexx                                     *
 * Version 1 Release 10                                          *
 * (c) 1993,1994 C.O.L. Systems Inc. All Rights Reserved.        *
******************************************************************/

/* Register with REXX API extensions. */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initializers                 */

iFound = 0;

/* Get command line parameters. */

Parse Arg InstallDir

if InstallDir = "" then do
   r=Instructions();
   exit;
   end;

else do

   Call SysFileTree InstallDir , "Cfiles" , "SD"
   do i = 1 to Cfiles.0
      if pos( translate(InstallDir) , translate(Cfiles.i) ) > 0 then do
         iFound = 1;
         i = Cfiles.0
         end;
      end;
   end;

/* If the directory pointed to was not found, then create it   */

if iFound = 0 then do
   r = Call SysMkDir( InstallDir );
   r = delword(r,1,1);
   if( r <> 0 ) then do
      say;
      say 'An error occured creating the specified directory rc = 'r;
      'helpmsg 'r;
      say 'Pegasus tools installation aborting due to error in pathname';
      r=Instructions();
      exit;
      end;
   end;

/* Copy files. */

Call SysCls

Say
Say 'Installing Pegasus Tools Version 1 Release 10'

'copy *.dll '||InstallDir
'copy *.exe '||InstallDir
'copy *.hlp '||InstallDir
'copy *.ico '||InstallDir
'copy *.inf '||InstallDir
'copy *.cmd '||InstallDir
'copy *.log '||InstallDir
'copy *.doc '||InstallDir
'copy readme.1st '||InstallDir

Say;
Say 'Creating Pegasus Tools Desktop objects.';
Say;

r = Call SysCreateObject("WPFolder","Pegasus","<WP_DESKTOP>","OBJECTID=<PEGFOLDER>","update")
                     
if (r <> 0 ) then do

      r = Call SysCreateObject("WPProgram","AppMon 1.10","<PEGFOLDER>",,
               "EXENAME="||InstallDir||"\APPMON.EXE;STARTUPDIR="||InstallDir, "replace" );

      r = Call SysCreateObject("WPProgram","FileMon 1.10","<PEGFOLDER>",,
               "EXENAME="||InstallDir||"\FILEMON.EXE;STARTUPDIR="||InstallDir, "replace" );
               
      r = Call SysCreateObject("WPProgram","CacheMon 1.10","<PEGFOLDER>",,
               "EXENAME="||InstallDir||"\CACHEMON.EXE;STARTUPDIR="||InstallDir, "replace" );
               
      r = Call SysCreateObject("WPProgram","Pegasus Tools Reference","<PEGFOLDER>",,
               "EXENAME=VIEW.EXE;PARAMETERS="||InstallDir||"\PEGTOOLS.INF;STARTUPDIR="||InstallDir, "replace"  );
               
      r = Call SysCreateObject("WPProgram","Pegasus Rexx Extension Reference","<PEGFOLDER>",,
               "EXENAME=VIEW.EXE;PARAMETERS="||InstallDir||"\PEGREXX.INF;STARTUPDIR="||InstallDir, "replace"  );
   end;

else do
   say;
   say   'An error occured during the creation of the Pegasus Folder ';
   say   'and program objects. Contact C.O.L. Systems Inc. ';
   end;

Say 'Pegasus Tools and PegRexx 1.10 has been installed!'
Say
olddir = directory();
f = directory(InstallDir);
'view pegtools License And Warranty';
f = directory(olddir);

Exit

/* Instructions on installation procedure */

Instructions:
      Say
      Say
      Say '     Pegasus Tools Installation Instructions: '
      Say
      Say
      Say 'Directions:    To install Pegasus tools, you must choose a target'
      Say '               directory on your hard drive.'
      Say
      Say '               If you have the Pegasus Resource Monitor Installed'
      Say '               you should install to that directory.'
      Say
      Say
      Say 'Example:       PTINST C:\PEGASUS '
      Say

Return 0;
