/***************************************/
/* Pegasus Log Rexx Extension          */
/* Version 1.10                        */
/* (c) 1993,1994 C.O.L. Systems Inc.   */
/* All Rights Reserved                 */
/* Application Process Sample Proc     */
/***************************************/

Data1. = "";         /* This is our data stem. Assumes one file input*/

Parse Arg   MyFile   /* Parse the file name on input to the proc     */

/************************/
/* Load the extension   */
/************************/

if RxFuncQuery('PegLoadFunctions') <> 0 then do
   rcy = RxFuncAdd('PegLoadFunctions','PEGREXX','PegLoadFunctions')
   if rcy = 0 then do
      rcy = PegLoadFunctions()
      if rcy > 0 then
         signal BadLoad;
      end;
   else do
      signal BadAdd;
      end;
   end;

/**************************/
/* Load the file and stem */
/**************************/

rcx = PegLoadFile(MyFile,"Data1.");

/* If the load is ok, and data originated with the FileMon tool   */

say   Data1.Creator;

if rcx == 0 & Data1.Creator == 1 then do

   /* Copyright information   */

   say;
   do count = 1 to 7
      say   sourceline(count);
      end;

   /* Supplied by originator  */

   say;
   say "Data was created by "Data1.Title;   

   /* For each resource found flag, display the name  */

   say "Res # = "Data1.Resources;   

   do count = 1 to Data1.Resources  /* Display each on in list */
      say   "Resource "count" = "Data1.Resources.count;
      end

   /* Display the number of records */
   say   "Records = "Data1.Records; 

   /* Display the number of apps  from APPMON or FILEMON */
   say   "Apps    = "Data1.Records.Applications;

   /* Display the number of files from APPMON or FILEMON */

   say   "Files   = "Data1.Records.Files;

   /* Display file resource by filename   */

   if( Data1.Records > 0 ) then do
      metcnt = PegMetric('THD');          /* Get for later calls  */

      do count = 1 to Data1.Records

         if Data1.Records.count.THD > 0 then do   /* Do we have entries */
            
            do tcount = 1 to Data1.Records.count.THD

            /***************************/
            /* For each detail thread  */
            /* measurement sample, we  */
            /* use the UID to resolve  */
            /* the app name from the   */
            /* application table       */
            /***************************/

               dataRef = 'Data1.Records.'||count||'.THD.'||tcount||'.Pid';

               do appslook = 1 to Data1.Records.Applications
                  if Data1.Records.Files.appslook.PID == value(dataRef) then do
                     say   ;
                     say   'Process 'Data1.Records.Applications.appslook.Name;
                     say   ;
                     appslook = Data1.Records.Applications;
                     end;
                  end;

            /***************************/
            /* Now we display each of  */
            /* the metrics without the */
            /* knowledge of their name */
            /* using the PegMetric call*/
            /***************************/

               do mcount = 1 to metcnt
                  dataRef = 'Data1.Records.'||count||'.THD.'||tcount||PegMetric('THD',mcount);
                  say 'Thread 'PegMetric('THD',mcount)' = 'value(dataRef);
                  end;
               end;
            end;
         end;
      end;
   end;

/* Report a file access error  */

else do
   say "Error in file set = "rcx;
   if Data1.Creator <> 1 then
    say 'Not a AppMon log!';
   end;

/* Release the extension   */

rcx = PegDropFunctions();
call RXFUNCDROP 'PEGLOADFUNCTIONS';

exit;

/****************************************************/
/*  Error in syntax occured somewhere here          */
/****************************************************/

BadAdd:

   say   'Error Adding Pegasus Rexx Function Loader';

exit;

BadLoad:

   say   'Error Loading Pegasus Rexx Functions';

exit;

