' Area: F-QUICKBASIC 
'  Msg#: 408                                          Date: 13 Apr 94  00:27:00
'  From: Howard Hull Jr                               Read: Yes    Replied: No 
'    To: Bill Kahl                                    Mark:                     
'  Subj: Screen 12 Dot Matrix  1/2
'
'BK>I am looking for some code to print a VGA screen mode 12 to the epson
'BK>compatible dot matrix printer.
'BK>I use Power Basic but MS Basics are fine.
'BK>BTW Lloyd of PB tech support gave me some code for printing
'BK>screen 9 & 12 to the laserjet, and screen 9 to the dot matrix
'BK>unfortunately the screen 12 routine does not work.
'BK>I must note thes routines are blazing fast and written in PB/Assembler,
'BK>so they will not help MS basic users generally.
'BK>Bill
'        Here's a routine I wrote about 6 mo. ago.
'It will print to whatever device to wish, includeing a File for later
'printing.

'Just call VGAtoEpson with these options
'   scrn% - current screen mode
'   F$    - File or device name  eg.("LPT1" or "SCREEN.TXT")
'   flip% - print as a negitive (0 = black screen will be white on paper,
'                1 = Black will print black.)
'   border% - character to use for screen modes 9 & 10
'                (0 = none, 255 = solid, etc.)
'VGAtoEpson will return ExitCode% - 0 if everthing went OK.


' ** Code Start ********************
 DECLARE SUB ScreenParams (scrn%, ScreenWidth%, ScreenLength%, NP%)
 DECLARE SUB VGAtoEpson (scrn%, f$, flip%, border%, ExitCode%)
DEFINT A-Z
SCREEN 12
' draw your graphics and such
Scr% = 12
F$ = "LPT1"
Flip% = 0
Border% = 0
CALL VGAtoEpson (Scr%, F$, Flip%, Border%, ExitCode%)

   SUB ScreenParams (scrn%, ScreenWidth%, ScreenLength%, NumPlanes%)
     ' Return the screen dimensions in pixels
     ' and the number of planes.
     ' used internally by VGAtoEpson.
     NumPlanes% = 4          ' Set default values for SCREEN 12
     ScreenWidth% = 640: ScreenLength% = 480
     SELECT CASE scrn%       ' Change values for other SCREEN modes
        CASE 7
           ScreenWidth% = 320: ScreenLength% = 200
        CASE 8
           ScreenLength% = 200
        CASE 9
           ScreenLength% = 350
        CASE 10
           NumPlanes% = 2: ScreenLength% = 350
        CASE 11
           NumPlanes% = 2
     END SELECT
   END SUB

   SUB VGAtoEpson (scrn%, fileN$, flip%, border%, ExitCode%) STATIC
   ' Sends the image on SCREEN 7, 8, 9, 10, 11 or 12
   ' to an Epson printer.
   ' Parameters:
   '    scrn%   - SCREEN video mode of screen to print (7 through 12)
   '    fileN$  - Name of file or device to send image to
   '    flip%   - Invert flag (0 = normal, not 0 = invert)
   '    border% - Character to use for border drawing on screens
   '              9 and 10 (0 = none, 255 = solid, etc.)
   ff = FREEFILE
     OPEN fileN$ FOR BINARY AS ff            'Open the output file
     WIDTH #ff, 255
     Esc$ = CHR$(27): crlf$ = CHR$(13) + CHR$(10)
     line$ = Esc$ + "A" + CHR$(8)           'Set printer to 8/72 lpi"
     PUT #ff, , line$
     CALL ScreenParams(scrn%, ScreenWidth%, ScreenLength%, NumPlanes%)

     IF ScreenLength% < 480 THEN       ' Figure how many bytes to send
        numbyte% = ScreenLength% * 2 + 16   ' to printer for one
        maxy% = ScreenLength% - 1           '  line of graphics.
     ELSE
        numbyte% = 960: maxy% = 479
     END IF

     DEF SEG = &HA000               'Start of EGA/VGA screen memory
     BorderOffset% = (960 - numbyte%) / (2 * 8)
     IF ScreenLength% < 480 THEN
        ' Print top line for border on screens where border will fit
        line$ = SPACE$(BorderOffset%)           '(for margin)
        PUT #ff, , line$
        line$ = Esc$ + "L" + MKI$(numbyte%)
        line$ = line$ + STRING$(numbyte%, border%) + crlf$
        PUT #ff, , line$
     END IF

     ' This loop is the horizontal byte location
     colend% = (ScreenWidth% / 8) - 1
     FOR col% = 0 TO colend%
       ' Set the printer up to receive 716 or 960 bytes
       ' of graphics data
       IF ScreenLength% < 480 THEN
          line$ = SPACE$(BorderOffset%)
          PUT #ff, , line$  '(for border)
       END IF

       line$ = Esc$ + "L" + MKI$(numbyte%)  '(for init)
       PUT #ff, , line$
       IF ScreenLength% < 480 THEN
          line$ = STRING$(8, border%)
          PUT #ff, , line$    '(for border)
       END IF

       '--- This loop is the vertical byte position
       FOR row% = maxy% TO 0 STEP -1
         ' For 4 plane screens (7, 8, 9 and 12) logically OR the blue
         ' plane with the red plane, send that byte, then OR the green
         ' plane with the intensity plane and send that byte.

         ' For screens 10 and 11, the video planes are sent directly
         ' to the printer.
         FOR plane% = 0 TO 1                'Plane (* 2) set
           OUT &H3CE, 4: OUT &H3CF, plane%
           place& = row%                   'Figure out screen memory
           place& = place& * (colend% + 1) ' location to read - use
           place& = place& + col%          ' a long to avoid overflow.
           mem% = PEEK(place&)

           IF NumPlanes% = 4 THEN ' OR color planes together
              OUT &H3CE, 4: OUT &H3CF, plane% + 2
              mem% = mem% OR PEEK(place&)
           END IF

           '--- Flip the byte if need be (inverses printed picture)
           IF flip% <> 0 THEN mem% = 255 - mem%
           line$ = CHR$(mem%): PUT #ff, , line$

         NEXT plane%
       NEXT row%
           IN$ = INKEY$ '-- Check for key press
           '-- If key was escape Clear buffer and exit
           IF (IN$) = CHR$(27) THEN
              Can$ = CHR$(24)
              PUT #ff, , Can$          'CLEAR BUFFER
              CLOSE #ff
              ExitCode% = -1
              EXIT SUB
           END IF

       line$ = crlf$    ' Default for no border
       IF ScreenLength% < 480 THEN
          line$ = STRING$(8, border%) + crlf$   ' Righthand border
       END IF
       PUT #ff, , line$
     NEXT col%

     IF ScreenLength% < 480 THEN     '--- Print bottom line for border
        line$ = SPACE$(BorderOffset%)       '(for margin)
        PUT #ff, , line$
        line$ = Esc$ + "L" + MKI$(numbyte%)
        line$ = line$ + STRING$(numbyte%, border%) + crlf$
        PUT #ff, , line$
     END IF
     ResetPrn$ = Esc$ + "@"
     PUT #ff, , ResetPrn$                 ' Reset printer
     line$ = CHR$(12): PUT #ff, , line$   ' Send formfeed (page eject)
     CLOSE ff                             ' All done
   END SUB

'**** Code End ***************************************

'*************************
'* Source code for those of you
'* that want it. Modify to your
'* hearts content. Enjoy.
'*************************
