/*****************************************************************************

 QWKSPLIT.C - Craig Morrison, 15 July 1994.

  I hereby release QWKSplit into the Public Domain on this day. Feel free to
  use the code in any way you see fit, but if you use it for profit, give me
  the credit in the documentation and make sure this notice appears in your
  source code.

  This is a quick and dirty solution to a problem that I had with figuring
  out how to send UUENCODED files through the Internet via a QWK mail door.

  The code may not be pretty nor the best in the world, but it does what I
  needed it to do... If it don't work, fix it, that's why I released the
  source code.

  The code is light and airy, shouldn't be too hard to follow. Just make
  sure you have a copy of the QWK specs on hand if you want to know what
  the different fields are for.

  QWKSPLIT takes a text file and splits it up into to one or more QWK style
  messages based on a small configuration file. What it creates is a *.MSG
  file that can be archived into a *.REP file and uploaded to a QWK mail
  door.

  It was compiled using BC++ for OS/2 v1.00.

*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <time.h>

#pragma pack(1)

typedef struct _msgdat {
    char msg_status;
    char msg_number[7];
    char msg_date[8];
    char msg_time[5];
    char msg_to[25];
    char msg_from[25];
    char msg_subj[25];
    char msg_pass[12];
    char msg_msgref[8];
    char msg_blks[6];
    char msg_flag;
    unsigned short msg_conf;
    unsigned short msg_lnum;
    char msg_nettag;
} MSGDAT, *PMSGDAT;

char BBSID[13];
char ConfID[8];
char tname[26];
char fname[26];
char subj[25];
char password[13];
char inetaddr[81];
int lines;
MSGDAT msg;

int GetQWKInfo(char *qwkcfg);
int SplitMessage(char *filename);
long GetLineCount(char *filename);
long WriteMsgBlocks(FILE *f, FILE *bm);

void FillInMsgData(PMSGDAT pmsg)
{
    char *p;
    char sdate[9], stime[9];

    memset(pmsg, ' ', sizeof(MSGDAT));
    pmsg->msg_status = '*';
    strncpy(pmsg->msg_number, ConfID, strlen(ConfID));
    _strdate(sdate);
    _strtime(stime);
    p = strrchr(stime, ':');
    if (p) *p = '\0';
    p = strchr(sdate, '/');
    if (p) *p = '-';
    p = strchr(sdate, '/');
    if (p) *p = '-';
    strncpy(pmsg->msg_date, sdate, strlen(sdate));
    strncpy(pmsg->msg_time, stime, strlen(stime));
    strupr(tname);
    strncpy(pmsg->msg_to, tname, strlen(tname));
    strupr(fname);
    strncpy(pmsg->msg_from, fname, strlen(fname));
    strncpy(pmsg->msg_subj, subj, strlen(subj));
    strncpy(pmsg->msg_pass, password, strlen(password));
    pmsg->msg_conf = atoi(ConfID);
    pmsg->msg_lnum = 0;
    pmsg->msg_flag = '';
}

int main(int argc, char *argv[])
{
    int rc = 0;

    if (argc >= 3)
    {
        printf("Scanning configuration...");
        rc = GetQWKInfo(argv[1]);
        if (!rc)
        {
            printf("\n\nMessages will be prepared for: %s\n", BBSID);
            printf("In conference %s.\n", ConfID);
            printf("\nUsing the following parameters:\n\n");
            printf("Addressee:         %s\n", tname);
            if (strlen(inetaddr))
                printf("Internet address:  %s\n", inetaddr);
            printf("Addressor:         %s\n", fname);
            printf("Lines per message: %d\n", lines);
            FillInMsgData(&msg);
            rc = SplitMessage(argv[2]);
        }
    }
    else
        rc = 1;

    return(rc);
}

int GetQWKInfo(char *qwkcfg)
{
    FILE *qi;
    char text[128];
    char *p;

    qi = fopen(qwkcfg, "r");
    if (qi)
    {
        while (fgets(text, sizeof(text), qi)!=NULL)
        {
            p = strrchr(text, '\n');
            if (p)
                *p = '\0';

            if (!strnicmp(text, "BBSID", 5))
            {
                p = text;
                p += 5;
                while ((isspace(*p)) && (*p)) p++;
                if (strlen(p) >= 8)
                    p[8] = '\0';
                strcpy(BBSID, p);
            }
            else if (!strnicmp(text, "CONFERENCE", 10))
            {
                p = text;
                p += 10;
                while ((isspace(*p)) && (*p)) p++;
                if (strlen(p) >= 7)
                    p[7] = '\0';
                strcpy(ConfID, p);
            }
            else if (!strnicmp(text, "TO", 2))
            {
                p = text;
                p += 2;
                while ((isspace(*p)) && (*p)) p++;
                if (strlen(p) >= 25)
                    p[25] = '\0';
                strcpy(tname, p);
            }
            else if (!strnicmp(text, "FROM", 4))
            {
                p = text;
                p += 4;
                while ((isspace(*p)) && (*p)) p++;
                if (strlen(p) >= 25)
                    p[25] = '\0';
                strcpy(fname, p);
            }
            else if (!strnicmp(text, "INTERNETTO", 10))
            {
                p = text;
                p += 10;
                while ((isspace(*p)) && (*p)) p++;
                if (strlen(p) >= 25)
                    p[25] = '\0';
                strcpy(inetaddr, p);
            }
            else if (!strnicmp(text, "PASSWORD", 8))
            {
                p = text;
                p += 8;
                while ((isspace(*p)) && (*p)) p++;
                if (strlen(p) >= 12)
                    p[12] = '\0';
                strcpy(password, p);
            }
            else if (!strnicmp(text, "LINES", 5))
            {
                p = text;
                p += 5;
                while ((isspace(*p)) && (*p)) p++;
                lines = atoi(p);
            }
        }
        fclose(qi);

        if (lines == 0)
            lines = 55;
        if (!strlen(tname))
            strcpy(tname, "ALL");

        return(0);
    }
    else
        return(2);
}

long GetLineCount(char *filename)
{
    FILE *f;
    char buf[256];
    long i = 0;

    printf("\nScanning %s...", filename);

    f = fopen(filename, "r");
    {
        while(fgets(buf, sizeof(buf), f)!=NULL)
            i++;

        fclose(f);
    }

    return(i);
}

int SplitMessage(char *filename)
{
    char mdat[128];
    char *p;
    FILE *bm;
    FILE *f;
    long lc;
    long hdrpos;
    long oldpos;
    long msgs;
    long i;
    long blks;
    int rc;

    rc = 0;
    memset(mdat, ' ', sizeof(mdat));
    strncpy(mdat, BBSID, strlen(BBSID));
    strcat(BBSID, ".MSG");

    bm = fopen(BBSID, "wb");
    if (bm)
    {
        lc = GetLineCount(filename);
        msgs = lc / lines;
        if (lc % lines)
            msgs++;
        printf("\n%ld lines, splitting %s into %ld messages...\n",
               lc, filename, msgs);

        fwrite(mdat, sizeof(mdat), 1, bm);

        f = fopen(filename, "r");
        if (f)
        {
            for(i = 0; i < msgs; i++)
            {
                hdrpos = ftell(bm);
                fwrite(&msg, sizeof(MSGDAT), 1, bm);

                blks = WriteMsgBlocks(f, bm);
                oldpos = ftell(bm);

                memset(&(msg.msg_blks), ' ', 6);
                sprintf(mdat, "%ld", ++blks);
                strncpy(msg.msg_blks, mdat, strlen(mdat));

                memset(&(msg.msg_subj), ' ', 25);
                sprintf(mdat, "Message %ld of %ld", i+1, msgs);
                strncpy(msg.msg_subj, mdat, strlen(mdat));

                fseek(bm, hdrpos, SEEK_SET);
                fwrite(&msg, sizeof(MSGDAT), 1, bm);

                fseek(bm, oldpos, SEEK_SET);
                printf("\nMessage #%ld complete...", i+1);
            }
            fclose(f);
        }
        else
            rc = 4;
        fclose(bm);
    }
    else
        rc = 3;

    return(rc);
}

long WriteMsgBlocks(FILE *f, FILE *bm)
{
    char buf[128];
    char blk[128];
    int blkpos;
    int ppos;
    char *p;
    long lc;
    long blocks;

    memset(blk, ' ', sizeof(blk));
    if (strlen(inetaddr))
    {
        sprintf(buf, "To: %s", inetaddr);
        strncpy(blk, buf, strlen(buf));
        blkpos = strlen(buf);
    }
    else
        blkpos = 0;

    blocks = 0;
    lc = 0;
    while (fgets(buf, sizeof(buf), f)!=NULL)
    {
        p = strrchr(buf, '\n');
        if (p)
            *p = '';
        else
            strcat(buf, "");
        p = blk;
        p += blkpos;
        ppos = sizeof(buf) - blkpos;
        if (strlen(buf)>=ppos)
        {
            strncpy(p, buf, ppos);
            fwrite(blk, sizeof(blk), 1, bm);
            memset(blk, ' ', sizeof(blk));
            if (strlen(buf)-ppos)
            {
                strncpy(blk, &buf[ppos], strlen(buf) - ppos);
                blkpos = strlen(buf) - ppos;
            }
            else
                blkpos = 0;
            blocks++;
        }
        else
        {
            strncpy(p, buf, strlen(buf));
            blkpos += strlen(buf);
        }
        lc++;
        if (lc >= lines)
            break;
    }
    if (blkpos)
    {
        fwrite(blk, sizeof(blk), 1, bm);
        blocks++;
    }
    return(blocks);
}
