/*
@echo off
cls
echo.
echo.
echo ERROR:
echo REXX support not installed
echo You must have REXX support installed to run this
echo program.
echo.
echo To run this program, run Selective Install from
echo your System Setup folder, and install REXX.
exit
*/
/*----------------------------------------------*/
/*-- REXX                                     --*/
/*----------------------------------------------*/
/*-- PROGRAM NAME:                            --*/
/*-- install                                  --*/
/*--                                          --*/
/*-- DESCRIPTION:                             --*/
/*-- Installs PMD 1.5 Demo                    --*/
/*----------------------------------------------*/
/*-- AUTHOR:                                  --*/
/*-- Kelly Schrock                            --*/
/*----------------------------------------------*/
/*-- DATE:                                    --*/
/*-- 05.29.94                                 --*/
/*----------------------------------------------*/

TRACE n
signal on HALT
call LoadLibs

/* Booleans */
InstallPMDGEN = 1
InstallDoc = 1
InstallBmp = 1
InstallExmp = 1
Custom = 0

/*-- get the command line --*/
parse arg sourcedir destdir

/*-- Do the intro --*/
call SysCls
say ''
say '                        PM Designer Demo Installation'
say ''

/*-- get dest dir --*/
if destdir = '' then do
  say ''
  say 'Please enter a directory name for PM Designer'
  say '(Default: C:\PMDDEMO):'
  parse pull destdir
  /*-- if error --*/
  if destdir = ' ' then destdir = 'C:\PMDDEMO'
end

if sourcedir = ' ' then do
  thisdir = directory()
  say ''
  say 'Please enter the directory where the program is being installed'
  say 'from(Default: 'thisdir'):'
  parse pull sourcedir
  /*-- if another error --*/
  if sourcedir = ' ' then do
    sourcedir = thisdir
    say 'using the current directory as the source directory.'
end

/*-- make sure path is good --*/
If substr( sourcedir, length(sourcedir), 1 ) \= '\' then
    sourcedir = sourcedir||'\'

/*-- do main screen --*/
call SysCls
say
say '                   PM Designer Demo Installation'
say
say 'The PM Designer demo will be installed with the following settings:'
say
say 'Source directory:      "'sourcedir'"'
say 'Destination directory: "'destdir'"'
say
say
say

if(AskYN('Okay to continue') = 0) then do
  say
  say 'Installation cancelled.'
  exit
end

/*-- Get the installation options --*/
do forever
  call SysCls
  say
  say '                   Installation Options'
  say
  say 'Please select one of the following:'
  say '(NOTE: Full install is recommended)'
  say
  say '1. Full installation'
  say '2. Custom installation'
  say '3. Exit'

  k = SysGetKey('NOECHO')
  select
    when k = '1' then do
      InstallPMDGEN   = 1
      InstallBmp      = 1
      InstallDoc      = 1
      InstallExmp     = 1
      Custom          = 0
      leave
    end
    when k = '2' then do
      InstallPMDGEN   = 0
      InstallBmp      = 0
      InstallDoc      = 0
      InstallExmp     = 0
      Custom          = 1
      leave
    end
    when k = '3' then
      exit
    otherwise
      say 'Your answer, 'k', is not a valid choice. Enter one of 1, 2, or 3.'
      say '(Press enter to continue)'
      pull confirm
  end  /* select */
end /* do */

if custom then do
  InstallPMDGEN = AskYN('Install code generator and associated files')
  InstallBMP = AskYN('Install the Bitmap library')
  InstallDoc = AskYN('Install the Documentation')
  InstallExmp = AskYN('Install the Example programs')
end

/*-- see if the dest directory exists --*/
Call SysFileTree destdir, file, 'D'

if file.0 = '0' then do
  /*-- create the dest. dir --*/
  rc = SysMkDir(destdir)
  if rc = 0 then do
    say 'The directory ' destdir ' was created successfully.'
  end
  else do
    say 'The directory ' destdir ' could not be created successfully; cancelling.'
    exit
  end
  /*-- Create the bin dir --*/
  rc = SysMkDir(destdir||'\bin')
  /*-- create the Projects dir --*/
  rc = SysMkDir(destdir||'\Projects')
  rc = SysMkDir(destdir||'\Projects\Project')
end

basedir = destdir

say 'Source dir: 'sourcedir
say 'Dest dir: 'basedir

/*-- copy the files --*/
call SysCls
say
say 'NOTE:'
say 'If you are installing this program from a floppy disk,'
say 'this process will take a few minutes.'
say ''
say
say 'Install is copying files, please wait...'
call CopyFile 'README.INF', sourcedir, basedir
call CopyFile 'PMD.ICO',   sourcedir, basedir||'\BIN'

say 'Install is unpacking files, please wait...'

'@view.exe '||destdir||'\readme Introduction'

/*--------------------------------------------------------------------*/
/* Install the individual archives                                    */
/*--------------------------------------------------------------------*/
/*-- unpack the PMDBIN.EXE archive --*/
say 'Unpacking program files...'
newdir = basedir||'\bin'
rc = SysMkDir(newdir)
if rc <> 0 & rc <> 5 then do
  say 'The destination directory could not be created.'
end
else do
  command = '@echo y |'||sourcedir||'PMDBIN.EXE /o 'newdir'>NUL'
  command
end

/*-- unpack the PMDGEN.EXE archive if needed --*/
/*
  This self-extractor will create the include,
  lib, and skeleton dirs for the files used by
  the PMDGEN generator.
*/
if InstallPMDGEN then do
  say 'Unpacking the code generator files...'
  newdir = basedir||'\pmdgen'
  rc = SysMkDir(newdir)
  if rc <> 0 & rc <> 5 then do
    say 'The destination directory 'newdir' could not be created.'
  end
  else do
    command = '@echo y |'||sourcedir||'PMDGEN.EXE /o 'newdir'>NUL'
    command
  end
end

/*-- unpack the PMDBMP.EXE archive if needed --*/
if InstallBMP then do
  say 'Unpacking bitmap library...'
  newdir = basedir||'\bitmap'
  rc = SysMkDir(newdir)
  if rc <> 0 & rc <> 5 then do
    say 'The destination directory 'newdir' could not be created.'
  end
  else do
    command = '@echo y|'||sourcedir||'PMDBMP.EXE /o 'newdir'>NUL'
    command
  end
end

/*-- unpack the PMDDOC.EXE archive if needed --*/
if InstallDoc then do
  say 'Unpacking documentation...'
  newdir = basedir||'\doc'
  rc = SysMkDir(newdir)
  if rc <> 0 & rc <> 5 then do
    say 'The destination directory 'newdir' could not be created.'
  end
  else do
    command = '@echo y |'||sourcedir||'PMDDOC.EXE /o 'newdir' > NUL'
    command
  end
end

/*-- unpack the PMDXMP.EXE archive if needed --*/
if InstallExmp then do
  say 'Unpacking example programs...'
  newdir = basedir||'\examples'
  rc = SysMkDir(newdir)
  if rc <> 0 & rc <> 5 then do
    say 'The destination directory 'newdir' could not be created.'
  end
  else do
    command = '@echo y |'||sourcedir||'PMDXMP.EXE /o 'newdir' > NUL'
    command
  end
end

/*---------------------------------------------------------------------------*/
/*-- Create the objects on the desktop                                     --*/
/*---------------------------------------------------------------------------*/
say
say 'Creating the program folder,'
x = SysCreateObject("WPFolder",,
                    "PM Designer Demo",,
                    "<WP_DESKTOP>",,
        "OBJECTID=<PMDDEMO>;ICONFILE="||destdir||"\BIN\PMD.ICO;OPEN=DEFAULT", "replace")
if x = 0 then do
  say 'Unable to create folder; cancelling.'
  exit
end

say 'Adding the'

say 'ReadMe file,'
x = SysCreateObject("WPProgram",,
                    "Read Me First",,
                    "<PMDDEMO>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\README.INF")

if InstallDoc then do
  say 'Manual,'
  x = SysCreateObject("WPProgram",,
                      "Manual",,
                      "<PMDDEMO>",,
                      "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\DOC\PMD.INF")

  say 'Developers guide,'
  x = SysCreateObject("WPProgram",,
                      "Developer's Guide",,
                      "<PMDDEMO>",,
                      "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\DOC\DEVGUIDE.INF")

  say 'API Reference,'
  x = SysCreateObject("WPProgram",,
                      "API Reference",,
                      "<PMDDEMO>",,
                      "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\DOC\PMDAPI.INF")
end /* InstallDoc */

say 'PM Designer,'
x = SysCreateObject("WPProgram",,
                    "PM Designer",,
                    "<PMDDEMO>",,
  "EXENAME="||destdir||"\BIN\PMD.EXE;STARTUPDIR="||destdir"\BIN;ASSOCFILTER=*.APP")

say 'Menu Editor,'
x = SysCreateObject("WPProgram",,
                    "Menu Editor",,
                    "<PMDDEMO>",,
  "EXENAME="||destdir||"\BIN\MENUEDIT.EXE;ASSOCFILTER=*.MNU")

say 'Text Editor,'
x = SysCreateObject("WPProgram",,
                    "PME",,
                    "<PMDDEMO>",,
  "EXENAME="||destdir||"\BIN\PME.EXE;ASSOCFILTER=*.C,*.CPP,*.H,*.HPP,*.IPF,*.MAK")

say 'Order form,'
x = SysCreateObject("WPProgram",,
                    "Order Form",,
                    "<PMDDEMO>",,
  "EXENAME=E.EXE;PARAMETERS="||destdir||"\DOC\ORDER.FRM")

say 'License Agreement,'
x = SysCreateObject("WPProgram",,
                    "License Agreement",,
                    "<PMDDEMO>",,
  "EXENAME=E.EXE;PARAMETERS="||destdir||"\DOC\LICENSE.TXT")


if InstallExmp then do
  say 'Examples folder,'
  x = SysCreateObject("WPShadow",,
                      "Examples",,
                      "<PMDDEMO>",,
    "SHADOWID="||destdir||"\EXAMPLES")
end /* InstallExmp */

say 'Projects folder,'
x = SysCreateObject("WPShadow",,
                    "Projects",,
                    "<PMDDEMO>",,
  "SHADOWID="||destdir||"\Projects")

say 'Project template,'
x = SysSetObjectData(destdir||"\Projects\project", "TEMPLATE=YES")
if x = 0 then do
  say 'Unable to set the "TEMPLATE" attribute on the project template.'
  say 'You will have to do this manually...'
  pull confirm
end

/*-- Create the template .RC and header files
in the projects\project folder --*/
templatedir = destdir||"\Projects\Project"
appfile = destdir||"\bin\newapp.app "
rcfile = templatedir||"\newapp.rc"
hdrfile = templatedir||"\newapp.h"


'@echo /* newapp.rc */ >>'||rcfile
'@echo /* newapp.h */ >>'||hdrfile
'@copy 'appfile templatedir
'@del ' appfile

if InstallBmp then do
  say 'Bitmaps folder,'
  x = SysCreateObject("WPShadow",,
                      "Bitmap",,
                      "<PMDDEMO>",,
    "SHADOWID="||destdir||"\Bitmap")
end /* InstallBmp */

say 'Creating SETENV.CMD...'
'@echo SET BOOKSHELF='destdir||'\DOC >> 'destdir||'\bin\setenv.cmd'
'@echo SET HELPNDX='destdir||'\BIN\PMDAPI.NDX >> 'destdir||'\bin\setenv.cmd'
'@echo SET PATH=%%PATH%%;'destdir||'\BIN >> 'destdir||'\bin\setenv.cmd'

GoodBye:
/*-- exit with a goodbye --*/
say
say 'Done.'
say
say
say 'PM Designer has been installed on your system.'
say
say 'Be sure to read the README file for up-to-date information.'
say

exit

/*----------------------------------------------*/
/*-- FUNCTION:                                --*/
/*-- LoadLibs                                 --*/
/*-- ACTION:                                  --*/
/*-- loads the libraries needed by this REXX  --*/
/*----------------------------------------------*/
LoadLibs:
  if RxFuncQuery('SysLoadFuncs') THEN
  do
    /*-- load the load-function --*/
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    /*-- load the Sys* utilities --*/
    CALL SysLoadFuncs
  end
return

HALT:
  say
  say 'Program cancelled; Interrupted by user.'
  exit

/*-----------------------------------------------------------------------------*/
/*-- CopyFile                                                                --*/
/*-----------------------------------------------------------------------------*/
CopyFile: Arg ArgFile2Copy, ArgSourceDir, ArgInstallDir

    Say 'Copying 'ArgSourceDir||ArgFile2Copy' to 'ArgInstallDir||'\'||ArgFile2Copy'...'
    Command = '@Copy 'ArgSourceDir||ArgFile2Copy' 'ArgInstallDir||'\'||ArgFile2Copy' >NUL'
    Command
    if rc \= 0 Then Do
        say 'Error! 'ArgFile2Copy' was not installed properly.'
        Pull ConfirmIt
    End
    Return

/*-----------------------------------------------------------------------------*/
/*-- AskYN: defaults to 'YES'                                                --*/
/*-----------------------------------------------------------------------------*/
AskYN: Arg argPrompt
  say
  Say argPrompt||'(Y/n)?'
  k = SysGetKey('NOECHO')
  if k = 'N' | k = 'n' then return 0
  else return 1

/*-----------------------------------------------------------------------------*/
/*-- AskNY: defaults to 'NO'                                                 --*/
/*-----------------------------------------------------------------------------*/
AskNY: Arg argPrompt
  say
  Say argPrompt||'(y/N)?'
  k = SysGetKey('NOECHO')
  if k = 'Y' | k = 'y' then return 1
  else return 0
