/* REXX Install for MaxFile/PM */
'@echo off'
Say "MaxFile/PM Installation Aid."
Say 'Copyright 1994 Craig Morrison, All Rights Reserved.'

Parse Upper Arg iDir .
If iDir = ' ' Then Do
    Say
    Say 'What directory do want to install MaxFile/PM in?'
    Pull iDir
    If iDir = ' ' Then Exit
End

iDir = Strip(iDir, 'T', '\')
cDir = Translate(Directory())
If iDir = cDir Then Do
    Say
    Say "Can't install to the current directory!"
    Say 'Please try again.'
    Exit
End

Say
Say 'MaxFile/PM will be installed in 'iDir', continue (Y or N)?'
Pull YesNo .

If YesNo \= 'Y' Then Do
    Say
    Say 'Installation aborted.'
    Exit
End

nDir = Directory(iDir)
nDir = Translate(Directory())
If nDir \= iDir Then 'MD 'iDir
nDir = Directory(iDir)
nDir = Translate(Directory())
if nDir \= iDir Then Do
    Say
    Say 'Error creating install directory 'iDir'!'
    Say 'Installation aborted.'
    Exit
End

nDir = Directory(cDir)

Command = 'COPY 'cDir'\* 'iDir
Say
Say 'Copying program files to 'iDir'.'
Say
Command
If rc \= 0 Then Do
    Say
    Say 'Error #'rc' occured while copying files.'
    Say 'MaxFile/PM was not installed correctly.'
    Say 'Installation aborted.'
    Exit
End

Say
Say 'Run INSOBJ to install WPS object (Y or N)?'
Pull YesNo .
If YesNo = 'Y' Then Do
    nDir = Directory(iDir)
    call insobj
    nDir = Directory(cDir)
End

Say
Say 'Run MaxFile/PM now (Y or N)?'
Pull YesNo .
If YesNo = 'Y' Then Do
    nDir = Directory(iDir)
    'maxfmpm'
    nDir = Directory(cDir)
End
