#  Copyright (C) 1993, 1994, Russell Lang.  All rights reserved.
#
# This file is part of GSview.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GSVIEW General Public License for more details.
#
# Everyone is granted permission to copy, modify and redistribute
# this program, but only under the conditions described in the GSVIEW
# General Public License.  A copy of this license is supposed to have been
# given to you along with this program so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# Makefile for GSview for Windows - GSVIEW.EXE or GSVIEW32.EXE
# using Borland C++ 3.1 or Borland C++ 4.0
# 'make -fgvwin.mak'
#

# Edit COMPBASE and WIN32 as required
COMPBASE = d:\bc4
# WIN32=1 for Win32s version
WIN32=0

# Shouldn't need editing below here
COMPDIR = $(COMPBASE)\bin
INCDIR = $(COMPBASE)\include
LIBDIR = $(COMPBASE)\lib
!if $(WIN32)
WINEXT=32
CC = bcc32
CCAUX = bcc
MODEL=32
CFLAGS=-v -W -w -H=gsview32.sym -I$(INCDIR)
!else
WINEXT=
CC = bcc
CCAUX = bcc
MODEL=m
CFLAGS=-v -m$(MODEL) -W -2 -h -w -H=gsview.sym -I$(INCDIR) $(OLD)
# uncomment following line if using GSview with gs 2.6.1
OLD=-DOLD
!endif
OBJS=gvwin.obj gvwinit.obj gvwclip.obj gvwdisp.obj gvwdlg.obj\
  gvweps.obj gvwmisc.obj gvwpipe.obj gvwprf.obj gvwprn.obj\
  gvcmisc.obj gvcdisp.obj gvcdsc.obj gvccmd.obj gvcprn.obj\
  gvceps.obj gvctext.obj

all: gsview$(WINEXT).exe gsview.hlp doc2tex.exe

.c.obj:
	$(COMPDIR)\$(CC) -c $(CFLAGS) {$< }

	
gsview32.exe: $(OBJS) gvwin32.res gvwin32.def
	$(COMPDIR)\tlink32 -Tpe -c -m -s -v @&&!
$(LIBDIR)\c0w32 +
$(OBJS) +
,gsview32.exe,gsview32, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32, +
gvwin32.def, +
gvwin32.res
!

gsview.exe: $(OBJS) gvwin.res gvwin.def
	$(COMPDIR)\tlink /Twe /c /m /s /v /l @&&!
$(LIBDIR)\c0w$(MODEL) +
$(OBJS) +
,gsview.exe,gsview, +
$(LIBDIR)\import +
$(LIBDIR)\mathw$(MODEL) +
$(LIBDIR)\cw$(MODEL), +
gvwin.def
!
	$(COMPDIR)\rlink -30 -t gvwin.res gsview.exe

gvwin32.res: gvwin.rc gvwin2.rc gvcrc.h $(ICONS)
	$(COMPDIR)\brcc32 -i$(INCDIR) -r -fogvwin32 gvwin

gvwin.res: gvwin.rc gvwin2.rc gvcrc.h $(ICONS)
	$(COMPDIR)\brcc -i$(INCDIR) -r gvwin


gvwin.obj: gvwin.c gvwin.h gvcdsc.h

gvwclip.obj: gvwclip.c gvwin.h gvcdsc.h

gvwdisp.obj: gvwdisp.c gvwin.h gvcdsc.h

gvwdlg.obj: gvwdlg.c gvwin.h gvcdsc.h gvcrc.h

gvweps.obj: gvweps.c gvceps.h gvwin.h gvcdsc.h

gvwinit.obj: gvwinit.c gvwin.h gvcdsc.h

gvwmisc.obj: gvwmisc.c gvwin.h gvcdsc.h

gvwpipe.obj: gvwpipe.c gvwin.h gvcdsc.h

gvwprn.obj: gvwprn.c gvwin.h gvcdsc.h

gvccmd.obj: gvccmd.c gvwin.h gvcdsc.h gvcrc.h

gvcdisp.obj: gvcdisp.c gvwin.h gvcdsc.h

gvcdsc.obj: gvcdsc.c gvwin.h gvcdsc.h

gvceps.obj: gvceps.c gvceps.h gvwin.h gvcdsc.h

gvcmisc.obj: gvcmisc.c gvwin.h gvcdsc.h gvcrc.h

gvcprn.obj: gvcprn.c gvwin.h gvcdsc.h

gvctext.obj: gvctext.c gvwin.h gvcdsc.h

gvdoc.exe: gvdoc.c
	$(COMPDIR)\$(CCAUX) -w-pro -I$(INCDIR) -L$(LIBDIR) gvdoc.c

gsview.doc: gvc.doc gvdoc.exe
	gvdoc W gvc.doc gsview.doc

doc2rtf.exe: doc2rtf.c
	$(COMPDIR)\$(CCAUX) -w-pro -I$(INCDIR) -L$(LIBDIR) doc2rtf.c

gsview.dvi: gsview.tex titlepag.tex
	latex gsview
	latex gsview

gsview.tex: gsview.doc doc2tex.exe
	doc2tex gsview.doc gsview.tex

doc2tex.exe: doc2tex.c
	$(COMPDIR)\$(CCAUX) -w-pro -I$(INCDIR) -L$(LIBDIR) doc2tex.c

gsview.hlp: doc2rtf.exe gsview.doc gsview.hpj
	doc2rtf gsview.doc gsview.rtf
	$(COMPDIR)\hc31 gsview.hpj

strip: gsview$(WINEXT).exe
!if $(WIN32)
	$(COMPDIR)\tdstrp32 gsview32.exe
!else
	$(COMPDIR)\tdstrip gsview.exe
!endif

prezip:
	copy gsview$(WINEXT).exe ..\gsview$(WINEXT).exe
!if $(WIN32)
	$(COMPDIR)\tdstrp32 ..\gsview32.exe
!else
	$(COMPDIR)\tdstrip ..\gsview.exe
!endif
	copy gsview.hlp ..\gsview.hlp
	copy README.gv ..\README.gv
	-del ..\gsview.zip

zip: prezip
	cd ..
	copy src\gvclist.doc gvclist.doc
	zip -@ gsview.zip < gvclist.doc
	del gvclist.doc
	cd src

clean:
	del gvwin.obj
	del gvwclip.obj
	del gvwdisp.obj
	del gvwdlg.obj
	del gvweps.obj
	del gvwinit.obj
	del gvwmisc.obj
	del gvwpipe.obj
	del gvwprn.obj
	del gvcmisc.obj
	del gvcdisp.obj
	del gvcdsc.obj
	del gvccmd.obj
	del gvceps.obj
	del gvwprf.obj
	del gvcprn.obj
	del gvctext.obj
	del gsview.map
	del gsview32.map
	del gsview.sym
	del gsview32.sym
	del gvwin.res
	del gvwin32.res
	del gsview.rtf
	del doc2rtf.obj
	del doc2rtf.exe
	del doc2tex.obj
	del gvdoc.exe
	del gvdoc.obj
	del gsview.doc
	del gsview.aux
	del gsview.dvi
	del gsview.log
	del gsview.toc
	del gsview.tex

veryclean: clean
	del gsview$(WINEXT).exe
	del gsview.hlp
	del doc2tex.exe
