#  Copyright (C) 1993, 1994, Russell Lang.  All rights reserved.
#
# This file is part of GSview.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GSVIEW General Public License for more details.
#
# Everyone is granted permission to copy, modify and redistribute
# this program, but only under the conditions described in the GSVIEW
# General Public License.  A copy of this license is supposed to have been
# given to you along with this program so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# gvpm.mak
# PM GSview 
# requires emx 0.8h
#
# edit COMPBASE and EMXPATH as required.

# set USE_EMX=0 for BCC
# set USE_EMX=1 for EMX/GCC
USE_EMX=1
# USE_OMF=1 for EMX/GCC with LINK386
USE_OMF=0

!if $(USE_EMX)
# EMX
DRIVE=e:
COMP=gcc
COMPBASE=$(DRIVE)\emx
EMXPATH=$(DRIVE)/emx
!if $(USE_OMF)
FLAGS=-Zomf -Zmts -g
OBJ=obj
!else
FLAGS=-Zmts -g
OBJ=o
!endif
!else
# BCC flags
COMP=bcc
COMPBASE=d:\bcos2
EMXPATH=d:/bcos2
FLAGS=-v -I$(INCDIR) -sm
OBJ=obj
!endif

# ICC flags
#COMP=icc
#COMPBASE=c:\ibmc
#EMXPATH=c:/ibmc
#FLAGS=/Gm /Ti /Sm /Ic:\toolkt20\c\os2h;c:\ibmc\include -DNO_MMOS2
#OBJ=obj

COMPDIR=$(COMPBASE)\bin
INCDIR=$(EMXPATH)/include
LIBDIR=$(EMXPATH)/lib


OBJS=gvpm.$(OBJ) gvpdlg.$(OBJ) gvpdisp.$(OBJ) gvpeps.$(OBJ) gvpinit.$(OBJ)\
   gvpmisc.$(OBJ) gvpprn.$(OBJ)\
   gvccmd.$(OBJ) gvcdisp.$(OBJ) gvcdsc.$(OBJ) gvceps.$(OBJ) gvcmisc.$(OBJ)\
   gvcprf.$(OBJ) gvcprn.$(OBJ) gvctext.$(OBJ)

all: gvpm.exe gvpm.hlp gvpm.inf gvpm.tex

.c.$(OBJ):
	$(COMP) $(FLAGS) -DOS2 -c $*.c


gvpm.$(OBJ): gvpm.c gvpm.h gvcdsc.h gvpm.ipf

gvpdlg.$(OBJ): gvpdlg.c gvpm.h gvcdsc.h gvcrc.h

gvpdisp.$(OBJ): gvpdisp.c gvpm.h gvcdsc.h

gvpeps.$(OBJ): gvpeps.c gvpm.h gvceps.h gvcdsc.h

gvpinit.$(OBJ): gvpinit.c gvpm.h gvcdsc.h

gvpmisc.$(OBJ): gvpmisc.c gvpm.h gvcdsc.h

gvpprn.$(OBJ): gvpprn.c gvpm.h gvcdsc.h

gvccmd.$(OBJ): gvccmd.c gvpm.h gvcdsc.h gvcrc.h

gvcdisp.$(OBJ): gvcdisp.c gvpm.h gvcdsc.h

gvcdsc.$(OBJ): gvcdsc.c gvpm.h gvcdsc.h

gvceps.$(OBJ): gvceps.c gvpm.h gvcdsc.h

gvcmisc.$(OBJ): gvcmisc.c gvpm.h gvcdsc.h gvcrc.h

gvcprn.$(OBJ): gvcprn.c gvpm.h gvcdsc.h

gvcprf.$(OBJ): gvcprf.c gvpm.h

gvctext.$(OBJ): gvctext.c gvpm.h gvcdsc.h

gvpm.res: gvpm.rc gvpm.h binary\gvpm.ico
	rc -i $(COMPBASE)\include -r $*.rc

gvpm.exe: $(OBJS) gvpm.res gvpm.def
!if $(USE_EMX)
!if $(USE_OMF)
	$(COMP) $(FLAGS) -o gvpm $(OBJS) gvpm.def
	rc gvpm.res gvpm.exe
!else
	$(COMP) $(FLAGS) -o gvpm $(OBJS)
	emxbind -p -rgvpm.res -dgvpm.def $(COMPDIR)\emxl.exe gvpm gvpm.exe
	del $*
!endif
!else
	$(COMP) $(FLAGS) -egvpm.exe $(OBJS)
	RC gvpm.res gvpm.exe
!endif

gvdoc.exe: gvdoc.c
!if $(USE_EMX)
	$(COMP) -o $* $*.c
	emxbind $(COMPDIR)\emxl.exe $* $*.exe
	del $*
!else
	$(COMP) $*.c
!endif
	
doc2ipf.exe: doc2ipf.c
!if $(USE_EMX)
	$(COMP) -o $* $*.c
	emxbind $(COMPDIR)\emxl.exe $* $*.exe
	del $*
!else
	$(COMP) $*.c
!endif

gvpm.doc: gvc.doc gvdoc.exe
	gvdoc P gvc.doc gvpm.doc

gvpm.ipf: gvpm.doc doc2ipf.exe 
	doc2ipf gvpm.doc gvpm.ipf gvphelp.h

gvpm.hlp: gvpm.ipf
	ipfc gvpm.ipf
	rename gvpm.HLP gvpm.hlp

gvpm.inf: gvpm.ipf
	ipfc /INF gvpm.ipf
	rename gvpm.INF gvpm.inf

gvpm.dvi: gvpm.tex titlepag.tex
	-latex gvpm
	-latex gvpm

gvpm.tex: gvpm.doc doc2tex.exe
	doc2tex gvpm.doc gvpm.tex

doc2tex.exe: doc2tex.c
!if $(USE_EMX)
	$(COMP) -o $* $*.c
	emxbind $(COMPDIR)\emxl.exe $* $*.exe
	del $*
!else
	$(COMP) $*.c
!endif


prezip:
	copy gvpm.exe ..
	emxbind -s ../gvpm.exe
	copy gvpm.hlp ..
	copy gvpm.inf ..
	copy README.GV ..
	-del ..\gsview.zip

zip: prezip
	cd ..
	zip -@ gsview.zip < src/gvclist.doc
	cd src

clean:
	-del gvpm.res
	-del gvpm.$(OBJ)
	-del gvpdlg.$(OBJ)
	-del gvpdisp.$(OBJ)
	-del gvpeps.$(OBJ)
	-del gvpinit.$(OBJ)
	-del gvpmisc.$(OBJ)
	-del gvpprn.$(OBJ)
	-del gvccmd.$(OBJ)
	-del gvcdisp.$(OBJ)
	-del gvcdsc.$(OBJ)
	-del gvceps.$(OBJ)
	-del gvcmisc.$(OBJ)
	-del gvcprf.$(OBJ)
	-del gvcprn.$(OBJ)
	-del gvctext.$(OBJ)
	-del doc2ipf.$(OBJ)
	-del doc2ipf.exe
	-del doc2tex.$(OBJ)
	-del doc2tex.exe
	-del gvdoc.$(OBJ)
	-del gvdoc.exe
	-del gvpm.ipf
	-del gvpm.doc
	-del gvpm.aux
	-del gvpm.dvi
	-del gvpm.log
	-del gvpm.toc
	-del gvphelp.h

veryclean: clean
	-del gvpm.exe
	-del gvpm.hlp
	-del gvpm.inf
	-del gvpm.tex
