/*  Copyright (C) 1993, 1994, Russell Lang.  All rights reserved.

 This file is part of GSview.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GSVIEW General Public License for more details.

 Everyone is granted permission to copy, modify and redistribute
 this program, but only under the conditions described in the GSVIEW
 General Public License.  A copy of this license is supposed to have been
 given to you along with this program so you can know your rights and
 responsibilities.  It should be in a file named COPYING.  Among other
 things, the copyright notice and this notice must be preserved on all
 copies. */

/* gvdoc.c */
/* Preprocess doc file
 *
 * usage:  gvdoc W infile.doc outfile.doc
 *
 *   where infile.doc is a GSview superset of a Gnuplot .DOC file 
 *   supporting conditionals and outfile.doc is a gnuplot style .DOC file.
 *
 * typical usage for GSview:
 *
 *   for Windows:
 *     gvdoc W gvc.doc gsview.doc
 *     doc2rtf gsview.doc gsview.rtf
 *     hc31 gsview.hpj
 *
 *   for OS/2:
 *     gvdoc P gvc.doc gsview.doc
 *     doc2ipf gsview.doc gvpm.ipf
 *     ipfc gvpm.ipf
 *     ipfc /INF gvpm.ipf
 *     
 */

#include <stdio.h>
#include <ctype.h>

#define MAX_NAME_LEN	256
#define MAX_LINE_LEN	256
#define TRUE 1
#define FALSE 0

typedef int boolean;

char start;
char end = 'E';
boolean ignore = FALSE;
char line[MAX_LINE_LEN];

int
main(int argc, char *argv[])
{
FILE * infile;
FILE * outfile;
	infile = stdin;
	outfile = stdout;
	if (argc != 4) {
		fprintf(stderr,"Usage: %s W|P infile outfile\n", argv[0]);
		return 1;
	}
	start = argv[1][0];
	if ( (infile = fopen(argv[2],"r")) == (FILE *)NULL) {
		fprintf(stderr,"%s: Can't open %s for reading\n",
			argv[0], argv[2]);
		return 1;
	}
	if ( (outfile = fopen(argv[3],"w")) == (FILE *)NULL) {
		fprintf(stderr,"%s: Can't open %s for writing\n",
			argv[0], argv[3]);
	}
	
	while (fgets(line, MAX_LINE_LEN, infile)) {
	    if ( (line[0] == start) || (line[0] == end) )
		ignore = FALSE;
	    else if (isalpha(line[0]))
		ignore = TRUE;
	    else if (!ignore)
		fputs(line, outfile);
	}
	fclose(outfile);
	return 0;
}
