/* usuals.h - The usual typedefs, etc.
*/
#ifndef USUALS /* Assures no redefinitions of usual types...*/
#define USUALS

typedef unsigned char boolean;	/* values are TRUE or FALSE */
typedef unsigned char byte; /* values are 0-255 */
typedef unsigned short word16;	/* values are 0-65535 */
typedef unsigned long word32;	/* values are 0-4294967295 */

#define fill0(buffer,count)	memset( buffer, 0, count )
#define burn(x) fill0((void *)&(x),sizeof(x))

#endif	/* if USUALS not already defined */
