            STRUC       DeviceHeader
                        Next        DD          ?
                        Attr        DW          ?
                        Strategy    DW          ?
                        Interrupt   DW          ?
                        NofUnits    DB          ?
                                    DB          7 DUP(?)
            ENDS        DeviceHeader

            STRUC       BPBRec
                        SectSize    DW          200h
                        ClustSize   DB          4
                        ResSects    DW          1
                        FATCount    DB          2
                        RootSize    DW          70h
                        TotSects    DW          2D0h
                        Media       DB          0FDh
                        FATSize     DW          6h
                        TrackSize   DW          ?
                        HeadCount   DW          ?
                        HiddenSects DD          ?
                        HiTotSects  DD          ?
            ENDS        BPBRec

            STRUC       RequestHeader
                        Length      DB          ?
                        Unit        DB          ?
                        Command     DB          ?
                        Status      DW          ?
                        Reserved    DB          8 DUP (?)
            ENDS
; values for command:

dvcmInit    =           0
dvcmMediaChk=           1
dvcmBuildBPB=           2
dvcmInput   =           4
dvcmOutput  =           8

dverWriteProtectFailure =           0
dverUnknownUnit         =           1
dverDeviceNotReady      =           2
dverUnknownCommand      =           3
dverCRCError            =           4
dverBadRequestLength    =           5
dverSeekError           =           6
dverUnknownMedia        =           7
dverSectorNotFound      =           8
dverGeneralFailure      =          0Ch
dverInvalidDiskChange   =          0Fh
; status bit fields:
swError     =           8000h
swDone      =            100h

            STRUC       IORequest
                        Header      RequestHeader           <>
                        MediaDesc   DB          ?
                        Buffer      DD          ?
                        Count       DW          ?
                        Sector      DW          ?
                        VolumeIDPtr DD          ?
                        Sector32b   DD          ?
            ENDS        IORequest

            STRUC       InitRequest
                        Header      RequestHeader           <>
                        NofUnits    DB          ?
                        EndAddress  DD          ?
                        UNION
                                    ReturnBPB   DD          ?
                                    ParamStr    DD          ?
                        ENDS
                        DriveNo     DB          ?
                        ErrorMsg    DW          ?
            ENDS        InitRequest

            STRUC       MChkRequest
                        Header      RequestHeader           <>
                        MediaDesc   DB          ?
                        Result      DB          ?
                        VolumeIDPtr DD          ?
            ENDS        MChkRequest
            STRUC       BBPBRequest
                        Header      RequestHeader           <>
                        MediaDesc   DB          ?
                        BufferPtr   DD          ?
                        BPBPtr      DD          ?
            ENDS        BBPBRequest
