#include "class(y).ch"
#Include "Box.ch"

/*Ŀ
      ClassWindow                                                          
    PurposeA Window Class to creat windows on the screen. To give them     
           headers, titles and anything else we can think of               
  Date-Time14/05/93      00:28:41                                          
  CopyrightL&W Computer Services Ltd.                                      
     AuthorDarren Lancaster                                                
  
*/

CREATE CLASS Window

   METHOD SayColor, WhoAmI

EXPORT:
   VAR Cargo
   VAR nTop, nLeft, nHeight, nWidth, nBottom, nRight,;
       MaxRow, MaxCol, nRow, nCol                              TYPE NUMERIC
   VAR cWindow, cOldScreen, cTitle, cTitleColor, cBackColor,;
       cOffColor                                               TYPE CHARACTER
   VAR lCanBeSeen, lFocus, lDisplayed                          TYPE LOGICAL

   CLASS VAR aStack                                            TYPE ARRAY
   MESSAGE aStack TO CLASS

   METHOD Init, Display, Hide, Show, Close, paint, Title, HideAll, HideWindow,;
          ShowWindow, SaveFront, RestFront, Say, SayC, DrawAll, Clear, DispWindow

   MESSAGE SetPos  METHOD Pos

   CLASS METHOD CloseAll

END CLASS

/*Ŀ
     Methodinit(nTop, nLeft, nHeight, nWidth, cTitle)                      
    PurposeThis method is used to set up all the vars for the object       
                                                                           
            nTop        : the top row, where the window will start         
            nLeft       : the left column, where the window will start     
            nHeight     : the number of rows that the window uses          
            nWidth      : the number of columns the window takes up        
            cTitleColor : the Title header color for the window            
            cBackColor  : the Window pane color                            
            cTitle      : the text to diaplay in the title bar             
            lCanBeSeen  : is the window being displayed                    
            aStack      : stack used to hold window number and position    
            lFocus      : is the window the output window                  
                                                                           
                                                                           
  Date-Time14/05/93      00:28:45                                          
  CopyrightL&W Computer Services Ltd.                                      
     AuthorDarren Lancaster                                                
  
*/
METHOD init(nTop, nLeft, nHeight, nWidth, cTitle)

   IF nTop != NIL .AND. nLeft != NIL .AND. ValType(nHeight) != "N"
      cTitle  := nHeight
      nHeight := nTop
      nWidth  := nLeft
      nTop    := NIL
      nLeft   := NIL
   ENDIF

   IF nTop == NIL
      nTop    := MaxRow() / 2 - (nHeight + 4) / 2
   ENDIF

   IF nLeft == NIL
      nLeft   := MaxCol() / 2 - (nWidth + 2) / 2
   ENDIF

   IF nWidth < 1
      nWidth := 1
   ENDIF
   IF nHeight < 1
      nHeight := 1
   ENDIF

   ::nTop := Int(nTop)
   ::nLeft := Int(nLeft)
   ::nHeight := Int(nHeight)
   ::nWidth := Int(nWidth)
   ::cOffColor := "W+"
   ::cTitleColor := "GR+"
   ::cBackColor := "B"
   ::cTitle := If( !Empty(cTitle), cTitle,"")
   ::lCanBeSeen := ::lDisplayed := .F.

   IF VALTYPE(::aStack) != "A"
      :: class:aStack := {}
   ENDIF

   aAdd(:: class:aStack, self)

   ::lFocus := .F.
   ::nBottom := Int(nTop + nHeight + 3)
   ::nRight := Int(nLeft + nWidth + 1)
   ::nRow := ::nCol := 0
   ::MaxRow := nHeight - 1
   ::MaxCol := nWidth - 1

RETURN self

/*Ŀ
     Methodclose                                                           
    PurposeTo remove the window from the stack and the display             
  Date-Time14/05/93      00:28:48                                          
  CopyrightL&W Computer Services Ltd.                                      
     AuthorDarren Lancaster                                                
  
*/
METHOD Close

   @:Hide()
   aDel(::aStack, @:WhoAmI())
   aSize(::aStack, LEN(::aStack)-1)

RETURN self

/*Ŀ
     MethodWhoAmI() --> <nWindowNumber>                                    
    PurposeWhich window am I?                                              
  Date-Time05-24-93      09:55:42pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD WhoAmI
RETURN (aScan(::aStack, {|oWindow| oWindow == self }))

/*Ŀ
     MethodDisplay([<lFocus>]) --> self                                    
    Purposeto draw a new window on the screen. Save the background first   
           draw the box, draw the title                                    
  Date-Time14/05/93      00:28:55                                          
  CopyrightL&W Computer Services Ltd.                                      
     AuthorDarren Lancaster                                                
  
*/
METHOD Display(lFocus)

   LOCAL oTemp, cSetColor

   IF ::lDisplayed
      @:Show()
   ELSE
      IF ValType(lFocus) != "L"
         lFocus := .T.
      ENDIF

      IF !::lFocus
         IF LEN(::aStack) > 1
            IF lFocus
               oTemp := ::aStack[LEN(::aStack) - 1]
               oTemp:lFocus := .F.
               cSetColor := SetColor(oTemp:cOffColor + "/" + oTemp:cBackColor)
               SetColor(cSetColor)
               oTemp:SaveFront()
            ELSE
               oTemp := Atail(::aStack)
               aIns(::aStack, Len(::aStack) - 1)
               ::aStack[Len(::aStack) - 1] := oTemp
            ENDIF
         ENDIF
      ENDIF

      ::cOldScreen := SaveScreen(::nTop, ::nLeft, ::nBottom, ::nRight)

      ::lCanBeSeen := .T.
      ::lFocus := lFocus
      @:Paint()
      ::lDisplayed := .T.
   ENDIF

RETURN self

/*Ŀ
     MethodPaint() --> self                                                
    PurposePaint the window                                                
  Date-Time05-19-93      11:51:13am                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD Paint

   LOCAL cColor

   IF ::lCanBeSeen
      DispBegin()
      cColor := SetColor(If(::lFocus, ::cTitleColor, ::cOffColor) + "/" + ::cBackColor)

      ::DispWindow(.T.)
      @:Title()

      ::cWindow := ""

      SetColor(cColor)
      DispEnd()
   ENDIF

RETURN (self)

/*Ŀ
     MethodTitle() --> self                                                
    PurposeDisplay the Title                                               
  Date-Time05-19-93      12:01:10pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD Title()

   IF ::lCanBeSeen
      @ ::nTop + 1, ::nLeft + 1 SAY PadC(::cTitle, ::nWidth) COLOR ::cTitleColor + "/" + ::cBackColor
   ENDIF

RETURN (self)


/*Ŀ
     Methodshow                                                            
    Purposeto show a window that has been hidden                           
  Date-Time14/05/93      00:28:53                                          
  CopyrightL&W Computer Services Ltd.                                      
     AuthorDarren Lancaster                                                
  
*/
METHOD Show
   LOCAL nX := 0, nWhoAmI := 0

   DispBegin()
   @:HideAll()

   FOR nX := 1 TO LEN(:: class:aStack)
      IF !(:: class:aStack[nX] == self)
         :: class:aStack[nX]:lFocus := .F.
      ELSE
         nWhoAmI := nX
      ENDIF
   NEXT
   ::lFocus := .T.
   ::lCanBeSeen := .T.

   ADEL(:: class:aStack, nWhoAmI)
   :: class:aStack[ LEN(:: class:aStack) ] := self

   @:DrawAll()
   DispEnd()

RETURN self


/*Ŀ
     MethodHide                                                            
    Purposeto restore the background and hide the window                   
  Date-Time14/05/93      00:28:59                                          
  CopyrightL&W Computer Services Ltd.                                      
     AuthorDarren Lancaster                                                
  
*/
METHOD Hide
   LOCAL nX, nWhoIsFocus := 0, oTemp

   IF ::lCanBeSeen
      DispBegin()
      @:HideAll()

      ::lCanBeSeen := .F.
      ::lFocus := .F.

      FOR nX := 1 TO Len(::aStack)
         IF ::aStack[nX]:lCanBeSeen
            nWhoIsFocus := nX
         ENDIF
         ::aStack[nX]:lFocus := .F.
      NEXT nX

      IF nWhoIsFocus > 0
         ::aStack[nWhoIsFocus]:lFocus := .T.

         oTemp := ::aStack[nWhoIsFocus]            // Move newly focussed widow to top
         aDel(::aStack, nWhoIsFocus)
         ::aStack[Len(::aStack)] := oTemp
      ENDIF

      @:DrawAll()
      DispEnd()
   ENDIF

RETURN self

/*Ŀ
     MethodHideAll() --> self                                              
    PurposeHide all the windows in the right order                         
  Date-Time05-19-93      12:21:18pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD HideAll
   LOCAL nX

   FOR nX := Len(::aStack) TO 1 STEP -1
      IF ::aStack[nX]:lCanBeSeen
         ::aStack[nX]:HideWindow()
      ENDIF
   NEXT nX
RETURN(Self)

/*Ŀ
     MethodDrawAll() --> self                                              
    PurposeDraw all of the windows                                         
  Date-Time05-19-93      11:24:14am                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD DrawAll

   LOCAL nX

   FOR nX := 1 TO Len(::aStack)
      IF ::aStack[nX]:lCanBeSeen
         ::aStack[nX]:ShowWindow()
      ENDIF
   NEXT nX

RETURN (self)

/*Ŀ
     MethodHideWindow() --> self                                           
    PurposeSave the image of the window and hide it                        
  Date-Time05-19-93      12:30:18pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD HideWindow
   IF ::lCanBeSeen
      @:SaveFront()
      RestScreen(::nTop, ::nLeft, ::nBottom, ::nRight, ::cOldScreen)
   ENDIF
RETURN (self)

/*Ŀ
     MethodShowWindow                                                      
    PurposeRestore the window back to the screen                           
  Date-Time05-19-93      12:31:57pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD ShowWindow

   LOCAL cSetColor := SetColor(If(::lFocus, ::cTitleColor, ::cOffColor) + "/" + ::cBackColor)

   ::cOldScreen := SaveScreen(::nTop, ::nLeft, ::nBottom, ::nRight)
   @:RestFront()

   SetColor(cSetColor)

RETURN (self)

/*Ŀ
     MethodSaveFront() --> self                                            
    PurposeSave the image of the window                                    
  Date-Time05-19-93      12:40:05pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD SaveFront
   IF ::lCanBeSeen
      ::cWindow := SaveScreen(::nTop, ::nLeft, ::nBottom, ::nRight)
   ENDIF
RETURN (self)

/*Ŀ
     MethodRestFront() --> self                                            
    PurposeRestore the image of the window                                 
  Date-Time05-19-93      12:40:42pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD RestFront
   IF ::lCanBeSeen
      RestScreen(::nTop, ::nLeft, ::nBottom, ::nRight, ::cWindow)
   ENDIF
RETURN (self)

/*Ŀ
     MethodSetPos([<nRow>], [<nCol>]) --> self                             
    PurposePosition the windows' cursor                                    
  Date-Time05-19-93      12:50:03pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD Pos(nRow, nCol)
   ::nRow := If(ValType(nRow) == "N", Min(nRow, ::MaxRow), ::nRow)
   ::nCol := If(ValType(nCol) == "N", Min(nCol, ::MaxCol), ::nCol)
RETURN (self)

/*Ŀ
     MethodSay(<cString>, [<cForColour>]) --> self                         
    PurposeDisplay a string in the window                                  
  Date-Time05-19-93      12:52:31pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD Say(cString, cColour)

   @ ::nRow + ::nTop + 3, ::nCol + ::nLeft + 1 SAY Left(cString, ::nRight - (::nCol + ::nLeft) - 1) COLOR ::SayColor(cColour)
   ::nCol += Len(cString)

RETURN (self)

/*Ŀ
     MethodSayColour(<cColour>) --> <cFullColour>                          
    PurposeGet the complete colour string worked out                       
  Date-Time05-19-93      01:58:41pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD SayColor(cColour)

   IF ValType(cColour) != "C"
      cColour := "GR+/" + ::cBackColor
   ELSEIF !("/" $ cColour)
      cColour += "/" + ::cBackColor
   ENDIF

RETURN(cColour)

/*Ŀ
     MethodSayC(<cString>, [<cColour>]) --> self                           
    PurposeDisplay a centred string in the window                          
  Date-Time05-19-93      12:57:10pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD SayC(cString, cColour)

   ::nCol := 0
   @:Say(PadC(cString, ::MaxCol + 1), cColour)

RETURN (self)

/*Ŀ
     MethodClear() --> self                                                
    PurposeClear area of window                                            
  Date-Time05-27-93      02:55:04pm                                        
  CopyrightL&W Computer Services Ltd.                                      
     AuthorIan Day                                                         
  */
METHOD Clear

   @ ::nTop + 3, ::nLeft + 1 CLEAR TO ::nBottom - 1, ::nRight - 1

RETURN (self)

/*Ŀ
     Method                                                                
    Purpose                                                                
  Date-Time07-09-93      09:07:43pm                                        
  CopyrightAWE&BS Ltd                                                      
     AuthorIan Day                                                         
  */
METHOD CloseAll

   @:HideAll()
   ::aStack := {}

RETURN (self)


/* Method Ŀ
           Name: DispWindow()                                               
    Description: Draw a window                                              
         Author: Darren Lancaster                                           
   Date created: 29-06-94              Date updated: 29-06-94              
   Time created: 11:53:31am            Time updated: 11:53:31am            
      Copyright: L&W Computer Services Ltd                                  
  
*/
METHOD DispWindow(lClear)

   IF lClear
      Scroll (::nTop, ::nLeft, ::nBottom, ::nRight, 0, 0)
   ENDIF

   DispBox(::nTop, ::nLeft, ::nBottom, ::nRight, B_DOUBLE)
   @ ::nTop+2, ::nLeft SAY ""
   @ ::nTop+2, ::nRight SAY ""
   DispBox(::nTop+2, ::nLeft+1, ::nTop+2, ::nRight-1, B_DOUBLE)
RETURN(self)

