*
*------------------------------------------------------------------------*
*                                                                        *
* Program... : INTERNAT.PRG                                              *
* Editor.... : Clayton Neff                                              *
* Created... : 3/1/1990 at 11:41                                         *
* Copyright (c) 1986-1990 by Alfa-Laval Agri, Inc.                       *
*                            All Rights Reserved                         *
*                                                                        *
*........................................................................*
*
* This routine is a pure Clipper solution to the problem of converting
* a date string of the form CCYYMMDD to a Clipper date variable without
* knowing the current setting of SET DATE TO.
*
*------------------------------------------------------------------------*
*
function StoD_All
*
parameters date_string
*
private century_on, date_type, date_char
private year_string, month_string, day_string, date_back
*
*- First, check to see if SET CENTURY is ON.
*
if ( len( date() ) == 10 )
   century_on = .t.
   year_string = substr( date_string, 1, 4 )
else
   set century on
   century_on = .f.
   year_string = substr( date_string, 3, 2 )
endif
*
month_string = substr( date_string, 5, 2 )
day_string = substr( date_string, 7, 2 )
*
*- Determine proper format to build returning date.
*
date_char = dtoc( date() )
if ( at( '-', date_char ) == 0 )
   *
   *- This means it is _not_ Italian.
   *
   if ( at( '.', date_char ) == 0 )
      *
      *- This means it is _not_ ANSI or German.
      *
      if ( val( substr( date_char, 1, 2 ) ) == month( date() ) )
         *
         *- This means it is American (or day and month are the same).
         *
         date_type = "American"
      else
         date_type = "British"
      endif
   else
      if ( at( '.', date_char ) == 4 )
         *
         *- This means it is ANSI (we SET CENTURY ON).
         *
         date_type = "ANSI"
      else
         date_type = "German"
      endif
   endif
else
   date_type = "Italian"
endif
*
*- Build return date based on date_type.
*
do case
   case( date_type == "American" )
      date_back = ctod( month_string + '/' + day_string + '/' + year_string )
   case( date_type == "ANSI" )
      date_back = ctod( year_string + '.' + month_string + '.' + day_string )
   case( date_type == "British" )
      date_back = ctod( day_string + '/' + month_string + '/' + year_string )
   case( date_type == "German" )
      date_back = ctod( day_string + '.' + month_string + '.' + year_string )
   case( date_type == "Italian" )
      date_back = ctod( day_string + '-' + month_string + '-' + year_string )
endcase
*
if ! century_on
   set century off
endif
*
return( date_back )
*
*------------------------------------------------------------------------*
*


/*
*------------------------------------------------------------------------*
*                                                                        *
* Program... : STOD.C                                                    *
* Editor.... : Clayton Neff                                              *
* Created... : 10/7/1989 at 13:38                                        *
* Copyright (c) 1986-1989 by Alfa-Laval Agri, Inc.                       *
*                            All Rights Reserved                         *
*                                                                        *
*........................................................................*
*
* - This function takes a string varaible from Clipper and returns
*   a date variable.  Performs the opposite of DTOS().
*
*   NOTE: This routine fails if the memory variable the return value is
*         passed to is not already defined as a date type.  I.E.
*
*           dtemp = StoD( "19900808" )       && Fails
*
*           dtemp = CtoD( '' )
*           dtemp = StoD( "19900808" )       && Works
*
*------------------------------------------------------------------------*
*/

#include "\clip87\nandef.h"
#include "\clip87\extend.h"

CLIPPER STOD()
{
   _retds( _parc(1) ) ;
}

